/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.client.radio.audio;

import com.teamresourceful.resourcefullib.common.utils.WebUtils;
import earth.terrarium.adastra.client.radio.audio.RadioSoundInstance;
import earth.terrarium.adastra.client.radio.audio.RadioStream;
import earth.terrarium.adastra.client.radio.audio.StaticRadioSoundInstance;
import earth.terrarium.adastra.client.radio.screen.RadioScreen;
import earth.terrarium.adastra.mixins.client.SoundEngineAccessor;
import earth.terrarium.adastra.mixins.client.SoundManagerAccessor;
import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.util.HttpUtil;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.Nullable;

public final class RadioHandler {
    private static final Map<String, CompletableFuture<InputStream>> IN_PROGRESS = new ConcurrentHashMap<String, CompletableFuture<InputStream>>();
    private static RadioSoundInstance lastStation = null;

    public static void open(@Nullable BlockPos pos) {
        Minecraft.m_91087_().m_91152_((Screen)new RadioScreen(pos));
    }

    public static CompletableFuture<InputStream> getRadioStream(String url) {
        CompletionStage<InputStream> future = IN_PROGRESS.get(url);
        if (future != null && !future.isDone()) {
            return future;
        }
        future = ((CompletableFuture)RadioHandler.streamRadio(url).handle((value, e) -> {
            if (e != null) {
                throw new CompletionException((Throwable)e);
            }
            return value;
        })).thenApplyAsync(value -> {
            IN_PROGRESS.remove(url);
            return value;
        }, (Executor)Minecraft.m_91087_());
        IN_PROGRESS.put(url, (CompletableFuture<InputStream>)future);
        return future;
    }

    private static CompletableFuture<InputStream> streamRadio(String url) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                HttpResponse response = WebUtils.get((String)url, HttpResponse.BodyHandlers.ofInputStream()).orElse(null);
                if (response == null) {
                    throw new IOException("Radio response was null for: " + url);
                }
                if (response.headers().firstValueAsLong("Content-Length").orElse(-1L) >= 0L) {
                    throw new IOException("Radio response had content length for: " + url + " (" + response.headers().firstValueAsLong("Content-Length").orElse(-1L) + ")");
                }
                return new RadioStream((IoSupplier<InputStream>)((IoSupplier)response::body));
            }
            catch (Throwable e) {
                throw new CompletionException(e);
            }
        }, (Executor)HttpUtil.f_13936_);
    }

    public static void play(String url, RandomSource random, BlockPos pos) {
        RadioHandler.stopRadioInstances();
        lastStation = new StaticRadioSoundInstance(url, random, pos);
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)lastStation);
    }

    public static void play(String url, RandomSource random) {
        RadioHandler.stopRadioInstances();
        lastStation = new RadioSoundInstance(url, random);
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)lastStation);
    }

    public static void stop() {
        RadioHandler.stopRadioInstances();
        lastStation = null;
    }

    private static void stopRadioInstances() {
        SoundManager manager = Minecraft.m_91087_().m_91106_();
        SoundManagerAccessor accessor = (SoundManagerAccessor)manager;
        SoundEngine engine = accessor.getEngine();
        SoundEngineAccessor engineAccessor = (SoundEngineAccessor)engine;
        ArrayList<RadioSoundInstance> radioInstances = new ArrayList<RadioSoundInstance>();
        for (SoundInstance soundInstance : engineAccessor.getSoundChannels().keySet()) {
            if (!(soundInstance instanceof RadioSoundInstance)) continue;
            RadioSoundInstance radioInstance = (RadioSoundInstance)soundInstance;
            radioInstances.add(radioInstance);
        }
        radioInstances.forEach(arg_0 -> ((SoundManager)manager).m_120399_(arg_0));
    }

    public static String getPlaying() {
        if (lastStation == null) {
            return null;
        }
        if (lastStation.m_7801_()) {
            return null;
        }
        if (!Minecraft.m_91087_().m_91106_().m_120403_((SoundInstance)lastStation)) {
            return null;
        }
        return lastStation.url();
    }

    public static RadioSoundInstance getLastStation() {
        return lastStation;
    }
}

