/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.connecting;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.api.predicate.ConnectionDirection;
import com.supermartijn642.fusion.api.predicate.ConnectionPredicate;
import com.supermartijn642.fusion.api.texture.DefaultTextureTypes;
import com.supermartijn642.fusion.api.texture.TextureType;
import com.supermartijn642.fusion.api.texture.data.ConnectingTextureLayout;
import com.supermartijn642.fusion.model.ItemBakedModel;
import com.supermartijn642.fusion.model.types.connecting.ConnectingModelQuad;
import com.supermartijn642.fusion.model.types.connecting.OrientedMutableQuad;
import com.supermartijn642.fusion.model.types.connecting.SurroundingBlockCache;
import com.supermartijn642.fusion.texture.types.connecting.ConnectingTextureSprite;
import com.supermartijn642.fusion.texture.types.connecting.TextureConnections;
import com.supermartijn642.fusion.texture.types.connecting.layouts.ConnectingTextureLayoutHandler;
import com.supermartijn642.fusion.texture.types.continuous.ContinuousTextureSprite;
import com.supermartijn642.fusion.texture.types.continuous.ContinuousTextureType;
import com.supermartijn642.fusion.texture.types.random.RandomTextureSprite;
import com.supermartijn642.fusion.texture.types.random.RandomTextureType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.RenderTypeHelper;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConnectingBakedModel
implements BakedModel {
    public static final ModelProperty<SurroundingBlockCache> BLOCK_CACHE_PROPERTY = new ModelProperty();
    public static final ModelProperty<BlockPos> POSITION_PROPERTY = new ModelProperty();
    private static final int VERTEX_SIZE;
    private static final int VERTEX_UV_OFFSET;
    private static final int VERTEX_POSITION_OFFSET;
    private static final int[][] DEFAULT_TEXTURE_ROTATIONS_UP;
    private static final int[][] DEFAULT_TEXTURE_ROTATIONS_RIGHT;
    private final List<TaggedBakedQuad>[] completeBlockMesh;
    private final List<BakedQuad> completeItemMesh;
    private final Map<RenderType, List<TaggedBakedQuad>[]> blockMesh;
    private final Map<RenderType, List<BakedQuad>> itemMesh;
    private final ChunkRenderTypeSet blockRenderTypes;
    private final List<RenderType> itemRenderTypes;
    private final List<RenderType> itemRenderTypesFabulous;
    private final boolean shouldCheckOriginalItemRenderTypes;
    private final boolean shouldCheckOriginalBlockRenderTypes;
    private final ItemBakedModel itemModel;
    private final List<QuadPredicates> predicates;
    private final List<TextureAtlasSprite> sprites;
    private final boolean hasSpecialQuads;
    private final boolean hasAmbientOcclusion;
    private final boolean isGui3d;
    private final boolean usesBlockLight;
    private final TextureAtlasSprite particleIcon;
    private final ItemTransforms transforms;
    private final ItemOverrides overrides;

    private static float[] getUV(BakedQuad quad, int vertexIndex) {
        int offset = vertexIndex * VERTEX_SIZE + VERTEX_UV_OFFSET;
        return new float[]{Float.intBitsToFloat(quad.m_111303_()[offset]), Float.intBitsToFloat(quad.m_111303_()[offset + 1])};
    }

    private static float[] getPosition(BakedQuad quad, int vertexIndex) {
        int offset = vertexIndex * VERTEX_SIZE + VERTEX_POSITION_OFFSET;
        return new float[]{Float.intBitsToFloat(quad.m_111303_()[offset]), Float.intBitsToFloat(quad.m_111303_()[offset + 1]), Float.intBitsToFloat(quad.m_111303_()[offset + 2])};
    }

    public ConnectingBakedModel(List<ConnectingModelQuad> quads, boolean hasAmbientOcclusion, boolean isGui3d, boolean usesBlockLight, TextureAtlasSprite particleIcon, ItemTransforms transforms, ItemOverrides overrides) {
        this.hasAmbientOcclusion = hasAmbientOcclusion;
        this.isGui3d = isGui3d;
        this.usesBlockLight = usesBlockLight;
        this.particleIcon = particleIcon;
        this.transforms = transforms;
        this.overrides = overrides;
        HashMap<RenderType, List[]> blockMesh = new HashMap<RenderType, List[]>();
        HashSet<RenderType> blockRenderTypes = new HashSet<RenderType>();
        HashMap itemMesh = new HashMap();
        HashSet<RenderType> itemRenderTypes = new HashSet<RenderType>();
        HashSet<RenderType> itemRenderTypesFabulous = new HashSet<RenderType>();
        HashMap<QuadPredicates, Integer> predicates = new HashMap<QuadPredicates, Integer>();
        HashMap<TextureAtlasSprite, Integer> sprites = new HashMap<TextureAtlasSprite, Integer>();
        boolean hasSpecialQuads = false;
        OrientedMutableQuad mutableQuad = new OrientedMutableQuad();
        for (ConnectingModelQuad quad : quads) {
            TextureType<?> textureType = quad.textureType();
            int spriteIndex = -1;
            int predicateIndex = -1;
            int auxiliaryQuadCount = 0;
            if (quad.hasConnectingTexture()) {
                Direction direction = quad.bakedQuad().m_111306_();
                TextureOrientation orientation = ConnectingBakedModel.findOrientation(quad.bakedQuad());
                ConnectionPredicate predicate = quad.connectionPredicate();
                auxiliaryQuadCount = ConnectingTextureLayoutHandler.get(quad.getLayout()).getAuxiliaryQuadCount();
                predicateIndex = predicates.computeIfAbsent(new QuadPredicates(direction, orientation, predicate), o -> predicates.size());
                spriteIndex = sprites.computeIfAbsent(quad.bakedQuad().m_173410_(), o -> sprites.size());
            }
            if (quad.textureType() == DefaultTextureTypes.RANDOM || quad.textureType() == DefaultTextureTypes.CONTINUOUS) {
                spriteIndex = sprites.computeIfAbsent(quad.bakedQuad().m_173410_(), o -> sprites.size());
                hasSpecialQuads = true;
            }
            for (int quadIndex = 0; quadIndex < auxiliaryQuadCount + 1; ++quadIndex) {
                mutableQuad.fillFromBakedQuad(quad.bakedQuad());
                mutableQuad.ambientOcclusion(hasAmbientOcclusion);
                mutableQuad.emissive(quad.emissive());
                if (quad.lightEmission() != null) {
                    for (int i = 0; i < 4; ++i) {
                        int sky = Math.max(quad.lightEmission(), LightTexture.m_109894_((int)mutableQuad.lightmap(i)));
                        int block = Math.max(quad.lightEmission(), LightTexture.m_109883_((int)mutableQuad.lightmap(i)));
                        mutableQuad.lightmap(i, LightTexture.m_109885_((int)sky, (int)block));
                    }
                }
                TaggedBakedQuad finishedQuad = new TaggedBakedQuad(mutableQuad.toBakedQuad(), textureType, spriteIndex, predicateIndex, quadIndex);
                RenderType renderType = FusionClient.getRenderTypeMaterial(quad.renderType());
                blockRenderTypes.add(renderType);
                int cullIndex = ConnectingBakedModel.cullIndex(quad.cullDirection());
                List[] mesh = blockMesh.computeIfAbsent(renderType, r -> new List[7]);
                if (mesh[cullIndex] == null) {
                    mesh[cullIndex] = new ArrayList();
                }
                mesh[cullIndex].add(finishedQuad);
                RenderType itemRenderType = renderType == FusionClient.USE_ORIGINAL_RENDER_TYPE_MARKER ? FusionClient.USE_ORIGINAL_RENDER_TYPE_MARKER : RenderTypeHelper.getEntityRenderType((RenderType)renderType, (boolean)false);
                itemRenderTypes.add(itemRenderType);
                ArrayList<BakedQuad> itemQuads = (ArrayList<BakedQuad>)itemMesh.get(renderType);
                if (itemQuads == null) {
                    itemQuads = new ArrayList<BakedQuad>();
                    itemMesh.put(itemRenderType, itemQuads);
                    RenderType fabulousRenderType = renderType == FusionClient.USE_ORIGINAL_RENDER_TYPE_MARKER ? FusionClient.USE_ORIGINAL_RENDER_TYPE_MARKER : RenderTypeHelper.getEntityRenderType((RenderType)renderType, (boolean)true);
                    itemRenderTypesFabulous.add(fabulousRenderType);
                    itemMesh.put(fabulousRenderType, itemQuads);
                }
                if (quad.hasConnectingTexture()) {
                    mutableQuad.set(TextureOrientation.NORMAL_0.vertexIndexPermutation);
                    boolean keepQuad = ConnectingTextureLayoutHandler.get(quad.getLayout()).processItemQuad(quadIndex, mutableQuad, (ConnectingTextureSprite)quad.bakedQuad().m_173410_());
                    mutableQuad.resetPermutation();
                    if (!keepQuad) continue;
                }
                itemQuads.add(mutableQuad.toBakedQuad());
            }
        }
        this.blockMesh = Map.copyOf(blockMesh);
        this.blockRenderTypes = ChunkRenderTypeSet.of(blockRenderTypes.stream().filter(r -> r != FusionClient.USE_ORIGINAL_RENDER_TYPE_MARKER).toList());
        this.shouldCheckOriginalBlockRenderTypes = blockRenderTypes.contains(FusionClient.USE_ORIGINAL_RENDER_TYPE_MARKER);
        this.itemMesh = Map.copyOf(itemMesh);
        this.itemRenderTypes = itemRenderTypes.stream().filter(r -> r != FusionClient.USE_ORIGINAL_RENDER_TYPE_MARKER).toList();
        this.itemRenderTypesFabulous = itemRenderTypesFabulous.stream().filter(r -> r != FusionClient.USE_ORIGINAL_RENDER_TYPE_MARKER).toList();
        this.shouldCheckOriginalItemRenderTypes = itemRenderTypes.contains(FusionClient.USE_ORIGINAL_RENDER_TYPE_MARKER);
        this.predicates = predicates.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).toList();
        this.sprites = sprites.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).toList();
        this.hasSpecialQuads = hasSpecialQuads;
        this.completeBlockMesh = new List[7];
        for (int i = 0; i < 7; ++i) {
            int cullIndex = i;
            this.completeBlockMesh[i] = this.blockMesh.values().stream().map(arr -> arr[cullIndex]).filter(Objects::nonNull).flatMap(Collection::stream).toList();
        }
        this.completeItemMesh = itemRenderTypes.stream().map(this.itemMesh::get).flatMap(Collection::stream).toList();
        this.itemModel = new ItemBakedModel(this){

            @Override
            protected List<BakedQuad> getQuads(ItemStack stack, boolean fabulous, @NotNull RandomSource random, @NotNull ModelData data, @Nullable RenderType renderType) {
                List<BakedQuad> additionalQuads;
                if (renderType == null) {
                    return ConnectingBakedModel.this.completeItemMesh;
                }
                List<BakedQuad> quads = ConnectingBakedModel.this.itemMesh.get(renderType);
                if (ConnectingBakedModel.this.shouldCheckOriginalItemRenderTypes && 1.getNonModelRenderType(stack, fabulous) == renderType && (additionalQuads = ConnectingBakedModel.this.itemMesh.get(FusionClient.USE_ORIGINAL_RENDER_TYPE_MARKER)) != null) {
                    if (quads == null) {
                        quads = additionalQuads;
                    } else {
                        ArrayList<BakedQuad> combined = new ArrayList<BakedQuad>(quads.size() + additionalQuads.size());
                        combined.addAll(quads);
                        combined.addAll(additionalQuads);
                        quads = combined;
                    }
                }
                return quads == null ? Collections.emptyList() : quads;
            }
        };
    }

    private static TextureOrientation findOrientation(BakedQuad quad) {
        double angle1to3;
        float[][] uvs = new float[][]{ConnectingBakedModel.getUV(quad, 0), ConnectingBakedModel.getUV(quad, 1), ConnectingBakedModel.getUV(quad, 2), ConnectingBakedModel.getUV(quad, 3)};
        double angle1to2 = Math.atan2(uvs[1][1] - uvs[0][1], uvs[1][0] - uvs[0][0]);
        boolean textureFlipped = (angle1to2 - (angle1to3 = Math.atan2(uvs[2][1] - uvs[0][1], uvs[2][0] - uvs[0][0])) + Math.PI * 4) % (Math.PI * 2) < Math.PI;
        int topLeftMostIndex = 0;
        for (int i = 1; i < 4; ++i) {
            float[] current = uvs[i];
            float[] best = uvs[topLeftMostIndex];
            if (!(current[0] + current[1] < best[0] + best[1])) continue;
            topLeftMostIndex = i;
        }
        int textureRotation = textureFlipped ? topLeftMostIndex : (4 - topLeftMostIndex) % 4;
        float[][] positions3d = new float[][]{ConnectingBakedModel.getPosition(quad, 0), ConnectingBakedModel.getPosition(quad, 1), ConnectingBakedModel.getPosition(quad, 2), ConnectingBakedModel.getPosition(quad, 3)};
        float[][] pos = new float[4][2];
        Direction direction = quad.m_111306_();
        for (int i = 0; i < 4; ++i) {
            if (direction == Direction.DOWN) {
                pos[i][0] = positions3d[i][0];
                pos[i][1] = -positions3d[i][2];
                continue;
            }
            if (direction == Direction.UP) {
                pos[i][0] = positions3d[i][0];
                pos[i][1] = positions3d[i][2];
                continue;
            }
            if (direction == Direction.NORTH) {
                pos[i][0] = -positions3d[i][0];
                pos[i][1] = -positions3d[i][1];
                continue;
            }
            if (direction == Direction.SOUTH) {
                pos[i][0] = positions3d[i][0];
                pos[i][1] = -positions3d[i][1];
                continue;
            }
            if (direction == Direction.WEST) {
                pos[i][0] = positions3d[i][2];
                pos[i][1] = -positions3d[i][1];
                continue;
            }
            if (direction != Direction.EAST) continue;
            pos[i][0] = -positions3d[i][2];
            pos[i][1] = -positions3d[i][1];
        }
        angle1to2 = Math.atan2(pos[1][1] - pos[0][1], pos[1][0] - pos[0][0]);
        boolean quadFlipped = (angle1to2 - (angle1to3 = Math.atan2(pos[2][1] - pos[0][1], pos[2][0] - pos[0][0])) + Math.PI * 4) % (Math.PI * 2) < Math.PI;
        topLeftMostIndex = 0;
        for (int i = 1; i < 4; ++i) {
            float[] current = pos[i];
            float[] best = pos[topLeftMostIndex];
            if (!(current[0] + current[1] < best[0] + best[1])) continue;
            topLeftMostIndex = i;
        }
        int quadRotation = textureFlipped ? topLeftMostIndex : 4 - topLeftMostIndex;
        boolean flipped = textureFlipped ^ quadFlipped;
        int rotation = quadFlipped ? (4 - textureRotation + quadRotation) % 4 : (textureRotation + quadRotation) % 4;
        return TextureOrientation.of(flipped, rotation);
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction cullDirection, RandomSource random, ModelData data, @Nullable RenderType renderType) {
        ArrayList<TaggedBakedQuad> quads;
        if (renderType == null) {
            quads = this.completeBlockMesh[ConnectingBakedModel.cullIndex(cullDirection)];
        } else {
            List<TaggedBakedQuad>[] mesh = this.blockMesh.get(renderType);
            List<TaggedBakedQuad> list = quads = mesh == null ? null : mesh[ConnectingBakedModel.cullIndex(cullDirection)];
            if (this.shouldCheckOriginalBlockRenderTypes && state != null && ItemBlockRenderTypes.getRenderLayers((BlockState)state).contains(renderType)) {
                Iterator<TaggedBakedQuad> additionalQuads;
                mesh = this.blockMesh.get(FusionClient.USE_ORIGINAL_RENDER_TYPE_MARKER);
                Iterator<TaggedBakedQuad> iterator = additionalQuads = mesh == null ? null : mesh[ConnectingBakedModel.cullIndex(cullDirection)];
                if (additionalQuads != null) {
                    if (quads == null) {
                        quads = additionalQuads;
                    } else {
                        ArrayList<TaggedBakedQuad> combined = new ArrayList<TaggedBakedQuad>(quads.size() + additionalQuads.size());
                        combined.addAll(quads);
                        combined.addAll((Collection<TaggedBakedQuad>)((Object)additionalQuads));
                        quads = combined;
                    }
                }
            }
            if (quads == null) {
                quads = Collections.emptyList();
            }
        }
        if (this.predicates.isEmpty() && !this.hasSpecialQuads) {
            ArrayList<BakedQuad> bakedQuads = new ArrayList<BakedQuad>(quads.size());
            for (TaggedBakedQuad quad : quads) {
                bakedQuads.add(quad.bakedQuad);
            }
            return bakedQuads;
        }
        BlockPos pos = (BlockPos)data.get(POSITION_PROPERTY);
        SurroundingBlockCache blockCache = (SurroundingBlockCache)data.get(BLOCK_CACHE_PROPERTY);
        if (!(blockCache != null && !this.predicates.isEmpty() || pos != null && this.hasSpecialQuads)) {
            ArrayList<BakedQuad> bakedQuads = new ArrayList<BakedQuad>(quads.size());
            for (TaggedBakedQuad quad : quads) {
                bakedQuads.add(quad.bakedQuad);
            }
            return bakedQuads;
        }
        if (state != null && blockCache != null) {
            blockCache.setSelf(state);
        }
        TextureConnections[] connectionsCache = new TextureConnections[this.predicates.size()];
        ArrayList<BakedQuad> bakedQuads = new ArrayList<BakedQuad>(quads.size());
        OrientedMutableQuad mutableQuad = new OrientedMutableQuad();
        for (TaggedBakedQuad quad : quads) {
            if (pos != null && (quad.textureType == DefaultTextureTypes.RANDOM || quad.textureType == DefaultTextureTypes.CONTINUOUS)) {
                TextureAtlasSprite sprite = this.sprites.get(quad.spriteIndex);
                mutableQuad.fillFromBakedQuad(quad.bakedQuad);
                mutableQuad.resetPermutation();
                if (quad.textureType == DefaultTextureTypes.RANDOM) {
                    RandomTextureType.processQuad(mutableQuad, pos, quad.bakedQuad.m_111306_(), random, (RandomTextureSprite)sprite);
                } else {
                    ContinuousTextureType.processQuad(mutableQuad, pos, quad.bakedQuad.m_111306_(), (ContinuousTextureSprite)sprite);
                }
                bakedQuads.add(mutableQuad.toBakedQuad());
                continue;
            }
            if (blockCache != null && quad.textureType == DefaultTextureTypes.CONNECTING) {
                int quadIndex = quad.quadIndex;
                int predicateIndex = quad.predicateIndex;
                int spriteIndex = quad.spriteIndex;
                QuadPredicates predicate = this.predicates.get(predicateIndex);
                TextureConnections connections = connectionsCache[predicateIndex];
                if (connections == null) {
                    connections = connectionsCache[predicateIndex] = ConnectingBakedModel.computeConnections(predicate, blockCache);
                }
                TextureAtlasSprite sprite = this.sprites.get(spriteIndex);
                ConnectingTextureLayout layout = ((ConnectingTextureSprite)sprite).data().getLayout();
                mutableQuad.fillFromBakedQuad(quad.bakedQuad);
                mutableQuad.set(predicate.orientation.vertexIndexPermutation);
                boolean keepQuad = ConnectingTextureLayoutHandler.get(layout).processBlockQuad(quadIndex, mutableQuad, (ConnectingTextureSprite)sprite, connections);
                if (!keepQuad) continue;
                bakedQuads.add(mutableQuad.toBakedQuad());
                continue;
            }
            bakedQuads.add(quad.bakedQuad);
        }
        return bakedQuads;
    }

    private static TextureConnections computeConnections(QuadPredicates predicates, SurroundingBlockCache blocks) {
        ConnectionPredicate predicate = predicates.predicate;
        Direction face = predicates.direction;
        TextureOrientation orientation = predicates.orientation;
        int[] up = orientation.transformWorldVector(DEFAULT_TEXTURE_ROTATIONS_UP[face.ordinal()], face);
        int[] right = orientation.transformWorldVector(DEFAULT_TEXTURE_ROTATIONS_RIGHT[face.ordinal()], face);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        boolean connectTop = ConnectingBakedModel.shouldConnect(predicate, blocks, face, orientation.worldToTexture[0], up[0], up[1], up[2], mutablePos);
        boolean connectTopRight = ConnectingBakedModel.shouldConnect(predicate, blocks, face, orientation.worldToTexture[1], up[0] + right[0], up[1] + right[1], up[2] + right[2], mutablePos);
        boolean connectRight = ConnectingBakedModel.shouldConnect(predicate, blocks, face, orientation.worldToTexture[2], right[0], right[1], right[2], mutablePos);
        boolean connectBottomRight = ConnectingBakedModel.shouldConnect(predicate, blocks, face, orientation.worldToTexture[3], -up[0] + right[0], -up[1] + right[1], -up[2] + right[2], mutablePos);
        boolean connectBottom = ConnectingBakedModel.shouldConnect(predicate, blocks, face, orientation.worldToTexture[4], -up[0], -up[1], -up[2], mutablePos);
        boolean connectBottomLeft = ConnectingBakedModel.shouldConnect(predicate, blocks, face, orientation.worldToTexture[5], -up[0] - right[0], -up[1] - right[1], -up[2] - right[2], mutablePos);
        boolean connectLeft = ConnectingBakedModel.shouldConnect(predicate, blocks, face, orientation.worldToTexture[6], -right[0], -right[1], -right[2], mutablePos);
        boolean connectTopLeft = ConnectingBakedModel.shouldConnect(predicate, blocks, face, orientation.worldToTexture[7], up[0] - right[0], up[1] - right[1], up[2] - right[2], mutablePos);
        return new TextureConnections(connectTop, connectTopRight, connectRight, connectBottomRight, connectBottom, connectBottomLeft, connectLeft, connectTopLeft);
    }

    private static boolean shouldConnect(ConnectionPredicate predicate, SurroundingBlockCache blocks, Direction face, ConnectionDirection direction, int neighborX, int neighborY, int neighborZ, BlockPos.MutableBlockPos mutablePos) {
        BlockAndTintGetter level = blocks.getLevel();
        BlockPos position = blocks.getRealPos();
        BlockState self = blocks.getCenter();
        BlockState neighborState = blocks.getState(neighborX, neighborY, neighborZ);
        mutablePos.m_122178_(position.m_123341_() + neighborX, position.m_123342_() + neighborY, position.m_123343_() + neighborZ);
        BlockState selfAppearance = self.getAppearance(level, position, face, neighborState, (BlockPos)mutablePos);
        BlockState otherStateAppearance = neighborState.getAppearance(level, (BlockPos)mutablePos, face, self, position);
        BlockState stateInFront = blocks.getState(neighborX + face.m_122429_(), neighborY + face.m_122430_(), neighborZ + face.m_122431_());
        return predicate.shouldConnect((BlockGetter)level, position, face, selfAppearance, otherStateAppearance, stateInFront, direction);
    }

    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, RandomSource random) {
        return this.getQuads(state, side, random, ModelData.EMPTY, null);
    }

    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        if (this.shouldCheckOriginalBlockRenderTypes) {
            return ChunkRenderTypeSet.union((ChunkRenderTypeSet[])new ChunkRenderTypeSet[]{ItemBlockRenderTypes.getRenderLayers((BlockState)state), this.blockRenderTypes});
        }
        return this.blockRenderTypes;
    }

    public List<RenderType> getRenderTypes(ItemStack stack, boolean fabulous) {
        RenderType renderType;
        if (this.shouldCheckOriginalItemRenderTypes && !(fabulous ? this.itemRenderTypesFabulous : this.itemRenderTypes).contains(renderType = ItemBakedModel.getNonModelRenderType(stack, fabulous))) {
            ArrayList<RenderType> combined = new ArrayList<RenderType>((fabulous ? this.itemRenderTypesFabulous : this.itemRenderTypes).size() + 1);
            combined.addAll(fabulous ? this.itemRenderTypesFabulous : this.itemRenderTypes);
            combined.add(renderType);
            return combined;
        }
        return fabulous ? this.itemRenderTypesFabulous : this.itemRenderTypes;
    }

    public List<BakedModel> getRenderPasses(ItemStack stack, boolean fabulous) {
        this.itemModel.set(stack, fabulous);
        return this.itemModel.asList();
    }

    public ModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData data) {
        if (this.predicates.isEmpty() && !this.hasSpecialQuads) {
            return ModelData.EMPTY;
        }
        ModelData.Builder builder = ModelData.builder();
        if (this.hasSpecialQuads) {
            builder.with(POSITION_PROPERTY, (Object)pos);
        }
        if (!this.predicates.isEmpty()) {
            SurroundingBlockCache blockCache = new SurroundingBlockCache(level, pos, state);
            blockCache.fillAll();
            builder.with(BLOCK_CACHE_PROPERTY, (Object)blockCache);
        }
        return builder.build();
    }

    public boolean m_7541_() {
        return this.hasAmbientOcclusion;
    }

    public boolean m_7539_() {
        return this.isGui3d;
    }

    public boolean m_7547_() {
        return this.usesBlockLight;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.particleIcon;
    }

    public ItemTransforms m_7442_() {
        return this.transforms;
    }

    public ItemOverrides m_7343_() {
        return this.overrides;
    }

    private static int cullIndex(Direction cullDirection) {
        return cullDirection == null ? 0 : cullDirection.ordinal() + 1;
    }

    static {
        DEFAULT_TEXTURE_ROTATIONS_UP = new int[6][];
        DEFAULT_TEXTURE_ROTATIONS_RIGHT = new int[6][];
        VertexFormat blockFormat = DefaultVertexFormat.f_85811_;
        VERTEX_SIZE = blockFormat.m_86020_() / 4;
        VERTEX_UV_OFFSET = blockFormat.getOffset(blockFormat.m_86023_().indexOf((Object)DefaultVertexFormat.f_166849_)) / 4;
        VERTEX_POSITION_OFFSET = blockFormat.getOffset(blockFormat.m_86023_().indexOf((Object)DefaultVertexFormat.f_85804_)) / 4;
        for (Direction direction : Direction.values()) {
            int upX = 0;
            int upY = 0;
            int upZ = 0;
            int rightX = 0;
            int rightY = 0;
            int rightZ = 0;
            if (direction == Direction.DOWN) {
                upZ = 1;
                rightX = 1;
            } else if (direction == Direction.UP) {
                upZ = -1;
                rightX = 1;
            } else if (direction == Direction.NORTH) {
                upY = 1;
                rightX = -1;
            } else if (direction == Direction.SOUTH) {
                upY = 1;
                rightX = 1;
            } else if (direction == Direction.WEST) {
                upY = 1;
                rightZ = 1;
            } else if (direction == Direction.EAST) {
                upY = 1;
                rightZ = -1;
            }
            ConnectingBakedModel.DEFAULT_TEXTURE_ROTATIONS_UP[direction.ordinal()] = new int[]{upX, upY, upZ};
            ConnectingBakedModel.DEFAULT_TEXTURE_ROTATIONS_RIGHT[direction.ordinal()] = new int[]{rightX, rightY, rightZ};
        }
    }

    private static enum TextureOrientation {
        NORMAL_0(false, 0),
        NORMAL_90(false, 1),
        NORMAL_180(false, 2),
        NORMAL_270(false, 3),
        FLIPPED_0(true, 0),
        FLIPPED_90(false, 1),
        FLIPPED_180(true, 2),
        FLIPPED_270(true, 3);

        public final boolean flipped;
        public final int rotations;
        public final ConnectionDirection[] worldToTexture;
        public final int[] vertexIndexPermutation;

        public static TextureOrientation of(boolean flipped, int rotations) {
            return TextureOrientation.values()[flipped ? 4 + rotations : rotations];
        }

        private TextureOrientation(boolean flipped, int rotations) {
            this.flipped = flipped;
            this.rotations = rotations;
            this.worldToTexture = ConnectionDirection.values();
            this.vertexIndexPermutation = new int[]{0, 3, 2, 1};
            if (flipped) {
                this.worldToTexture[ConnectionDirection.TOP.ordinal()] = ConnectionDirection.LEFT;
                this.worldToTexture[ConnectionDirection.TOP_RIGHT.ordinal()] = ConnectionDirection.BOTTOM_LEFT;
                this.worldToTexture[ConnectionDirection.RIGHT.ordinal()] = ConnectionDirection.BOTTOM;
                this.worldToTexture[ConnectionDirection.LEFT.ordinal()] = ConnectionDirection.TOP;
                this.worldToTexture[ConnectionDirection.BOTTOM_LEFT.ordinal()] = ConnectionDirection.TOP_RIGHT;
                this.worldToTexture[ConnectionDirection.BOTTOM.ordinal()] = ConnectionDirection.RIGHT;
                this.vertexIndexPermutation[1] = 1;
                this.vertexIndexPermutation[3] = 3;
            }
            if (rotations != 0) {
                ConnectionDirection[] old = Arrays.copyOf(this.worldToTexture, this.worldToTexture.length);
                for (int i = 0; i < 8; ++i) {
                    this.worldToTexture[i] = old[(i - rotations * 2 + 8) % 8];
                }
                int[] old2 = Arrays.copyOf(this.vertexIndexPermutation, this.vertexIndexPermutation.length);
                for (int i = 0; i < 4; ++i) {
                    this.vertexIndexPermutation[i] = old2[(i + rotations + 4) % 4];
                }
            }
        }

        public int[] transformWorldVector(int[] vector, Direction face) {
            boolean positive;
            if (!this.flipped && this.rotations == 0) {
                return vector;
            }
            int[] newVector = Arrays.copyOf(vector, vector.length);
            Direction.Axis axis = face.m_122434_();
            boolean bl = positive = face.m_122421_() == Direction.AxisDirection.POSITIVE;
            if (this.flipped) {
                if (face.m_122434_() == Direction.Axis.X) {
                    newVector[1] = positive ? vector[2] : -vector[2];
                    int n = newVector[2] = positive ? vector[1] : -vector[1];
                }
                if (face.m_122434_() == Direction.Axis.Y) {
                    newVector[0] = positive ? vector[2] : -vector[2];
                    int n = newVector[2] = positive ? vector[0] : -vector[0];
                }
                if (face.m_122434_() == Direction.Axis.Z) {
                    newVector[0] = positive ? vector[1] : -vector[1];
                    int n = newVector[1] = positive ? vector[0] : -vector[0];
                }
            }
            if (this.rotations > 0) {
                if (this.rotations == 2) {
                    if (axis != Direction.Axis.X) {
                        newVector[0] = -newVector[0];
                    }
                    if (axis != Direction.Axis.Y) {
                        newVector[1] = -newVector[1];
                    }
                    if (axis != Direction.Axis.Z) {
                        newVector[2] = -newVector[2];
                    }
                } else {
                    int oldX = newVector[0];
                    int oldY = newVector[1];
                    if (axis != Direction.Axis.X) {
                        newVector[0] = (positive ^ this.rotations == 3 ? 1 : -1) * (axis == Direction.Axis.Y ? -newVector[2] : newVector[1]);
                    }
                    if (axis != Direction.Axis.Y) {
                        newVector[1] = (positive ^ this.rotations == 3 ? 1 : -1) * (axis == Direction.Axis.Z ? -oldX : newVector[2]);
                    }
                    if (axis != Direction.Axis.Z) {
                        newVector[2] = (positive ^ this.rotations == 3 ? 1 : -1) * (axis == Direction.Axis.X ? -oldY : oldX);
                    }
                }
            }
            return newVector;
        }
    }

    private static class QuadPredicates {
        public final Direction direction;
        public final TextureOrientation orientation;
        public final ConnectionPredicate predicate;

        private QuadPredicates(Direction direction, TextureOrientation orientation, ConnectionPredicate predicate) {
            this.direction = direction;
            this.orientation = orientation;
            this.predicate = predicate;
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof QuadPredicates)) {
                return false;
            }
            QuadPredicates that = (QuadPredicates)o;
            return this.direction == that.direction && this.orientation == that.orientation && this.predicate.equals(that.predicate);
        }

        public int hashCode() {
            int result = this.direction.hashCode();
            result = 31 * result + this.orientation.hashCode();
            result = 31 * result + this.predicate.hashCode();
            return result;
        }
    }

    private static class TaggedBakedQuad {
        final BakedQuad bakedQuad;
        final TextureType<?> textureType;
        final int spriteIndex;
        final int predicateIndex;
        final int quadIndex;

        private TaggedBakedQuad(BakedQuad bakedQuad, TextureType<?> textureType, int spriteIndex, int predicateIndex, int quadIndex) {
            this.bakedQuad = bakedQuad;
            this.textureType = textureType;
            this.spriteIndex = spriteIndex;
            this.predicateIndex = predicateIndex;
            this.quadIndex = quadIndex;
        }
    }
}

