/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.entry.comparison;

import com.google.common.base.Predicates;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.api.common.entry.comparison.EntryComparator;
import me.shedaniel.rei.impl.Internals;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public enum NbtHasherProviderImpl implements Internals.NbtHasherProvider
{
    INSTANCE;

    private final EntryComparator<Tag> defaultHasher = this._provide(new String[0]);

    @Override
    public EntryComparator<Tag> provide(String ... ignoredKeys) {
        if (ignoredKeys == null || ignoredKeys.length == 0) {
            return this.defaultHasher;
        }
        return this._provide(ignoredKeys);
    }

    private EntryComparator<Tag> _provide(String ... ignoredKeys) {
        return new Hasher(ignoredKeys);
    }

    private static class Hasher
    implements EntryComparator<Tag> {
        private final Predicate<String> filter;

        private Hasher(@Nullable String[] ignoredKeys) {
            if (ignoredKeys == null || ignoredKeys.length == 0) {
                this.filter = key -> true;
            } else if (ignoredKeys.length == 1) {
                String s = ignoredKeys[0];
                this.filter = key -> !Objects.equals(s, key);
            } else {
                HashSet<String> set = new HashSet<String>(Arrays.asList(ignoredKeys));
                this.filter = Predicates.not(set::contains);
            }
        }

        private boolean shouldHash(String key) {
            return this.filter.test(key);
        }

        @Override
        public long hash(ComparisonContext context, Tag value) {
            return this.hashTag(value);
        }

        private int hashTag(Tag tag) {
            if (tag == null) {
                return 0;
            }
            if (tag instanceof ListTag) {
                ListTag list = (ListTag)tag;
                return this.hashListTag(list);
            }
            if (tag instanceof CompoundTag) {
                CompoundTag compound = (CompoundTag)tag;
                return this.hashCompoundTag(compound);
            }
            return tag.hashCode();
        }

        private int hashListTag(ListTag tag) {
            int i = tag.size();
            for (Tag innerTag : tag) {
                i = i * 31 + this.hashTag(innerTag);
            }
            return i;
        }

        private int hashCompoundTag(CompoundTag tag) {
            int i = 1;
            for (Map.Entry entry : tag.f_128329_.entrySet()) {
                if (!this.shouldHash((String)entry.getKey())) continue;
                i = i * 31 + (Objects.hashCode(entry.getKey()) ^ this.hashTag((Tag)entry.getValue()));
            }
            return i;
        }
    }
}

