/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.config;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.platform.InputConstants;
import dev.architectury.utils.value.IntValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.shedaniel.clothconfig2.api.Modifier;
import me.shedaniel.clothconfig2.api.ModifierKeyCode;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.REIRuntimeImpl;
import me.shedaniel.rei.impl.client.config.ConfigManagerImpl;
import me.shedaniel.rei.impl.client.config.ConfigObjectImpl;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.config.ConfigAccess;
import me.shedaniel.rei.impl.client.gui.config.components.ConfigCategoriesListWidget;
import me.shedaniel.rei.impl.client.gui.config.components.ConfigEntriesListWidget;
import me.shedaniel.rei.impl.client.gui.config.components.ConfigSearchListWidget;
import me.shedaniel.rei.impl.client.gui.config.options.AllREIConfigCategories;
import me.shedaniel.rei.impl.client.gui.config.options.CompositeOption;
import me.shedaniel.rei.impl.client.gui.config.options.ConfigUtils;
import me.shedaniel.rei.impl.client.gui.config.options.OptionCategory;
import me.shedaniel.rei.impl.client.gui.config.options.OptionGroup;
import me.shedaniel.rei.impl.client.gui.modules.Menu;
import me.shedaniel.rei.impl.client.gui.widget.HoleWidget;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.TextFieldWidget;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

public class REIConfigScreen
extends Screen
implements ConfigAccess {
    private final Screen parent;
    private final List<OptionCategory> categories;
    private final List<Widget> widgets = new ArrayList<Widget>();
    private final Map<String, ?> defaultOptions = new HashMap();
    private final Map<String, ?> options = new HashMap();
    private OptionCategory activeCategory;
    private boolean searching;
    @Nullable
    private Menu menu;
    @Nullable
    private Widget menuWidget;
    @Nullable
    private CompositeOption<ModifierKeyCode> focusedKeycodeOption = null;
    private ModifierKeyCode partialKeycode = null;

    public REIConfigScreen(Screen parent) {
        this(parent, AllREIConfigCategories.CATEGORIES);
    }

    public REIConfigScreen(Screen parent, List<OptionCategory> categories) {
        super((Component)Component.m_237115_((String)"config.roughlyenoughitems.title"));
        this.parent = parent;
        this.categories = CollectionUtils.map(categories, OptionCategory::copy);
        this.cleanRequiresLevel();
        Preconditions.checkArgument((!this.categories.isEmpty() ? 1 : 0) != 0, (Object)"Categories cannot be empty!");
        this.activeCategory = this.categories.get(0);
        ConfigObjectImpl defaultConfig = new ConfigObjectImpl();
        ConfigObjectImpl config = ConfigManagerImpl.getInstance().getConfig();
        for (OptionCategory category : this.categories) {
            for (OptionGroup group : category.getGroups()) {
                for (CompositeOption<?> option : group.getOptions()) {
                    this.defaultOptions.put(option.getId(), option.getBind().apply(defaultConfig));
                    this.options.put(option.getId(), option.getBind().apply(config));
                }
            }
        }
    }

    private void cleanRequiresLevel() {
        if (REIRuntime.getInstance().getPreviousContainerScreen() != null && Minecraft.m_91087_().m_91403_() != null && Minecraft.m_91087_().m_91403_().m_105141_() != null) {
            return;
        }
        for (OptionCategory category : this.categories) {
            for (OptionGroup group : category.getGroups()) {
                group.getOptions().replaceAll(option -> {
                    if (option.isRequiresLevel()) {
                        return new CompositeOption<Integer>(option.getId(), option.getName(), option.getDescription(), i -> 0, (i, v) -> new Object()).entry(value -> ConfigUtils.translatable("config.rei.texts.requires_level").m_130940_(ChatFormatting.RED)).defaultValue(() -> 1);
                    }
                    return option;
                });
            }
        }
    }

    public void m_7856_() {
        super.m_7856_();
        this.widgets.clear();
        this.widgets.add(Widgets.createLabel(new Point(this.f_96543_ / 2, 12), this.f_96539_));
        int sideWidth = (int)Math.round((double)this.f_96543_ / 4.2);
        if (this.searching) {
            this.widgets.add(Widgets.createButton(new Rectangle(8, 32, sideWidth, 20), (Component)ConfigUtils.literal("\u21a9 ").m_7220_((Component)ConfigUtils.translatable("gui.back"))).onClick(button -> this.setSearching(false)));
            this.widgets.add(HoleWidget.createBackground(new Rectangle(8 + sideWidth + 4, 32, this.f_96543_ - 16 - sideWidth - 4, 20), () -> 0, 32));
            TextFieldWidget textField = new TextFieldWidget(new Rectangle(8 + sideWidth + 4 + 6, 38, this.f_96543_ - 16 - sideWidth - 4 - 10, 12)){

                @Override
                protected void renderSuggestion(GuiGraphics graphics, int x, int y) {
                    int color = this.containsMouse(PointHelper.ofMouse()) || this.m_93696_() ? -571806998 : -6250336;
                    graphics.m_280488_(this.font, this.font.m_92834_(this.getSuggestion(), this.getWidth()), x, y, color);
                }
            };
            textField.setHasBorder(false);
            textField.setMaxLength(9000);
            this.widgets.add(textField);
            this.widgets.add(Widgets.createDrawableWidget((graphics, mouseX, mouseY, delta) -> {
                textField.setSuggestion(!textField.m_93696_() && textField.getText().isEmpty() ? I18n.m_118938_((String)"config.rei.texts.search_options", (Object[])new Object[0]) : null);
                if (!textField.m_93696_()) {
                    return;
                }
                Rectangle bounds = textField.getBounds();
                graphics.m_280509_(bounds.x - 6, bounds.y - 6, bounds.getMaxX() + 4, bounds.y - 5, -2039584);
                graphics.m_280509_(bounds.x - 6, bounds.getMaxY() + 1, bounds.getMaxX() + 4, bounds.getMaxY() + 2, -2039584);
                graphics.m_280509_(bounds.x - 6, bounds.y - 6, bounds.x - 7, bounds.getMaxY() + 2, -2039584);
                graphics.m_280509_(bounds.getMaxX() + 3, bounds.y - 6, bounds.getMaxX() + 4, bounds.getMaxY() + 2, -2039584);
            }));
            this.widgets.add(ConfigSearchListWidget.create(this, this.categories, textField, new Rectangle(8, 56, this.f_96543_ - 16, this.f_96544_ - 32 - 56)));
        } else {
            boolean singlePane = this.f_96543_ - 20 - sideWidth <= 330;
            int singleSideWidth = 42;
            MutableObject list = new MutableObject((Object)this.createEntriesList(singlePane, singleSideWidth, sideWidth));
            IntValue selectedCategory = new IntValue(){
                final /* synthetic */ Mutable val$list;
                final /* synthetic */ boolean val$singlePane;
                final /* synthetic */ int val$singleSideWidth;
                final /* synthetic */ int val$sideWidth;
                {
                    this.val$list = mutable;
                    this.val$singlePane = bl;
                    this.val$singleSideWidth = n;
                    this.val$sideWidth = n2;
                }

                public void accept(int index) {
                    REIConfigScreen.this.activeCategory = REIConfigScreen.this.categories.get(index);
                    this.val$list.setValue((Object)REIConfigScreen.this.createEntriesList(this.val$singlePane, this.val$singleSideWidth, this.val$sideWidth));
                }

                public int getAsInt() {
                    return REIConfigScreen.this.categories.indexOf(REIConfigScreen.this.activeCategory);
                }
            };
            if (!singlePane) {
                this.widgets.add(ConfigCategoriesListWidget.create(new Rectangle(8, 32, sideWidth, this.f_96544_ - 32 - 32), this.categories, selectedCategory));
            } else {
                this.widgets.add(ConfigCategoriesListWidget.createTiny(new Rectangle(8, 32, singleSideWidth - 4, this.f_96544_ - 32 - 32), this.categories, selectedCategory));
            }
            this.widgets.add(Widgets.delegate(() -> ((Mutable)list).getValue()));
        }
        this.widgets.add(Widgets.createButton(new Rectangle(this.f_96543_ / 2 - 150 - 10, this.f_96544_ - 26, 150, 20), (Component)ConfigUtils.translatable("gui.cancel")).onClick(button -> Minecraft.m_91087_().m_91152_(this.parent)));
        this.widgets.add(Widgets.createButton(new Rectangle(this.f_96543_ / 2 + 10, this.f_96544_ - 26, 150, 20), (Component)ConfigUtils.translatable("gui.done")).onClick(button -> {
            for (OptionCategory optionCategory : this.categories) {
                for (OptionGroup group : optionCategory.getGroups()) {
                    for (CompositeOption<?> option : group.getOptions()) {
                        option.getSave().accept(ConfigManagerImpl.getInstance().getConfig(), this.get(option));
                    }
                }
            }
            ConfigManagerImpl.getInstance().saveConfig();
            EntryRegistry.getInstance().refilter();
            REIRuntime.getInstance().getOverlay().ifPresent(ScreenOverlay::queueReloadOverlay);
            if (REIRuntimeImpl.getSearchField() != null) {
                ScreenOverlayImpl.getEntryListWidget().updateSearch(REIRuntimeImpl.getSearchField().getText(), true);
            }
            Minecraft.m_91087_().m_91152_(this.parent);
        }));
    }

    private Widget createEntriesList(boolean singlePane, int singleSideWidth, int sideWidth) {
        return ConfigEntriesListWidget.create(this, new Rectangle(singlePane ? 8 + singleSideWidth : 12 + sideWidth, 32, singlePane ? this.f_96543_ - 16 - singleSideWidth : this.f_96543_ - 20 - sideWidth, this.f_96544_ - 32 - 32), this.activeCategory.getGroups());
    }

    public Map<String, ?> getDefaultOptions() {
        return this.defaultOptions;
    }

    public Map<String, ?> getOptions() {
        return this.options;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.m_280039_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, delta);
        for (Widget widget : this.widgets) {
            widget.m_88315_(graphics, mouseX, mouseY, delta);
        }
        ScreenOverlayImpl.getInstance().lateRender(graphics, mouseX, mouseY, delta);
    }

    public void m_7379_() {
        if (this.searching) {
            this.setSearching(false);
        } else {
            this.f_96541_.m_91152_(this.parent);
        }
    }

    public List<? extends GuiEventListener> m_6702_() {
        return this.widgets;
    }

    public boolean m_5534_(char character, int modifiers) {
        if (this.menu != null && this.menu.m_5534_(character, modifiers)) {
            return true;
        }
        for (GuiEventListener guiEventListener : this.m_6702_()) {
            if (!guiEventListener.m_5534_(character, modifiers)) continue;
            return true;
        }
        return super.m_5534_(character, modifiers);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.menu != null && this.menu.m_7979_(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        for (GuiEventListener guiEventListener : this.m_6702_()) {
            if (!guiEventListener.m_7979_(mouseX, mouseY, button, deltaX, deltaY)) continue;
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.menu != null) {
            if (!this.menu.m_6375_(mouseX, mouseY, button)) {
                this.closeMenu();
            }
            return true;
        }
        if (this.focusedKeycodeOption != null && this.partialKeycode != null) {
            if (this.partialKeycode.isUnknown()) {
                this.partialKeycode.setKeyCode(InputConstants.Type.MOUSE.m_84895_(button));
            } else if (this.partialKeycode.getType() == InputConstants.Type.KEYSYM) {
                Modifier modifier = this.partialKeycode.getModifier();
                int code = this.partialKeycode.getKeyCode().m_84873_();
                if (Minecraft.f_91002_ ? code == 343 || code == 347 : code == 341 || code == 345) {
                    this.partialKeycode.setModifier(Modifier.of((boolean)modifier.hasAlt(), (boolean)true, (boolean)modifier.hasShift()));
                    this.partialKeycode.setKeyCode(InputConstants.Type.MOUSE.m_84895_(button));
                    return true;
                }
                if (code == 344 || code == 340) {
                    this.partialKeycode.setModifier(Modifier.of((boolean)modifier.hasAlt(), (boolean)modifier.hasControl(), (boolean)true));
                    this.partialKeycode.setKeyCode(InputConstants.Type.MOUSE.m_84895_(button));
                    return true;
                }
                if (code == 342 || code == 346) {
                    this.partialKeycode.setModifier(Modifier.of((boolean)true, (boolean)modifier.hasControl(), (boolean)modifier.hasShift()));
                    this.partialKeycode.setKeyCode(InputConstants.Type.MOUSE.m_84895_(button));
                    return true;
                }
            }
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.menu != null && this.menu.m_6348_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.focusedKeycodeOption != null && this.partialKeycode != null && !this.partialKeycode.isUnknown()) {
            this.set(this.focusedKeycodeOption, this.partialKeycode);
            this.focusKeycode(null);
            return true;
        }
        for (GuiEventListener guiEventListener : this.m_6702_()) {
            if (!guiEventListener.m_6348_(mouseX, mouseY, button)) continue;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.menu != null && this.menu.m_6050_(mouseX, mouseY, amount)) {
            return true;
        }
        for (GuiEventListener guiEventListener : this.m_6702_()) {
            if (!guiEventListener.m_6050_(mouseX, mouseY, amount)) continue;
            return true;
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.focusedKeycodeOption != null) {
            if (keyCode != 256) {
                if (this.partialKeycode.isUnknown()) {
                    this.partialKeycode.setKeyCode(InputConstants.m_84827_((int)keyCode, (int)scanCode));
                } else {
                    Modifier modifier = this.partialKeycode.getModifier();
                    if (this.partialKeycode.getType() == InputConstants.Type.KEYSYM) {
                        int code = this.partialKeycode.getKeyCode().m_84873_();
                        if (Minecraft.f_91002_ ? code == 343 || code == 347 : code == 341 || code == 345) {
                            this.partialKeycode.setModifier(Modifier.of((boolean)modifier.hasAlt(), (boolean)true, (boolean)modifier.hasShift()));
                            this.partialKeycode.setKeyCode(InputConstants.m_84827_((int)keyCode, (int)scanCode));
                            return true;
                        }
                        if (code == 344 || code == 340) {
                            this.partialKeycode.setModifier(Modifier.of((boolean)modifier.hasAlt(), (boolean)modifier.hasControl(), (boolean)true));
                            this.partialKeycode.setKeyCode(InputConstants.m_84827_((int)keyCode, (int)scanCode));
                            return true;
                        }
                        if (code == 342 || code == 346) {
                            this.partialKeycode.setModifier(Modifier.of((boolean)true, (boolean)modifier.hasControl(), (boolean)modifier.hasShift()));
                            this.partialKeycode.setKeyCode(InputConstants.m_84827_((int)keyCode, (int)scanCode));
                            return true;
                        }
                    }
                    if (Minecraft.f_91002_ ? keyCode == 343 || keyCode == 347 : keyCode == 341 || keyCode == 345) {
                        this.partialKeycode.setModifier(Modifier.of((boolean)modifier.hasAlt(), (boolean)true, (boolean)modifier.hasShift()));
                        return true;
                    }
                    if (keyCode == 344 || keyCode == 340) {
                        this.partialKeycode.setModifier(Modifier.of((boolean)modifier.hasAlt(), (boolean)modifier.hasControl(), (boolean)true));
                        return true;
                    }
                    if (keyCode == 342 || keyCode == 346) {
                        this.partialKeycode.setModifier(Modifier.of((boolean)true, (boolean)modifier.hasControl(), (boolean)modifier.hasShift()));
                        return true;
                    }
                }
            } else {
                this.set(this.focusedKeycodeOption, ModifierKeyCode.unknown());
                this.focusKeycode(null);
            }
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (this.focusedKeycodeOption != null && this.partialKeycode != null) {
            this.set(this.focusedKeycodeOption, this.partialKeycode);
            this.focusKeycode(null);
            return true;
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    @Override
    public void openMenu(Menu menu) {
        if (this.menu != null) {
            this.widgets.remove(this.menuWidget);
        }
        this.menu = menu;
        this.menuWidget = Widgets.withTranslate(menu, 0.0, 0.0, 300.0);
        this.widgets.add(this.menuWidget);
    }

    @Override
    public void closeMenu() {
        this.widgets.remove(this.menuWidget);
        this.menu = null;
        this.menuWidget = null;
    }

    @Override
    public <T> T get(CompositeOption<T> option) {
        return (T)this.getOptions().get(option.getId());
    }

    @Override
    public <T> void set(CompositeOption<T> option, T value) {
        this.getOptions().put(option.getId(), value);
    }

    @Override
    public <T> T getDefault(CompositeOption<T> option) {
        return (T)this.getDefaultOptions().get(option.getId());
    }

    @Override
    public void focusKeycode(CompositeOption<ModifierKeyCode> option) {
        this.focusedKeycodeOption = option;
        if (this.focusedKeycodeOption != null) {
            this.partialKeycode = this.get(this.focusedKeycodeOption);
            this.partialKeycode.setKeyCodeAndModifier(InputConstants.f_84822_, Modifier.none());
        } else {
            this.partialKeycode = null;
        }
    }

    @Override
    @Nullable
    public CompositeOption<ModifierKeyCode> getFocusedKeycode() {
        return this.focusedKeycodeOption;
    }

    public void setSearching(boolean searching) {
        this.searching = searching;
        this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
    }

    public boolean isSearching() {
        return this.searching;
    }
}

