/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class SpriteRenderer {
    public static RenderPass beginPass() {
        return new RenderPass();
    }

    public static class RenderPass {
        private float x1 = 0.0f;
        private float x2 = 1.0f;
        private float y1 = 0.0f;
        private float y2 = 0.0f;
        private float z1 = 0.0f;
        private float uStart = 0.0f;
        private float uEnd = 1.0f;
        private float vStart = 0.0f;
        private float vEnd = 1.0f;
        private int u = 0;
        private int v = 1;
        private int r = 255;
        private int g = 255;
        private int b = 255;
        private int a = 255;
        private int l = 0;
        private float nX = 0.0f;
        private float nY = 0.0f;
        private float nZ = 0.0f;
        private TextureAtlasSprite sprite;
        private VertexConsumer consumer;
        private MultiBufferSource consumers;
        private PoseStack matrices;
        private Matrix4f model;
        private Matrix3f normal;
        private RenderType layer;

        private RenderPass() {
        }

        public RenderPass setup(MultiBufferSource consumers, RenderType type) {
            this.consumers = consumers;
            this.setup(consumers.m_6299_(type), type);
            return this;
        }

        public RenderPass setup(VertexConsumer consumer, RenderType type) {
            this.consumer = consumer;
            this.matrices = new PoseStack();
            this.layer = type;
            return this;
        }

        public RenderPass setup(MultiBufferSource consumers, GuiGraphics graphics, RenderType type) {
            this.consumers = consumers;
            this.consumer = consumers.m_6299_(type);
            this.matrices = graphics.m_280168_();
            this.layer = type;
            return this;
        }

        public RenderPass position(Matrix4f model, float x1, float y1, float x2, float y2, float z1) {
            this.position(x1, y1, x2, y2, z1);
            this.model = model;
            return this;
        }

        public RenderPass position(float x1, float y1, float x2, float y2, float z1) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.z1 = z1;
            return this;
        }

        public RenderPass sprite(TextureAtlasSprite sprite) {
            this.uStart = sprite.m_118409_();
            this.uEnd = sprite.m_118410_();
            this.vStart = sprite.m_118411_();
            this.vEnd = sprite.m_118412_();
            this.sprite = sprite;
            return this;
        }

        public RenderPass sprite(float uStart, float uEnd, float vStart, float vEnd) {
            this.uStart = uStart;
            this.uEnd = uEnd;
            this.vStart = vStart;
            this.vEnd = vEnd;
            return this;
        }

        public RenderPass overlay(int uv) {
            return this.overlay(uv & 0xFFFF, uv >> 16 & 0xFFFF);
        }

        public RenderPass overlay(int u, int v) {
            this.u = u;
            this.v = v;
            return this;
        }

        public RenderPass color(int color) {
            this.r = color >> 16 & 0xFF;
            this.g = color >> 8 & 0xFF;
            this.b = color & 0xFF;
            return this;
        }

        public RenderPass color(int r, int g, int b) {
            this.r = r;
            this.g = g;
            this.b = b;
            return this;
        }

        public RenderPass alpha(int a) {
            this.a = a;
            return this;
        }

        public RenderPass light(int l) {
            this.l = l;
            return this;
        }

        public RenderPass normal(Matrix3f normal, float nX, float nY, float nZ) {
            this.normal(nX, nY, nZ);
            this.normal = normal;
            return this;
        }

        public RenderPass normal(float nX, float nY, float nZ) {
            this.nX = nX;
            this.nY = nY;
            this.nZ = nZ;
            return this;
        }

        public void next() {
            if (this.sprite == null) {
                throw new RuntimeException("Invalid Sprite!");
            }
            this.next(this.sprite.m_245424_().m_246162_());
        }

        public void next(ResourceLocation texture) {
            if (this.consumer == null) {
                throw new RuntimeException("Invalid VertexConsumer!");
            }
            if (this.matrices == null) {
                throw new RuntimeException("Invalid MatrixStack!");
            }
            if (this.sprite == null) {
                throw new RuntimeException("Invalid Sprite!");
            }
            if (this.model == null) {
                this.model = this.matrices.m_85850_().m_252922_();
            }
            if (this.normal == null) {
                this.normal = this.matrices.m_85850_().m_252943_();
            }
            float sX = this.sprite.m_245424_().m_246492_();
            float sY = this.sprite.m_245424_().m_245330_();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
            for (float y = this.y1; y < this.y2; y += Math.min(this.y2 - y, sY)) {
                for (float x = this.x1; x < this.x2; x += Math.min(this.x2 - x, sX)) {
                    float nSX = Math.min(this.x2 - x, sX);
                    float nSY = Math.min(this.y2 - y, sY);
                    boolean isOverX = nSX < sX;
                    boolean isOverY = nSY < sY;
                    float dX = 0.0f;
                    float dY = 0.0f;
                    if (isOverX) {
                        dX = (this.uEnd - this.uStart) * (1.0f - nSX / sX);
                    }
                    if (isOverY) {
                        dY = (this.vEnd - this.vStart) * (1.0f - nSY / sY);
                    }
                    this.consumer = this.consumers.m_6299_(this.layer);
                    this.consumer.m_252986_(this.model, x, y + nSY, this.z1).m_6122_(this.r, this.g, this.b, this.a).m_7421_(this.uStart, this.vEnd - dY).m_7122_(this.u, this.v).m_85969_(this.l).m_252939_(this.normal, this.nX, this.nY, this.nZ).m_5752_();
                    this.consumer.m_252986_(this.model, x + nSX, y + nSY, this.z1).m_6122_(this.r, this.g, this.b, this.a).m_7421_(this.uEnd - dX, this.vEnd - dY).m_7122_(this.u, this.v).m_85969_(this.l).m_252939_(this.normal, this.nX, this.nY, this.nZ).m_5752_();
                    this.consumer.m_252986_(this.model, x + nSX, y, this.z1).m_6122_(this.r, this.g, this.b, this.a).m_7421_(this.uEnd - dX, this.vStart).m_7122_(this.u, this.v).m_85969_(this.l).m_252939_(this.normal, this.nX, this.nY, this.nZ).m_5752_();
                    this.consumer.m_252986_(this.model, x, y, this.z1).m_6122_(this.r, this.g, this.b, this.a).m_7421_(this.uStart, this.vStart).m_7122_(this.u, this.v).m_85969_(this.l).m_252939_(this.normal, this.nX, this.nY, this.nZ).m_5752_();
                }
            }
        }
    }
}

