/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChunkCache
implements CollisionGetter {
    protected final int chunkX;
    protected final int chunkZ;
    protected final ChunkAccess[][] chunks;
    protected boolean empty;
    protected final Level world;

    public ChunkCache(Level worldIn, BlockPos pos1, BlockPos pos2) {
        int z;
        int x;
        this.world = worldIn;
        this.chunkX = pos1.m_123341_() >> 4;
        this.chunkZ = pos1.m_123343_() >> 4;
        int endX = pos2.m_123341_() >> 4;
        int endZ = pos2.m_123343_() >> 4;
        this.chunks = new ChunkAccess[endX - this.chunkX + 1][endZ - this.chunkZ + 1];
        this.empty = true;
        for (x = this.chunkX; x <= endX; ++x) {
            for (z = this.chunkZ; z <= endZ; ++z) {
                this.chunks[x - this.chunkX][z - this.chunkZ] = this.world.m_6522_(x, z, ChunkStatus.f_62326_, true);
            }
        }
        for (x = pos1.m_123341_() >> 4; x <= pos2.m_123341_() >> 4; ++x) {
            for (z = pos1.m_123343_() >> 4; z <= pos2.m_123343_() >> 4; ++z) {
                ChunkAccess ichunk = this.chunks[x - this.chunkX][z - this.chunkZ];
                if (ichunk == null || ichunk.m_5566_(pos1.m_123342_(), pos2.m_123342_())) continue;
                this.empty = false;
                return;
            }
        }
    }

    private ChunkAccess getChunk(BlockPos pos) {
        return this.getChunk(pos.m_123341_() >> 4, pos.m_123343_() >> 4);
    }

    private ChunkAccess getChunk(int chunkX, int chunkZ) {
        int x = chunkX - this.chunkX;
        int z = chunkZ - this.chunkZ;
        if (x >= 0 && x < this.chunks.length && z >= 0 && z < this.chunks[x].length) {
            ChunkAccess ichunk = this.chunks[x][z];
            return ichunk != null ? ichunk : new EmptyLevelChunk(this.world, new ChunkPos(chunkX, chunkZ), (Holder)this.world.m_9598_().m_175515_(Registries.f_256952_).m_246971_(Biomes.f_48202_));
        }
        return new EmptyLevelChunk(this.world, new ChunkPos(chunkX, chunkZ), (Holder)this.world.m_9598_().m_175515_(Registries.f_256952_).m_246971_(Biomes.f_48202_));
    }

    public WorldBorder m_6857_() {
        return this.world.m_6857_();
    }

    public BlockGetter m_7925_(int chunkX, int chunkZ) {
        return this.getChunk(chunkX, chunkZ);
    }

    public List<VoxelShape> m_183134_(@Nullable Entity pEntity, AABB pCollisionBox) {
        return Collections.emptyList();
    }

    @Nullable
    public BlockEntity m_7702_(BlockPos pos) {
        ChunkAccess ichunk = this.getChunk(pos);
        return ichunk.m_7702_(pos);
    }

    public BlockState m_8055_(BlockPos pos) {
        if (this.world.m_151570_(pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        ChunkAccess ichunk = this.getChunk(pos);
        return ichunk.m_8055_(pos);
    }

    public FluidState m_6425_(BlockPos pos) {
        if (this.world.m_151570_(pos)) {
            return Fluids.f_76191_.m_76145_();
        }
        ChunkAccess ichunk = this.getChunk(pos);
        return ichunk.m_6425_(pos);
    }

    public int m_141928_() {
        return this.world.m_141928_();
    }

    public int m_141937_() {
        return this.world.m_141937_();
    }
}

