/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.block.entity.PressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.common.network.PacketUtil;
import me.desht.pneumaticcraft.common.tubemodules.AbstractTubeModule;
import me.desht.pneumaticcraft.common.tubemodules.LogisticsModule;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class PacketUpdateLogisticsModule
extends LocationIntPacket {
    private final int side;
    private final int colorIndex;
    private final int status;

    public PacketUpdateLogisticsModule(LogisticsModule logisticsModule, int action) {
        super(logisticsModule.getTube().m_58899_());
        this.side = logisticsModule.getDirection().ordinal();
        this.colorIndex = logisticsModule.getColorChannel();
        this.status = action > 0 ? 1 + action : (logisticsModule.hasPower() ? 1 : 0);
    }

    public PacketUpdateLogisticsModule(FriendlyByteBuf buffer) {
        super(buffer);
        this.side = buffer.readByte();
        this.colorIndex = buffer.readByte();
        this.status = buffer.readByte();
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeByte(this.side);
        buf.writeByte(this.colorIndex);
        buf.writeByte(this.status);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> PacketUtil.getBlockEntity((Player)((NetworkEvent.Context)ctx.get()).getSender(), this.pos, PressureTubeBlockEntity.class).ifPresent(te -> {
            AbstractTubeModule module = te.getModule(Direction.m_122376_((int)this.side));
            if (module instanceof LogisticsModule) {
                ((LogisticsModule)module).onUpdatePacket(this.status, this.colorIndex);
            }
        }));
        ctx.get().setPacketHandled(true);
    }
}

