/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.EnumMap;
import java.util.Map;
import java.util.stream.Stream;
import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.TubeJunctionBlockEntity;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.util.VoxelShapeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TubeJunctionBlock
extends AbstractPneumaticCraftBlock
implements PneumaticCraftEntityBlock {
    private static final VoxelShape SHAPE = Stream.of(Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0), Block.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0), Block.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)16.0), Block.m_49796_((double)3.0, (double)5.0, (double)5.0, (double)13.0, (double)11.0, (double)11.0), Block.m_49796_((double)5.0, (double)5.0, (double)3.0, (double)11.0, (double)11.0, (double)13.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final Map<Direction.Axis, VoxelShape> SHAPES = new EnumMap<Direction.Axis, VoxelShape>(Direction.Axis.class);

    public TubeJunctionBlock() {
        super(ModBlocks.defaultProps());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)Direction.Axis.Y));
    }

    @Override
    protected boolean isWaterloggable() {
        return true;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61365_});
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPES.get(pState.m_61143_((Property)BlockStateProperties.f_61365_));
    }

    @Override
    public boolean onWrenched(Level world, Player player, BlockPos pos, Direction side, InteractionHand hand) {
        if (player != null && player.m_6047_()) {
            return super.onWrenched(world, player, pos, side, hand);
        }
        BlockState state = world.m_8055_(pos);
        Direction.Axis newAxis = Direction.Axis.values()[(((Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_)).ordinal() + 1) % Direction.Axis.values().length];
        world.m_46597_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)newAxis));
        world.m_141902_(pos, (BlockEntityType)ModBlockEntities.TUBE_JUNCTION.get()).ifPresent(AbstractAirHandlingBlockEntity::onBlockRotated);
        return true;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState state = super.m_5573_(ctx);
        return state == null ? null : (BlockState)state.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)ctx.m_43719_().m_122434_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new TubeJunctionBlockEntity(pPos, pState);
    }

    static {
        SHAPES.put(Direction.Axis.Y, SHAPE);
        SHAPES.put(Direction.Axis.Z, VoxelShapeUtils.rotateX(SHAPE, 90));
        SHAPES.put(Direction.Axis.X, VoxelShapeUtils.rotateY(SHAPES.get(Direction.Axis.Z), 90));
    }
}

