/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.entity;

import net.mehvahdjukaar.amendments.Amendments;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.integration.CompatHandler;
import net.mehvahdjukaar.amendments.integration.SuppCompat;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.entity.ImprovedFallingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class FallingLanternEntity
extends ImprovedFallingBlockEntity {
    public FallingLanternEntity(EntityType<FallingLanternEntity> type, Level level) {
        super(type, level);
    }

    public FallingLanternEntity(Level level) {
        super(ModRegistry.FALLING_LANTERN.get(), level);
    }

    public FallingLanternEntity(Level level, BlockPos pos, BlockState blockState, double yOffset) {
        super(ModRegistry.FALLING_LANTERN.get(), level, pos, blockState, false);
        this.f_19855_ = (double)pos.m_123342_() + yOffset;
    }

    public static FallingBlockEntity fall(Level level, BlockPos pos, BlockState state, double yOffset) {
        FallingLanternEntity entity = new FallingLanternEntity(level, pos, state, yOffset);
        level.m_7731_(pos, state.m_60819_().m_76188_(), 3);
        level.m_7967_((Entity)entity);
        return entity;
    }

    public boolean m_142535_(float height, float amount, DamageSource source) {
        boolean r = super.m_142535_(height, amount, source);
        if (CommonConfigs.FALLING_LANTERNS.get().hasFire() && this.m_20184_().m_82556_() > 0.16000000000000003) {
            BlockState state = this.m_31980_();
            BlockPos pos = BlockPos.m_274561_((double)this.m_20185_(), (double)(this.m_20186_() + 0.25), (double)this.m_20189_());
            Level level = this.m_9236_();
            level.m_5898_(null, 2001, pos, Block.m_49956_((BlockState)state));
            if (state.m_60791_() != 0) {
                if (CompatHandler.SUPPLEMENTARIES && level instanceof ServerLevel) {
                    ServerLevel l = (ServerLevel)level;
                    SuppCompat.createMiniExplosion(l, pos, true);
                } else if (level.m_8055_(pos).m_60795_() && BaseFireBlock.m_49255_((Level)level, (BlockPos)pos, (Direction)Direction.DOWN)) {
                    level.m_46597_(pos, BaseFireBlock.m_49245_((BlockGetter)level, (BlockPos)pos));
                }
            } else {
                this.m_19998_((ItemLike)state.m_60734_());
            }
            this.setCancelDrop(true);
            this.m_146870_();
        }
        return r;
    }

    public static boolean canSurviveCeilingAndMaybeFall(BlockState state, BlockPos pos, LevelReader worldIn) {
        if (!Amendments.isSupportingCeiling(pos.m_7494_(), worldIn) && worldIn instanceof Level) {
            Level l = (Level)worldIn;
            if (CommonConfigs.FALLING_LANTERNS.get().isOn() && l.m_8055_(pos).m_60713_(state.m_60734_())) {
                return FallingLanternEntity.createFallingLantern(state, pos, l);
            }
            return false;
        }
        return true;
    }

    public static boolean createFallingLantern(BlockState state, BlockPos pos, Level level) {
        if (FallingBlock.m_53241_((BlockState)level.m_8055_(pos.m_7495_())) && pos.m_123342_() >= level.m_141937_() && state.m_61138_((Property)LanternBlock.f_153459_)) {
            double maxY = state.m_60808_((BlockGetter)level, (BlockPos)pos).m_83215_().f_82292_;
            state = (BlockState)state.m_61124_((Property)LanternBlock.f_153459_, (Comparable)Boolean.valueOf(false));
            double yOffset = maxY - state.m_60808_((BlockGetter)level, (BlockPos)pos).m_83215_().f_82292_;
            FallingLanternEntity.fall(level, pos, state, yOffset);
            return true;
        }
        return false;
    }

    public static enum FallMode {
        ON,
        OFF,
        NO_FIRE;


        public boolean hasFire() {
            return this != NO_FIRE;
        }

        public boolean isOn() {
            return this != OFF;
        }
    }
}

