/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core.data.server;

import com.teamabnormals.atmospheric.core.other.AtmosphericCriteriaTriggers;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.atmospheric.core.registry.AtmosphericEntityTypes;
import com.teamabnormals.atmospheric.core.registry.AtmosphericItems;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.critereon.ConsumeItemTrigger;
import net.minecraft.advancements.critereon.DamagePredicate;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.advancements.critereon.PlayerHurtEntityTrigger;
import net.minecraft.advancements.critereon.TagPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;

public class AtmosphericAdvancementProvider
implements ForgeAdvancementProvider.AdvancementGenerator {
    public static ForgeAdvancementProvider create(PackOutput output, CompletableFuture<HolderLookup.Provider> provider, ExistingFileHelper helper) {
        return new ForgeAdvancementProvider(output, provider, helper, List.of(new AtmosphericAdvancementProvider()));
    }

    public void generate(HolderLookup.Provider provider, Consumer<Advancement> consumer, ExistingFileHelper helper) {
        Advancement dunesPricks = AtmosphericAdvancementProvider.createAdvancement("dunes_pricks", "adventure", new ResourceLocation("adventure/root"), (ItemLike)AtmosphericBlocks.YUCCA_FLOWER.get(), FrameType.TASK, true, true, false).m_138386_("yucca_flower", (CriterionTriggerInstance)AtmosphericCriteriaTriggers.YUCCA_PRICK.createInstance()).m_138386_("aloe_vera", (CriterionTriggerInstance)AtmosphericCriteriaTriggers.ALOE_VERA_PRICK.createInstance()).m_138386_("barrel_cactus", (CriterionTriggerInstance)AtmosphericCriteriaTriggers.BARREL_CACTUS_PRICK.createInstance()).m_138389_(consumer, "atmospheric:adventure/dunes_pricks");
        AtmosphericAdvancementProvider.createAdvancement("loot_arid_garden", "adventure", dunesPricks, (ItemLike)AtmosphericBlocks.BARREL_CACTUS.get(), FrameType.TASK, true, true, false).m_138386_("loot_arid_garden", (CriterionTriggerInstance)AtmosphericCriteriaTriggers.LOOT_ARID_GARDEN.createInstance()).m_138389_(consumer, "atmospheric:adventure/loot_arid_garden");
        Advancement spitPassionFruit = AtmosphericAdvancementProvider.createAdvancement("spit_passion_fruit", "husbandry", new ResourceLocation("husbandry/root"), (ItemLike)AtmosphericItems.PASSION_FRUIT.get(), FrameType.TASK, true, true, false).m_138386_("spit_passion_fruit", (CriterionTriggerInstance)PlayerHurtEntityTrigger.TriggerInstance.m_60149_((DamagePredicate.Builder)DamagePredicate.Builder.m_24931_().m_24932_(DamageSourcePredicate.Builder.m_25471_().m_269507_(TagPredicate.m_269314_((TagKey)DamageTypeTags.f_268524_)).m_25472_(EntityPredicate.Builder.m_36633_().m_36636_((EntityType)AtmosphericEntityTypes.PASSION_FRUIT_SEED.get()))))).m_138389_(consumer, "atmospheric:husbandry/spit_passion_fruit");
        AtmosphericAdvancementProvider.createAdvancement("kill_mob_with_passion_fruit", "husbandry", spitPassionFruit, (ItemLike)AtmosphericItems.SHIMMERING_PASSION_FRUIT.get(), FrameType.TASK, true, true, false).m_138386_("kill_mob_with_passion_fruit", (CriterionTriggerInstance)KilledTrigger.TriggerInstance.m_152110_((EntityPredicate)EntityPredicate.f_36550_, (DamageSourcePredicate.Builder)DamageSourcePredicate.Builder.m_25471_().m_269507_(TagPredicate.m_269314_((TagKey)DamageTypeTags.f_268524_)).m_25472_(EntityPredicate.Builder.m_36633_().m_36636_((EntityType)AtmosphericEntityTypes.PASSION_FRUIT_SEED.get())))).m_138389_(consumer, "atmospheric:husbandry/kill_mob_with_passion_fruit");
        Advancement findOrange = AtmosphericAdvancementProvider.createAdvancement("find_orange", "husbandry", new ResourceLocation("husbandry/root"), (ItemLike)AtmosphericItems.ORANGE.get(), FrameType.TASK, true, true, false).m_138386_("find_orange", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)AtmosphericItems.ORANGE.get()})).m_138389_(consumer, "atmospheric:husbandry/find_orange");
        AtmosphericAdvancementProvider.createAdvancement("obtain_blood_orange", "husbandry", findOrange, (ItemLike)AtmosphericItems.BLOOD_ORANGE.get(), FrameType.TASK, true, true, false).m_138386_("obtain_blood_orange", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)AtmosphericItems.BLOOD_ORANGE.get()})).m_138389_(consumer, "atmospheric:husbandry/obtain_blood_orange");
        Advancement persistenceWhileStarving = AtmosphericAdvancementProvider.createAdvancement("persistence_while_starving", "husbandry", new ResourceLocation("husbandry/root"), (ItemLike)AtmosphericItems.ROASTED_YUCCA_FRUIT.get(), FrameType.TASK, true, true, false).m_138386_("persistence_while_starving", (CriterionTriggerInstance)AtmosphericCriteriaTriggers.PERSISTENCE_WHILE_STARVING.createInstance()).m_138389_(consumer, "atmospheric:husbandry/persistence_while_starving");
        AtmosphericAdvancementProvider.createAdvancement("finish_gateau", "husbandry", persistenceWhileStarving, (ItemLike)AtmosphericBlocks.YUCCA_GATEAU.get(), FrameType.TASK, true, true, false).m_138386_("finish_gateau", (CriterionTriggerInstance)AtmosphericCriteriaTriggers.FINISH_GATEAU.createInstance()).m_138389_(consumer, "atmospheric:husbandry/finish_gateau");
        AtmosphericAdvancementProvider.createAdvancement("put_out_fire", "husbandry", new ResourceLocation("husbandry/root"), (ItemLike)AtmosphericItems.ALOE_LEAVES.get(), FrameType.TASK, true, true, false).m_138386_("put_out_fire", (CriterionTriggerInstance)AtmosphericCriteriaTriggers.PUT_OUT_FIRE.createInstance()).m_138389_(consumer, "atmospheric:husbandry/put_out_fire");
        AtmosphericAdvancementProvider.createAdvancement("forbidden_fruit", "end", new ResourceLocation("end/root"), (ItemLike)AtmosphericItems.ENDER_DRAGON_FRUIT.get(), FrameType.GOAL, true, true, true).m_138386_("forbidden_fruit", (CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)((ItemLike)AtmosphericItems.ENDER_DRAGON_FRUIT.get()))).m_138389_(consumer, "atmospheric:end/forbidden_fruit");
    }

    private static Advancement.Builder createAdvancement(String name, String category, Advancement parent, ItemLike icon, FrameType frame, boolean showToast, boolean announceToChat, boolean hidden) {
        return Advancement.Builder.m_138353_().m_138398_(parent).m_138371_(icon, (Component)Component.m_237115_((String)("advancements.atmospheric." + category + "." + name + ".title")), (Component)Component.m_237115_((String)("advancements.atmospheric." + category + "." + name + ".description")), null, frame, showToast, announceToChat, hidden);
    }

    private static Advancement.Builder createAdvancement(String name, String category, ResourceLocation parent, ItemLike icon, FrameType frame, boolean showToast, boolean announceToChat, boolean hidden) {
        return AtmosphericAdvancementProvider.createAdvancement(name, category, Advancement.Builder.m_138353_().m_138403_(parent), icon, frame, showToast, announceToChat, hidden);
    }
}

