/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.document.block;

import appeng.client.guidebook.color.ColorValue;
import appeng.client.guidebook.color.SymbolicColor;
import appeng.client.guidebook.document.DefaultStyles;
import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.document.block.LytList;
import appeng.client.guidebook.document.block.LytNode;
import appeng.client.guidebook.document.block.LytVBox;
import appeng.client.guidebook.layout.LayoutContext;
import appeng.client.guidebook.render.RenderContext;
import appeng.client.guidebook.style.ResolvedTextStyle;
import net.minecraft.client.renderer.MultiBufferSource;

public class LytListItem
extends LytVBox {
    private static final int LEVEL_MARGIN = 10;
    private final ResolvedTextStyle style = DefaultStyles.BODY_TEXT.mergeWith(DefaultStyles.BASE_STYLE);

    private boolean isOrdered() {
        LytNode lytNode = this.parent;
        if (lytNode instanceof LytList) {
            LytList list = (LytList)lytNode;
            return list.isOrdered();
        }
        return false;
    }

    @Override
    protected LytRect computeBoxLayout(LayoutContext context, int x, int y, int availableWidth) {
        int margin = 10;
        LytRect bounds = super.computeBoxLayout(context, x + margin, y, availableWidth - margin);
        return bounds.expand(10, 0, 0, 0);
    }

    @Override
    public void renderBatch(RenderContext context, MultiBufferSource buffers) {
        if (this.isOrdered()) {
            int number = this.getOrderedItemNumber();
            String label = number + ".";
            float width = context.getWidth(label, this.style);
            LytRect bounds = this.getBounds();
            float x = (float)(bounds.x() + 10) - width - 2.0f;
            context.renderTextInBatch(label, this.style, x, bounds.y(), buffers);
        }
        super.renderBatch(context, buffers);
    }

    private int getOrderedItemNumber() {
        int number = 1;
        Object object = this.parent;
        if (object instanceof LytList) {
            LytNode child;
            LytList list = (LytList)object;
            number = list.getStart();
            object = list.getChildren().iterator();
            while (object.hasNext() && (child = (LytNode)object.next()) != this) {
                if (!(child instanceof LytListItem)) continue;
                ++number;
            }
        }
        return number;
    }

    @Override
    public void render(RenderContext context) {
        if (!this.isOrdered()) {
            LytRect bounds = this.getBounds();
            context.fillRect(bounds.x() + 5, bounds.y() + 4, 2, 2, (ColorValue)SymbolicColor.BODY_TEXT);
        }
        super.render(context);
    }
}

