/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.core.data;

import com.stal111.valhelsia_structures.core.ValhelsiaStructures;
import com.stal111.valhelsia_structures.core.data.server.ModBiomeTagsProvider;
import com.stal111.valhelsia_structures.core.data.server.ModBlockTagsProvider;
import com.stal111.valhelsia_structures.core.data.server.ModItemTagsProvider;
import com.stal111.valhelsia_structures.core.data.server.loot.ModBlockLootTables;
import com.stal111.valhelsia_structures.core.data.server.loot.ModLootModifierProvider;
import com.stal111.valhelsia_structures.data.ModSoundsProvider;
import com.stal111.valhelsia_structures.data.recipes.ModRecipeProvider;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.valhelsia.valhelsia_core.api.datagen.DataProviderContext;
import net.valhelsia.valhelsia_core.api.datagen.recipes.ValhelsiaRecipeProvider;

@Mod.EventBusSubscriber(modid="valhelsia_structures", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        DataProviderContext context = new DataProviderContext(output, lookupProvider, ValhelsiaStructures.REGISTRY_MANAGER);
        generator.addProvider(event.includeClient(), (DataProvider)new ModSoundsProvider(output, existingFileHelper));
        ModBlockTagsProvider blockTagsProvider = new ModBlockTagsProvider(context);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTagsProvider(output, lookupProvider, blockTagsProvider.m_274426_(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModBiomeTagsProvider(output, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(output, Set.of(), List.of(new LootTableProvider.SubProviderEntry(ModBlockLootTables::new, LootContextParamSets.f_81421_))));
        generator.addProvider(event.includeServer(), (DataProvider)new ModLootModifierProvider(output));
        generator.addProvider(event.includeServer(), (DataProvider)new ValhelsiaRecipeProvider(context, new Function[]{ModRecipeProvider::new}));
        generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(output, lookupProvider, ValhelsiaStructures.REGISTRY_MANAGER.buildRegistrySet(), Set.of("valhelsia_structures")));
    }
}

