/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.common.world.structures.processor;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stal111.valhelsia_structures.core.init.world.ModStructureProcessors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpawnerRoomLegProcessor
extends StructureProcessor {
    public static final Codec<SpawnerRoomLegProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.f_61039_.fieldOf("block").forGetter(processor -> processor.block), (App)BlockState.f_61039_.fieldOf("slab_block").forGetter(processor -> processor.slabBlock)).apply((Applicative)instance, SpawnerRoomLegProcessor::new));
    private final BlockState block;
    private final BlockState slabBlock;

    public SpawnerRoomLegProcessor(BlockState block, BlockState slabBlock) {
        this.block = block;
        this.slabBlock = slabBlock;
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo process(@NotNull LevelReader level, @NotNull BlockPos piecePos, @NotNull BlockPos pieceBottomCenterPos, @NotNull StructureTemplate.StructureBlockInfo blockInfo, @NotNull StructureTemplate.StructureBlockInfo relativeBlockInfo, @NotNull StructurePlaceSettings placeSettings, @Nullable StructureTemplate template) {
        String data;
        StructureMode mode;
        if (relativeBlockInfo.f_74676_().m_60713_(Blocks.f_50677_) && (mode = StructureMode.valueOf((String)relativeBlockInfo.f_74677_().m_128461_("mode"))) == StructureMode.DATA && (data = relativeBlockInfo.f_74677_().m_128461_("metadata")).startsWith("support_leg")) {
            BlockPos.MutableBlockPos mutable = relativeBlockInfo.f_74675_().m_7495_().m_122032_();
            while (mutable.m_123342_() > level.m_141937_() && mutable.m_123342_() < level.m_151558_() && this.placeBlock(level, (BlockPos)mutable, this.block)) {
                mutable.m_122173_(Direction.DOWN);
            }
            Direction direction = Direction.m_122402_((String)data.split(";")[1]);
            if (direction != null) {
                direction = placeSettings.m_74404_().m_55954_(direction);
                mutable = relativeBlockInfo.f_74675_().m_7495_().m_122032_().m_122173_(direction);
                this.placeBlock(level, (BlockPos)mutable, this.slabBlock);
                mutable.m_122173_(direction.m_122427_());
                this.placeBlock(level, (BlockPos)mutable, this.slabBlock);
                mutable.m_122173_(direction.m_122424_());
                this.placeBlock(level, (BlockPos)mutable, this.slabBlock);
            }
            return new StructureTemplate.StructureBlockInfo(relativeBlockInfo.f_74675_(), Blocks.f_50652_.m_49966_(), null);
        }
        return super.process(level, piecePos, pieceBottomCenterPos, blockInfo, relativeBlockInfo, placeSettings, template);
    }

    private boolean placeBlock(LevelReader level, BlockPos pos, BlockState state) {
        BlockState currentState = level.m_8055_(pos);
        if (currentState.m_60795_() || !currentState.m_60819_().m_76178_()) {
            level.m_46865_(pos).m_6978_(pos, state, false);
            return true;
        }
        return false;
    }

    @NotNull
    protected StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)ModStructureProcessors.SPAWNER_ROOM_LEG.get();
    }
}

