/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.common.world.structures.height;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stal111.valhelsia_structures.common.world.structures.height.StructureHeightProvider;
import com.stal111.valhelsia_structures.common.world.structures.height.StructureHeightProviderType;
import com.stal111.valhelsia_structures.core.init.world.ModStructureHeightProviderTypes;
import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.structure.Structure;

public class SurfaceHeightProvider
extends StructureHeightProvider {
    public static final Codec<SurfaceHeightProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)VerticalAnchor.f_158914_.fieldOf("min_inclusive").forGetter(provider -> provider.minInclusive), (App)VerticalAnchor.f_158914_.fieldOf("max_inclusive").forGetter(provider -> provider.maxInclusive)).apply((Applicative)instance, SurfaceHeightProvider::new));
    private final VerticalAnchor minInclusive;
    private final VerticalAnchor maxInclusive;

    public SurfaceHeightProvider(VerticalAnchor minInclusive, VerticalAnchor maxInclusive) {
        this.minInclusive = minInclusive;
        this.maxInclusive = maxInclusive;
    }

    @Override
    public OptionalInt sample(BlockPos pos, Structure.GenerationContext context, Heightmap.Types heightmapType) {
        int height = context.f_226622_().m_223221_(pos.m_123341_(), pos.m_123343_(), heightmapType, context.f_226629_(), context.f_226624_());
        int min = this.minY(pos, context, heightmapType);
        int max = this.maxY(pos, context, heightmapType);
        if (height < min || height > max) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(height);
    }

    @Override
    public int minY(BlockPos pos, Structure.GenerationContext context, Heightmap.Types heightmapType) {
        return this.minInclusive.m_142322_(this.getWorldGenerationContext(context));
    }

    @Override
    public int maxY(BlockPos pos, Structure.GenerationContext context, Heightmap.Types heightmapType) {
        return this.maxInclusive.m_142322_(this.getWorldGenerationContext(context));
    }

    @Override
    public StructureHeightProviderType<?> getType() {
        return (StructureHeightProviderType)ModStructureHeightProviderTypes.SURFACE_HEIGHT.get();
    }
}

