/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.common.world.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stal111.valhelsia_structures.common.world.structures.StartPoolDecider;
import com.stal111.valhelsia_structures.common.world.structures.ValhelsiaStructureSettings;
import com.stal111.valhelsia_structures.common.world.structures.height.StructureHeightProvider;
import com.stal111.valhelsia_structures.core.init.world.ModStructureTypes;
import com.stal111.valhelsia_structures.utils.StartPoolKeySet;
import com.stal111.valhelsia_structures.utils.StructureUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import org.jetbrains.annotations.Nullable;

public class ValhelsiaJigsawStructure
extends Structure {
    public static final Codec<ValhelsiaJigsawStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ValhelsiaJigsawStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)ValhelsiaStructureSettings.CODEC.forGetter(structure -> structure.settings), (App)StartPoolDecider.CODEC.fieldOf("start_pool").forGetter(structure -> structure.startPoolDecider), (App)Codec.intRange((int)0, (int)7).fieldOf("size").forGetter(structure -> structure.maxDepth), (App)StructureHeightProvider.CODEC.optionalFieldOf("start_height").forGetter(structure -> Optional.ofNullable(structure.startHeight)), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> Optional.ofNullable(structure.projectStartToHeightmap)), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter)).apply((Applicative)instance, (structureSettings, valhelsiaStructureSettings, startPoolDecider, integer, structureHeightProvider, types, integer2) -> new ValhelsiaJigsawStructure((Structure.StructureSettings)structureSettings, (ValhelsiaStructureSettings)valhelsiaStructureSettings, (StartPoolDecider)startPoolDecider, (int)integer, structureHeightProvider.orElse(null), types.orElse(null), (int)integer2))).flatXmap(ValhelsiaJigsawStructure.verifyRange(), ValhelsiaJigsawStructure.verifyRange()).codec();
    private final ValhelsiaStructureSettings settings;
    private final StartPoolDecider startPoolDecider;
    private final int maxDepth;
    @Nullable
    private final StructureHeightProvider startHeight;
    @Nullable
    private final Heightmap.Types projectStartToHeightmap;
    private final int maxDistanceFromCenter;

    public ValhelsiaJigsawStructure(Structure.StructureSettings settings, ValhelsiaStructureSettings valhelsiaStructureSettings, StartPoolDecider startPoolDecider, int maxDepth, @Nullable StructureHeightProvider startHeight, @Nullable Heightmap.Types projectStartToHeightmap, int maxDistanceFromCenter) {
        super(settings);
        this.settings = valhelsiaStructureSettings;
        this.startPoolDecider = startPoolDecider;
        this.maxDepth = maxDepth;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
    }

    public static Builder builder(BootstapContext<Structure> context, HolderSet<Biome> biomeTagKey, GenerationStep.Decoration step, TerrainAdjustment terrainAdjustment, StartPoolKeySet startPool) {
        return new Builder(context, biomeTagKey, step, terrainAdjustment, startPool);
    }

    private static Function<ValhelsiaJigsawStructure, DataResult<ValhelsiaJigsawStructure>> verifyRange() {
        return structure -> {
            int i = switch (structure.m_226620_()) {
                default -> throw new IncompatibleClassChangeError();
                case TerrainAdjustment.NONE -> 0;
                case TerrainAdjustment.BURY, TerrainAdjustment.BEARD_THIN, TerrainAdjustment.BEARD_BOX -> 12;
            };
            return structure.maxDistanceFromCenter + i > 128 ? DataResult.error(() -> "Structure size including terrain adaptation must not exceed 128") : DataResult.success((Object)structure);
        };
    }

    private boolean canGenerate(Structure.GenerationContext context) {
        ChunkPos chunkPos = context.f_226628_();
        BlockPos pos = chunkPos.m_45615_();
        ChunkGenerator generator = context.f_226622_();
        WorldgenRandom random = context.f_226626_();
        if (this.m_226619_() == GenerationStep.Decoration.FLUID_SPRINGS && !StructureUtils.isSurfaceFlat(context, 15)) {
            return false;
        }
        if (!this.canGenerateOnWater()) {
            int landHeight = generator.m_223235_(pos.m_123341_(), pos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_());
            NoiseColumn columnOfBlocks = generator.m_214184_(pos.m_123341_(), pos.m_123343_(), context.f_226629_(), context.f_226624_());
            BlockState topBlock = columnOfBlocks.m_183556_(landHeight);
            if (!topBlock.m_60819_().m_76178_()) {
                return false;
            }
        }
        return random.m_188500_() < this.getStructureSettings().spawnChance();
    }

    @Nonnull
    public Optional<Structure.GenerationStub> m_214086_(@Nonnull Structure.GenerationContext context) {
        ChunkPos chunkPos = context.f_226628_();
        if (!this.canGenerate(context)) {
            return Optional.empty();
        }
        BlockPos pos = chunkPos.m_45615_();
        OptionalInt y = OptionalInt.of(0);
        if (this.startHeight != null) {
            y = this.startHeight.sample(pos, context, Heightmap.Types.WORLD_SURFACE);
        }
        if (y.isEmpty()) {
            return Optional.empty();
        }
        return JigsawPlacement.m_227238_((Structure.GenerationContext)context, this.startPoolDecider.decide(), Optional.empty(), (int)this.maxDepth, (BlockPos)pos.m_175288_(y.getAsInt()), (boolean)true, Optional.ofNullable(this.projectStartToHeightmap), (int)this.maxDistanceFromCenter);
    }

    @Nonnull
    public StructureType<?> m_213658_() {
        return (StructureType)ModStructureTypes.VALHELSIA_JIGSAW_STRUCTURE.get();
    }

    public ValhelsiaStructureSettings getStructureSettings() {
        return this.settings;
    }

    public boolean canGenerateOnWater() {
        return this.m_226619_() == GenerationStep.Decoration.UNDERGROUND_STRUCTURES;
    }

    @Nonnull
    public BoundingBox m_226569_(@Nonnull BoundingBox boundingBox) {
        return boundingBox.m_191961_(this.settings.customMargin().intValue());
    }

    public boolean hasIndividualTerrainAdjustment() {
        return this.settings.individualTerrainAdjustment();
    }

    public static class Builder {
        private final BootstapContext<Structure> context;
        private final HolderSet<Biome> biomeHolderSet;
        private final GenerationStep.Decoration step;
        private final TerrainAdjustment terrainAdjustment;
        private final StartPoolKeySet startPool;
        private final Map<MobCategory, StructureSpawnOverride> spawnOverrides = new HashMap<MobCategory, StructureSpawnOverride>();
        private int maxDepth = 7;
        @Nullable
        private Heightmap.Types projectStartToHeightmap = Heightmap.Types.WORLD_SURFACE_WG;
        @Nullable
        private StructureHeightProvider heightProvider = null;
        private int maxDistanceFromCenter = 80;
        @Nullable
        private Double spawnChance = null;
        @Nullable
        private Integer customMargin = null;
        @Nullable
        private Boolean individualTerrainAdjustment = null;

        private Builder(BootstapContext<Structure> context, HolderSet<Biome> biomeHolderSet, GenerationStep.Decoration step, TerrainAdjustment terrainAdjustment, StartPoolKeySet startPool) {
            this.context = context;
            this.biomeHolderSet = biomeHolderSet;
            this.step = step;
            this.terrainAdjustment = terrainAdjustment;
            this.startPool = startPool;
        }

        public Builder addSpawnOverride(MobCategory category, StructureSpawnOverride override) {
            this.spawnOverrides.put(category, override);
            return this;
        }

        public Builder maxDepth(int maxDepth) {
            this.maxDepth = maxDepth;
            return this;
        }

        public Builder startHeight(StructureHeightProvider heightProvider) {
            this.projectStartToHeightmap = null;
            this.heightProvider = heightProvider;
            return this;
        }

        public Builder heightmap(Heightmap.Types projectStartToHeightmap) {
            this.projectStartToHeightmap = projectStartToHeightmap;
            this.heightProvider = null;
            return this;
        }

        public Builder individualTerrainAdjustment() {
            this.individualTerrainAdjustment = true;
            return this;
        }

        public Builder chance(double spawnChance) {
            this.spawnChance = spawnChance;
            return this;
        }

        public Builder margin(int customMargin) {
            this.customMargin = customMargin;
            return this;
        }

        public ValhelsiaJigsawStructure build() {
            Structure.StructureSettings settings = new Structure.StructureSettings(this.biomeHolderSet, this.spawnOverrides, this.step, this.terrainAdjustment);
            ValhelsiaStructureSettings valhelsiaStructureSettings = new ValhelsiaStructureSettings(this.spawnChance, this.customMargin, this.individualTerrainAdjustment);
            return new ValhelsiaJigsawStructure(settings, valhelsiaStructureSettings, StartPoolDecider.of((HolderGetter<StructureTemplatePool>)this.context.m_255420_(Registries.f_256948_), this.startPool), this.maxDepth, this.heightProvider, this.projectStartToHeightmap, this.maxDistanceFromCenter);
        }
    }
}

