/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.teamabnormals.blueprint.client.BlueprintRenderTypes;
import com.teamabnormals.upgrade_aquatic.client.model.PikeModel;
import com.teamabnormals.upgrade_aquatic.common.entity.animal.Pike;
import com.teamabnormals.upgrade_aquatic.common.entity.animal.PikeType;
import java.util.Locale;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GlowingPikeRenderLayer<T extends Pike, M extends PikeModel<T>>
extends RenderLayer<T, M> {
    public GlowingPikeRenderLayer(RenderLayerParent<T, M> renderer) {
        super(renderer);
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T pike, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (((Pike)((Object)pike)).getPikeType().rarity != PikeType.PikeRarity.LEGENDARY) {
            return;
        }
        ((PikeModel)this.m_117386_()).setupAnim(pike, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ((PikeModel)this.m_117386_()).m_7695_(matrixStackIn, bufferIn.m_6299_(BlueprintRenderTypes.getUnshadedCutoutEntity((ResourceLocation)this.getPikeOverlayTexture((Pike)((Object)pike)), (boolean)false)), 240, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    private ResourceLocation getPikeOverlayTexture(Pike pike) {
        return new ResourceLocation("upgrade_aquatic", String.format("textures/entity/pike/%s_glow.png", pike.getPikeType().name().toLowerCase(Locale.ROOT)));
    }
}

