/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui;

import dan200.computercraft.shared.computer.core.ComputerFamily;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.TextureAtlasHolder;
import net.minecraft.resources.ResourceLocation;

public final class GuiSprites
extends TextureAtlasHolder {
    public static final ResourceLocation SPRITE_SHEET = new ResourceLocation("computercraft", "gui");
    public static final ResourceLocation TEXTURE = SPRITE_SHEET.m_247266_(x -> "textures/atlas/" + x + ".png");
    public static final ButtonTextures TURNED_OFF = GuiSprites.button("turned_off");
    public static final ButtonTextures TURNED_ON = GuiSprites.button("turned_on");
    public static final ButtonTextures TERMINATE = GuiSprites.button("terminate");
    public static final ComputerTextures COMPUTER_NORMAL = GuiSprites.computer("normal", true, true);
    public static final ComputerTextures COMPUTER_ADVANCED = GuiSprites.computer("advanced", true, true);
    public static final ComputerTextures COMPUTER_COMMAND = GuiSprites.computer("command", false, true);
    public static final ComputerTextures COMPUTER_COLOUR = GuiSprites.computer("colour", true, false);
    @Nullable
    private static GuiSprites instance;

    private static ButtonTextures button(String name) {
        return new ButtonTextures(new ResourceLocation("computercraft", "gui/buttons/" + name), new ResourceLocation("computercraft", "gui/buttons/" + name + "_hover"));
    }

    private static ComputerTextures computer(String name, boolean pocket, boolean sidebar) {
        return new ComputerTextures(new ResourceLocation("computercraft", "gui/border_" + name), pocket ? new ResourceLocation("computercraft", "gui/pocket_bottom_" + name) : null, sidebar ? new ResourceLocation("computercraft", "gui/sidebar_" + name) : null);
    }

    private GuiSprites(TextureManager textureManager) {
        super(textureManager, TEXTURE, SPRITE_SHEET);
    }

    public static GuiSprites initialise(TextureManager textureManager) {
        if (instance != null) {
            throw new IllegalStateException("GuiSprites has already been initialised");
        }
        instance = new GuiSprites(textureManager);
        return instance;
    }

    public static TextureAtlasSprite get(ResourceLocation texture) {
        if (instance == null) {
            throw new IllegalStateException("GuiSprites has not been initialised");
        }
        return instance.m_118901_(texture);
    }

    public static ComputerTextures getComputerTextures(ComputerFamily family) {
        return switch (family) {
            default -> throw new IncompatibleClassChangeError();
            case ComputerFamily.NORMAL -> COMPUTER_NORMAL;
            case ComputerFamily.ADVANCED -> COMPUTER_ADVANCED;
            case ComputerFamily.COMMAND -> COMPUTER_COMMAND;
        };
    }

    public record ButtonTextures(ResourceLocation normal, ResourceLocation active) {
        public TextureAtlasSprite get(boolean active) {
            return GuiSprites.get(active ? this.active : this.normal);
        }

        public Stream<ResourceLocation> textures() {
            return Stream.of(this.normal, this.active);
        }
    }

    public record ComputerTextures(ResourceLocation border, @Nullable ResourceLocation pocketBottom, @Nullable ResourceLocation sidebar) {
        public Stream<ResourceLocation> textures() {
            return Stream.of(this.border, this.pocketBottom, this.sidebar).filter(Objects::nonNull);
        }
    }
}

