/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_furniture.common.entity;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.valhelsia.valhelsia_furniture.common.block.SeatableBlock;
import net.valhelsia.valhelsia_furniture.core.registry.ModEntities;
import org.jetbrains.annotations.NotNull;

public class SeatEntity
extends Entity {
    private EjectType ejectType = EjectType.NORTH;

    public SeatEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public SeatEntity(BlockPos pos, double ridingOffset, Level level, EjectType ejectType) {
        super((EntityType)ModEntities.SEAT.get(), level);
        this.ejectType = ejectType;
        this.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + ridingOffset, (double)pos.m_123343_() + 0.5);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            BlockPos pos = this.m_20183_();
            if (this.m_20197_().isEmpty() || this.m_9236_().m_46859_(pos)) {
                this.m_146870_();
                this.m_9236_().m_46717_(pos, this.m_9236_().m_8055_(pos).m_60734_());
            }
        }
    }

    public void m_142687_(@NotNull Entity.RemovalReason reason) {
        if (reason == Entity.RemovalReason.DISCARDED) {
            this.m_20197_().forEach(Entity::m_8127_);
        }
        super.m_142687_(reason);
    }

    @NotNull
    public Vec3 m_7688_(@NotNull LivingEntity livingEntity) {
        BlockPos pos = this.m_20183_();
        if (this.getSeatableBlock(this.m_9236_(), pos).isEmpty()) {
            return super.m_7688_(livingEntity);
        }
        int[][] offsets = DismountHelper.m_38467_((Direction)this.ejectType.getPreferredDirection(this.m_9236_().m_8055_(pos), livingEntity).m_122428_());
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (Pose pose : livingEntity.m_7431_()) {
            AABB aabb = livingEntity.m_21270_(pose);
            for (int[] offset : offsets) {
                mutableBlockPos.m_122178_(pos.m_123341_() + offset[0], pos.m_123342_(), pos.m_123343_() + offset[1]);
                double floorHeight = this.m_9236_().m_45573_((BlockPos)mutableBlockPos);
                if (!DismountHelper.m_38439_((double)floorHeight)) continue;
                Vec3 vec3 = Vec3.m_82514_((Vec3i)mutableBlockPos, (double)floorHeight);
                if (!DismountHelper.m_38456_((CollisionGetter)this.m_9236_(), (LivingEntity)livingEntity, (AABB)aabb.m_82383_(vec3))) continue;
                livingEntity.m_20124_(pose);
                return vec3;
            }
        }
        return super.m_7688_(livingEntity);
    }

    private Optional<SeatableBlock> getSeatableBlock(Level level, BlockPos pos) {
        Optional<SeatableBlock> optional;
        Block block = level.m_8055_(pos).m_60734_();
        if (block instanceof SeatableBlock) {
            SeatableBlock seatableBlock = (SeatableBlock)block;
            optional = Optional.of(seatableBlock);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    protected void m_8097_() {
    }

    protected void m_7378_(@NotNull CompoundTag tag) {
        this.ejectType = EjectType.fromName(tag.m_128461_("EjectType"));
    }

    protected void m_7380_(@NotNull CompoundTag tag) {
        tag.m_128359_("EjectType", this.ejectType.name);
    }

    public double m_6048_() {
        return 0.0;
    }

    public static enum EjectType {
        NORTH("north", (state, livingEntity) -> Direction.NORTH),
        BLOCK_HORIZONTAL_FACING("block_horizontal_facing", (state, livingEntity) -> (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)),
        ENTITY_HEAD_ROTATION("entity_head_rotation", (state, livingEntity) -> Direction.m_122364_((double)livingEntity.f_20885_));

        private final String name;
        private final BiFunction<BlockState, LivingEntity, Direction> preferredDirection;

        private EjectType(String name, BiFunction<BlockState, LivingEntity, Direction> preferredDirection) {
            this.name = name;
            this.preferredDirection = preferredDirection;
        }

        public String getName() {
            return this.name;
        }

        public Direction getPreferredDirection(BlockState state, LivingEntity livingEntity) {
            return this.preferredDirection.apply(state, livingEntity);
        }

        public static EjectType fromName(String name) {
            return Arrays.stream(EjectType.values()).filter(ejectType -> ejectType.getName().equals(name)).findFirst().orElse(NORTH);
        }
    }
}

