/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.util;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.datagen.EmbersSounds;
import com.rekindled.embers.particle.GlowParticleOptions;
import com.rekindled.embers.particle.SparkParticleOptions;
import com.rekindled.embers.recipe.SingleItemContainer;
import com.rekindled.embers.util.EmberInventoryUtil;
import com.rekindled.embers.util.EmbersColors;
import com.rekindled.embers.util.Misc;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.loot.LootModifier;

public class SuperHeaterLootModifier
extends LootModifier {
    public static final Codec<SuperHeaterLootModifier> CODEC = RecordCodecBuilder.create(inst -> SuperHeaterLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, SuperHeaterLootModifier::new));
    public SmeltingRecipe cachedRecipe = null;

    public SuperHeaterLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    public Codec<SuperHeaterLootModifier> codec() {
        return CODEC;
    }

    public ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        Player player;
        Entity user = null;
        if (context.m_78936_(LootContextParams.f_81458_)) {
            user = (Entity)context.m_165124_(LootContextParams.f_81458_);
        } else if (context.m_78936_(LootContextParams.f_81455_)) {
            user = (Entity)context.m_165124_(LootContextParams.f_81455_);
        }
        if (user instanceof Player && EmberInventoryUtil.getEmberTotal(player = (Player)user) >= RegistryManager.SUPERHEATER_AUGMENT.getCost()) {
            boolean smelted = false;
            int limit = generatedLoot.size();
            for (int i = 0; i < limit; ++i) {
                SingleItemContainer wrapper = new SingleItemContainer((ItemStack)generatedLoot.get(i));
                this.cachedRecipe = Misc.getRecipe(this.cachedRecipe, RecipeType.f_44108_, wrapper, (Level)context.m_78952_());
                if (this.cachedRecipe == null) continue;
                ItemStack stack = this.cachedRecipe.m_5874_((Container)wrapper, context.m_78952_().m_9598_());
                generatedLoot.add((Object)stack);
                generatedLoot.set(i, (Object)ItemStack.f_41583_);
                smelted = true;
            }
            if (smelted) {
                Vec3 pos = (Vec3)context.m_165124_(LootContextParams.f_81460_);
                context.m_78952_().m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, (SoundEvent)EmbersSounds.FIREBALL_HIT.get(), SoundSource.PLAYERS, 0.5f, Misc.random.nextFloat() * 0.5f + 0.2f);
                EmberInventoryUtil.removeEmber(player, RegistryManager.SUPERHEATER_AUGMENT.getCost());
                context.m_78952_().m_8767_((ParticleOptions)new SparkParticleOptions(EmbersColors.EMBER_ID, 1.0f), pos.f_82479_, pos.f_82480_, pos.f_82481_, 10, 0.0, 0.0, 0.0, 1.0);
                context.m_78952_().m_8767_((ParticleOptions)GlowParticleOptions.EMBER, pos.f_82479_, pos.f_82480_, pos.f_82481_, 20, 0.25, 0.25, 0.25, 0.1);
            }
        }
        return generatedLoot;
    }
}

