/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.util;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.rekindled.embers.EmbersClientEvents;
import com.rekindled.embers.render.EmbersRenderTypes;
import com.rekindled.embers.util.EmberGenUtil;
import com.rekindled.embers.util.EmbersColors;
import com.rekindled.embers.util.NoiseGenUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class RenderUtil {
    public static void renderWavyEmberLine(BufferBuilder b, double x1, double y1, double x2, double y2, double thickness) {
        RenderUtil.renderWavyEmberLine(b, x1, y1, x2, y2, thickness, 1.0, EmbersColors.EMBER);
    }

    public static void renderWavyEmberLine(BufferBuilder b, double x1, double y1, double x2, double y2, double thickness, double density, Vector3f color) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double angleRads = Math.atan2(y2 - y1, x2 - x1);
        double dist = Math.sqrt(dx * dx + dy * dy);
        double orthoX = Math.cos(angleRads + 1.5707963267948966);
        double orthoY = Math.sin(angleRads + 1.5707963267948966);
        for (int i = 0; i <= 10; ++i) {
            float coeff = (float)i / 10.0f;
            double thickCoeff = Math.min(1.0, (double)(1.4f * Mth.m_14116_((float)(2.0f * (0.5f - Math.abs(coeff - 0.5f))))));
            double tx = x1 * (double)(1.0f - coeff) + x2 * (double)coeff;
            double ty = NoiseGenUtil.interpolate((float)y1, (float)y2, coeff);
            float tick = Minecraft.m_91087_().getPartialTick() + (float)EmbersClientEvents.ticks;
            int offX = (int)(6.0f * tick);
            int offZ = (int)(6.0f * tick);
            float sine = (float)Math.sin((double)coeff * Math.PI * 2.0 + (double)(0.25f * tick)) + 0.25f * (float)Math.sin((double)coeff * Math.PI * (double)3.47f + (double)(0.25f * tick));
            float sineOff = (4.0f + (float)thickness) / 3.0f;
            float densityCoeff = (float)(0.5 + 0.5 * Math.sin((double)coeff * Math.PI * 2.0 * dist * 0.01 + (double)tick * 0.2));
            float minusDensity = (float)density * densityCoeff * EmberGenUtil.getEmberDensity(1L, offX + (int)(tx - thickness * orthoX * thickCoeff), offZ + (int)(ty - thickness * orthoY * thickCoeff));
            float plusDensity = (float)density * densityCoeff * EmberGenUtil.getEmberDensity(1L, offX + (int)(tx - thickness * orthoX * thickCoeff), offZ + (int)(ty - thickness * orthoY * thickCoeff));
            b.m_5483_(tx - thickness * (double)(0.5f + minusDensity) * orthoX * thickCoeff - thickCoeff * orthoX * (double)sine * (double)sineOff, ty - thickness * (double)(0.5f + minusDensity) * orthoY * thickCoeff - thickCoeff * orthoY * (double)sine * (double)sineOff, 0.0).m_85950_(color.x, color.y, color.z, (float)Math.pow(0.5f * (float)Math.max(0.0, thickCoeff - (double)0.4f) * minusDensity, 1.0)).m_5752_();
            b.m_5483_(tx + thickness * (double)(0.5f + plusDensity) * orthoX * thickCoeff - thickCoeff * orthoX * (double)sine * (double)sineOff, ty + thickness * (double)(0.5f + plusDensity) * orthoY * thickCoeff - thickCoeff * orthoY * (double)sine * (double)sineOff, 0.0).m_85950_(color.x, color.y, color.z, (float)Math.pow(0.5f * (float)Math.max(0.0, thickCoeff - (double)0.4f) * plusDensity, 1.0)).m_5752_();
        }
    }

    public static void renderHighlightCircle(BufferBuilder b, double x1, double y1, double thickness) {
        RenderUtil.renderHighlightCircle(b, x1, y1, thickness, 0.0, EmbersColors.EMBER);
    }

    public static void renderHighlightCircle(BufferBuilder b, double x1, double y1, double thickness, double z, Vector3f color) {
        for (int i = 0; i < 40; ++i) {
            float coeff = (float)i / 40.0f;
            int i2 = i + 1;
            if (i2 == 40) {
                i2 = 0;
            }
            float coeff2 = (float)i2 / 40.0f;
            double angle = Math.PI * 2 * (double)coeff;
            double angle2 = Math.PI * 2 * (double)coeff2;
            float tick = Minecraft.m_91087_().getPartialTick() + (float)EmbersClientEvents.ticks;
            double calcAngle2 = angle2;
            float density1 = EmberGenUtil.getEmberDensity(4L, (int)x1 + (int)(480.0 * angle), (int)y1 + 4 * (int)tick + (int)(4.0 * thickness));
            float density2 = EmberGenUtil.getEmberDensity(4L, (int)x1 + (int)(480.0 * calcAngle2), (int)y1 + 4 * (int)tick + (int)(4.0 * thickness));
            double tx = x1 + Math.sin(angle + (double)(0.03125f * tick)) * (thickness - thickness * 0.5 * (double)density1);
            double ty = y1 + Math.cos(angle + (double)(0.03125f * tick)) * (thickness - thickness * 0.5 * (double)density1);
            double tx2 = x1 + Math.sin(angle2 + (double)(0.03125f * tick)) * (thickness - thickness * 0.5 * (double)density2);
            double ty2 = y1 + Math.cos(angle2 + (double)(0.03125f * tick)) * (thickness - thickness * 0.5 * (double)density2);
            b.m_5483_(x1, y1, z).m_85950_(color.x, color.y, color.z, 1.0f).m_5752_();
            b.m_5483_(tx, ty, z).m_85950_(color.x, color.y, color.z, 0.0f).m_5752_();
            b.m_5483_(tx2, ty2, z).m_85950_(color.x, color.y, color.z, 0.0f).m_5752_();
        }
    }

    public static void drawColorRectBatched(PoseStack pose, MultiBufferSource.BufferSource bufferSource, float x, float y, float zLevel, float widthIn, float heightIn, float r1, float g1, float b1, float a1, float r2, float g2, float b2, float a2, float r3, float g3, float b3, float a3, float r4, float g4, float b4, float a4) {
        Matrix4f matrix4f = pose.m_85850_().m_252922_();
        VertexConsumer vertexconsumer = bufferSource.m_6299_(EmbersRenderTypes.GLOW_GUI);
        vertexconsumer.m_252986_(matrix4f, x + 0.0f, y + heightIn, zLevel).m_85950_(r1, g1, b1, a1).m_5752_();
        vertexconsumer.m_252986_(matrix4f, x + widthIn, y + heightIn, zLevel).m_85950_(r2, g2, b2, a2).m_5752_();
        vertexconsumer.m_252986_(matrix4f, x + widthIn, y + 0.0f, zLevel).m_85950_(r3, g3, b3, a3).m_5752_();
        vertexconsumer.m_252986_(matrix4f, x + 0.0f, y + 0.0f, zLevel).m_85950_(r4, g4, b4, a4).m_5752_();
    }

    public static void drawHeatBarEnd(PoseStack pose, MultiBufferSource.BufferSource bufferSource, float x, float y, float zLevel, float widthIn, float heightIn, float minU, float minV, float maxU, float maxV) {
        Matrix4f matrix4f = pose.m_85850_().m_252922_();
        VertexConsumer vertexconsumer = bufferSource.m_6299_(EmbersRenderTypes.HEAT_BAR_ENDS);
        vertexconsumer.m_252986_(matrix4f, x + 0.0f, y + 0.0f, zLevel).m_7421_(minU, minV).m_5752_();
        vertexconsumer.m_252986_(matrix4f, x + 0.0f, y + heightIn, zLevel).m_7421_(minU, maxV).m_5752_();
        vertexconsumer.m_252986_(matrix4f, x + widthIn, y + heightIn, zLevel).m_7421_(maxU, maxV).m_5752_();
        vertexconsumer.m_252986_(matrix4f, x + widthIn, y + 0.0f, zLevel).m_7421_(maxU, minV).m_5752_();
    }

    public static void renderAlchemyCircle(VertexConsumer buf, Matrix4f matrix4f, float x, float y, float z, float r, float g, float b, float a, float radius, float angle) {
        float sign = 1.0f;
        int lightx = 0xF000F0;
        int lighty = 0xF000F0;
        for (float i = 0.0f; i < 360.0f; i += 10.0f) {
            float tx = (float)Math.sin(Math.toRadians(i + angle));
            float tz = (float)Math.cos(Math.toRadians(i + angle));
            float tx2 = (float)Math.sin(Math.toRadians(i + angle + 10.0f));
            float tz2 = (float)Math.cos(Math.toRadians(i + angle + 10.0f));
            buf.m_252986_(matrix4f, x + radius * tx, y, z + radius * tz).m_7421_(0.0f, 0.0f).m_7120_(lightx, lighty).m_85950_(r, g, b, a).m_5752_();
            buf.m_252986_(matrix4f, x + (radius + 0.25f) * tx, y, z + (radius + 0.25f) * tz).m_7421_(0.0f, 0.5f).m_7120_(lightx, lighty).m_85950_(r, g, b, a).m_5752_();
            buf.m_252986_(matrix4f, x + (radius + 0.25f) * tx2, y, z + (radius + 0.25f) * tz2).m_7421_(1.0f, 0.5f).m_7120_(lightx, lighty).m_85950_(r, g, b, a).m_5752_();
            buf.m_252986_(matrix4f, x + radius * tx2, y, z + radius * tz2).m_7421_(1.0f, 0.0f).m_7120_(lightx, lighty).m_85950_(r, g, b, a).m_5752_();
        }
        float ax = (float)(((double)radius + 0.24) * Math.sin(Math.toRadians(0.0f + angle)));
        float az = (float)(((double)radius + 0.24) * Math.cos(Math.toRadians(0.0f + angle)));
        float adx = (float)(0.1875 * Math.cos(Math.toRadians(0.0f + angle)));
        float adz = (float)(0.1875 * -Math.sin(Math.toRadians(0.0f + angle)));
        float bx = (float)(((double)radius + 0.24) * Math.sin(Math.toRadians(120.0f + angle)));
        float bz = (float)(((double)radius + 0.24) * Math.cos(Math.toRadians(120.0f + angle)));
        float bdx = (float)(0.1875 * Math.cos(Math.toRadians(120.0f + angle)));
        float bdz = (float)(0.1875 * -Math.sin(Math.toRadians(120.0f + angle)));
        float cx = (float)(((double)radius + 0.24) * Math.sin(Math.toRadians(240.0f + angle)));
        float cz = (float)(((double)radius + 0.24) * Math.cos(Math.toRadians(240.0f + angle)));
        float cdx = (float)(0.1875 * Math.cos(Math.toRadians(240.0f + angle)));
        float cdz = (float)(0.1875 * -Math.sin(Math.toRadians(240.0f + angle)));
        buf.m_252986_(matrix4f, x + (ax - adx), y + 5.0E-5f * sign, z + (az - adz)).m_7421_(0.0f, 0.5f).m_7120_(lightx, lighty).m_85950_(r, g, b, a).m_5752_();
        buf.m_252986_(matrix4f, x + (ax + adx), y + 5.0E-5f * sign, z + (az + adz)).m_7421_(0.0f, 1.0f).m_7120_(lightx, lighty).m_85950_(r, g, b, a).m_5752_();
        buf.m_252986_(matrix4f, x + (bx - bdx), y + 5.0E-5f * sign, z + (bz - bdz)).m_7421_(1.0f, 1.0f).m_7120_(lightx, lighty).m_85950_(r, g, b, a).m_5752_();
        buf.m_252986_(matrix4f, x + (bx + bdx), y + 5.0E-5f * sign, z + (bz + bdz)).m_7421_(1.0f, 0.5f).m_7120_(lightx, lighty).m_85950_(r, g, b, a).m_5752_();
        buf.m_252986_(matrix4f, x + (bx - bdx), y + 1.0E-4f * sign, z + (bz - bdz)).m_7421_(0.0f, 0.5f).m_7120_(lightx, lighty).m_85950_(r, g, b, a).m_5752_();
        buf.m_252986_(matrix4f, x + (bx + bdx), y + 1.0E-4f * sign, z + (bz + bdz)).m_7421_(0.0f, 1.0f).m_7120_(lightx, lighty).m_85950_(r, g, b, a).m_5752_();
        buf.m_252986_(matrix4f, x + (cx - cdx), y + 1.0E-4f * sign, z + (cz - cdz)).m_7421_(1.0f, 1.0f).m_7120_(lightx, lighty).m_85950_(r, g, b, a).m_5752_();
        buf.m_252986_(matrix4f, x + (cx + cdx), y + 1.0E-4f * sign, z + (cz + cdz)).m_7421_(1.0f, 0.5f).m_7120_(lightx, lighty).m_85950_(r, g, b, a).m_5752_();
        buf.m_252986_(matrix4f, x + (ax - adx), y + 1.5E-4f * sign, z + (az - adz)).m_7421_(0.0f, 0.5f).m_7120_(lightx, lighty).m_85950_(r, g, b, a).m_5752_();
        buf.m_252986_(matrix4f, x + (ax + adx), y + 1.5E-4f * sign, z + (az + adz)).m_7421_(0.0f, 1.0f).m_7120_(lightx, lighty).m_85950_(r, g, b, a).m_5752_();
        buf.m_252986_(matrix4f, x + (cx - cdx), y + 1.5E-4f * sign, z + (cz - cdz)).m_7421_(1.0f, 1.0f).m_7120_(lightx, lighty).m_85950_(r, g, b, a).m_5752_();
        buf.m_252986_(matrix4f, x + (cx + cdx), y + 1.5E-4f * sign, z + (cz + cdz)).m_7421_(1.0f, 0.5f).m_7120_(lightx, lighty).m_85950_(r, g, b, a).m_5752_();
    }
}

