/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.render;

import com.google.common.base.MoreObjects;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.rekindled.embers.item.AlchemyHintItem;
import com.rekindled.embers.render.EmbersRenderTypes;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class AlchemicalNoteItemRenderer
extends BlockEntityWithoutLevelRenderer {
    public Font font;
    public Minecraft minecraft;
    public ItemInHandRenderer itemInHandRenderer;
    public ItemRenderer itemRenderer;

    public AlchemicalNoteItemRenderer(BlockEntityRenderDispatcher pBlockEntityRenderDispatcher, EntityModelSet pEntityModelSet) {
        super(pBlockEntityRenderDispatcher, pEntityModelSet);
        this.font = pBlockEntityRenderDispatcher.f_112253_;
        this.minecraft = Minecraft.m_91087_();
        this.itemInHandRenderer = this.minecraft.m_91290_().m_234586_();
        this.itemRenderer = this.minecraft.m_91291_();
    }

    public void m_108829_(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        if (displayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND || displayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND) {
            boolean flag = displayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND == (this.minecraft.f_91074_.m_5737_() == HumanoidArm.RIGHT);
            HumanoidArm humanoidarm = flag ? this.minecraft.f_91074_.m_5737_() : this.minecraft.f_91074_.m_5737_().m_20828_();
            InteractionHand interactionhand = (InteractionHand)MoreObjects.firstNonNull((Object)this.minecraft.f_91074_.f_20912_, (Object)InteractionHand.MAIN_HAND);
            float pitch = Mth.m_14179_((float)this.minecraft.getPartialTick(), (float)this.minecraft.f_91074_.f_19860_, (float)this.minecraft.f_91074_.m_146909_());
            float swingProgress = interactionhand == InteractionHand.MAIN_HAND ? this.minecraft.f_91074_.m_21324_(this.minecraft.getPartialTick()) : 0.0f;
            float equippedProgress = interactionhand == InteractionHand.MAIN_HAND ? 1.0f - Mth.m_14179_((float)this.minecraft.getPartialTick(), (float)this.itemInHandRenderer.f_109303_, (float)this.itemInHandRenderer.f_109302_) : 0.0f;
            poseStack.m_85836_();
            poseStack.m_85841_(64.0f, 64.0f, 64.0f);
            if (flag && (this.minecraft.f_91074_.m_21206_().m_41619_() || ItemStack.m_150942_((ItemStack)this.minecraft.f_91074_.m_21206_(), (ItemStack)stack))) {
                this.renderTwoHandedNote(poseStack, buffer, packedLight, packedOverlay, pitch, equippedProgress, swingProgress, stack);
            } else {
                this.renderOneHandedNote(poseStack, buffer, packedLight, packedOverlay, equippedProgress, humanoidarm, swingProgress, stack);
            }
            poseStack.m_85849_();
        } else if (displayContext == ItemDisplayContext.FIXED) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.5, 0.49);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            poseStack.m_85841_(4.0f, 4.0f, 4.0f);
            this.renderNote(poseStack, buffer, packedLight, packedOverlay, stack);
            poseStack.m_85849_();
        }
    }

    private void renderOneHandedNote(PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, float equippedProgress, HumanoidArm hand, float swingProgress, ItemStack stack) {
        float f = hand == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        poseStack.m_252880_(f * 0.125f, -0.125f, 0.0f);
        if (!this.minecraft.f_91074_.m_20145_()) {
            poseStack.m_85836_();
            poseStack.m_252781_(Axis.f_252403_.m_252977_(f * 10.0f));
            this.itemInHandRenderer.m_109346_(poseStack, buffer, packedLight, equippedProgress, swingProgress, hand);
            poseStack.m_85849_();
        }
        poseStack.m_85836_();
        poseStack.m_252880_(f * 0.51f, -0.08f + equippedProgress * -1.2f, -0.75f);
        float f1 = Mth.m_14116_((float)swingProgress);
        float f2 = Mth.m_14031_((float)(f1 * (float)Math.PI));
        float f3 = -0.5f * f2;
        float f4 = 0.4f * Mth.m_14031_((float)(f1 * ((float)Math.PI * 2)));
        float f5 = -0.3f * Mth.m_14031_((float)(swingProgress * (float)Math.PI));
        poseStack.m_252880_(f * f3, f4 - 0.3f * f2, f5);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(f2 * -45.0f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(f * f2 * -30.0f));
        this.renderNote(poseStack, buffer, packedLight, packedOverlay, stack);
        poseStack.m_85849_();
    }

    private void renderTwoHandedNote(PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, float pitch, float equippedProgress, float swingProgress, ItemStack stack) {
        float f = Mth.m_14116_((float)swingProgress);
        float f1 = -0.2f * Mth.m_14031_((float)(swingProgress * (float)Math.PI));
        float f2 = -0.4f * Mth.m_14031_((float)(f * (float)Math.PI));
        poseStack.m_252880_(0.0f, -f1 / 2.0f, f2);
        float f3 = this.itemInHandRenderer.m_109312_(pitch);
        poseStack.m_252880_(0.0f, 0.04f + equippedProgress * -1.2f + f3 * -0.5f, -0.72f);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(f3 * -85.0f));
        if (!this.minecraft.f_91074_.m_20145_()) {
            poseStack.m_85836_();
            poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            this.itemInHandRenderer.m_109361_(poseStack, buffer, packedLight, HumanoidArm.RIGHT);
            this.itemInHandRenderer.m_109361_(poseStack, buffer, packedLight, HumanoidArm.LEFT);
            poseStack.m_85849_();
        }
        float f4 = Mth.m_14031_((float)(f * (float)Math.PI));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(f4 * 20.0f));
        poseStack.m_85841_(2.0f, 2.0f, 2.0f);
        this.renderNote(poseStack, buffer, packedLight, packedOverlay, stack);
    }

    public void renderNote(PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, ItemStack stack) {
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        poseStack.m_85841_(0.38f, 0.38f, 0.38f);
        poseStack.m_252880_(-0.5f, -0.5f, 0.0f);
        poseStack.m_85841_(0.015625f, 0.015625f, 0.015625f);
        VertexConsumer vertexconsumer = buffer.m_6299_(EmbersRenderTypes.NOTE_BACKGROUND);
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        vertexconsumer.m_252986_(matrix4f, 0.0f, 64.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_86008_(packedOverlay).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.5f, -1.0f).m_5752_();
        vertexconsumer.m_252986_(matrix4f, 64.0f, 64.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_86008_(packedOverlay).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.5f, -1.0f).m_5752_();
        vertexconsumer.m_252986_(matrix4f, 64.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_86008_(packedOverlay).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.5f, -1.0f).m_5752_();
        vertexconsumer.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_86008_(packedOverlay).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.5f, -1.0f).m_5752_();
        ArrayList<ItemStack> inputs = AlchemyHintItem.getInputs(stack);
        ArrayList<ItemStack> aspects = AlchemyHintItem.getAspects(stack);
        ItemStack result = AlchemyHintItem.getResult(stack);
        if (inputs.size() == aspects.size()) {
            for (int j = 0; j < inputs.size(); ++j) {
                int pedestal = 10;
                int margin = 4;
                int width = (64 - pedestal - 2 * margin) / inputs.size();
                poseStack.m_85837_(0.0, 0.0, -0.01);
                this.renderPedestal(poseStack, margin + width * j + width / 2 + 1, 10, buffer, packedLight, packedOverlay, aspects.get(j), inputs.get(j));
            }
        }
        poseStack.m_85837_(32.0, 44.0, -0.01);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        poseStack.m_85850_().m_252922_().scale(16.0f, 16.0f, 0.01f);
        poseStack.m_85850_().m_252943_().rotate((Quaternionfc)Axis.f_252529_.m_252977_(-22.5f));
        this.itemRenderer.m_269128_(result, ItemDisplayContext.GUI, packedLight, packedOverlay, poseStack, buffer, (Level)this.minecraft.f_91073_, 0);
    }

    public void renderPedestal(PoseStack poseStack, int x, int y, MultiBufferSource buffer, int combinedLight, int packedOverlay, ItemStack aspect, ItemStack ingredient) {
        VertexConsumer vertexconsumer = buffer.m_6299_(EmbersRenderTypes.NOTE_PEDESTAL);
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        vertexconsumer.m_252986_(matrix4f, (float)x, (float)(y + 14), 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_86008_(packedOverlay).m_85969_(combinedLight).m_252939_(normal, 0.0f, 0.5f, -1.0f).m_5752_();
        vertexconsumer.m_252986_(matrix4f, (float)(x + 10), (float)(y + 14), 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_86008_(packedOverlay).m_85969_(combinedLight).m_252939_(normal, 0.0f, 0.5f, -1.0f).m_5752_();
        vertexconsumer.m_252986_(matrix4f, (float)(x + 10), (float)y, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_86008_(packedOverlay).m_85969_(combinedLight).m_252939_(normal, 0.0f, 0.5f, -1.0f).m_5752_();
        vertexconsumer.m_252986_(matrix4f, (float)x, (float)y, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_86008_(packedOverlay).m_85969_(combinedLight).m_252939_(normal, 0.0f, 0.5f, -1.0f).m_5752_();
        poseStack.m_85836_();
        poseStack.m_85837_((double)(x + 5), (double)(y + 7), -0.01);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        poseStack.m_85850_().m_252922_().scale(8.0f, 8.0f, 0.01f);
        poseStack.m_85850_().m_252943_().rotate((Quaternionfc)Axis.f_252529_.m_252977_(-22.5f));
        this.itemRenderer.m_269128_(aspect, ItemDisplayContext.GUI, combinedLight, packedOverlay, poseStack, buffer, (Level)this.minecraft.f_91073_, 0);
        poseStack.m_85837_(0.0, 1.25, 0.0);
        this.itemRenderer.m_269128_(ingredient, ItemDisplayContext.GUI, combinedLight, packedOverlay, poseStack, buffer, (Level)this.minecraft.f_91073_, 0);
        poseStack.m_85849_();
    }
}

