/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.item.IInflictorGem;
import com.rekindled.embers.api.item.IInflictorGemHolder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class GemSocketRecipe
implements CraftingRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    public final ResourceLocation id;
    public final Ingredient ingredient;

    public GemSocketRecipe(ResourceLocation id, Ingredient ingredient) {
        this.id = id;
        this.ingredient = ingredient;
    }

    public boolean matches(CraftingContainer container, Level level) {
        ItemStack stack;
        int i;
        ItemStack cloak = ItemStack.f_41583_;
        int cloaks = 0;
        int strings = 0;
        int gems = 0;
        for (i = 0; i < container.m_6643_(); ++i) {
            stack = container.m_8020_(i);
            if (!(stack.m_41720_() instanceof IInflictorGemHolder) || ((IInflictorGemHolder)stack.m_41720_()).getAttachedGemCount(stack) != 0) continue;
            cloak = stack;
        }
        for (i = 0; i < container.m_6643_(); ++i) {
            stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof IInflictorGemHolder) {
                ++cloaks;
                continue;
            }
            if (this.ingredient.test(stack)) {
                ++strings;
                continue;
            }
            if (!cloak.m_41619_() && ((IInflictorGemHolder)cloak.m_41720_()).canAttachGem(cloak, stack)) {
                ++gems;
                continue;
            }
            return false;
        }
        return !cloak.m_41619_() && cloaks == 1 && strings == 1 && gems > 0 && gems <= ((IInflictorGemHolder)cloak.m_41720_()).getGemSlots(cloak);
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess registryAccess) {
        ItemStack capeStack = ItemStack.f_41583_;
        for (int i = 0; i < container.m_6643_(); ++i) {
            if (container.m_8020_(i).m_41619_() || !(container.m_8020_(i).m_41720_() instanceof IInflictorGemHolder)) continue;
            capeStack = container.m_8020_(i).m_41777_();
        }
        if (!capeStack.m_41619_()) {
            int counter = 0;
            for (int i = 0; i < container.m_6643_(); ++i) {
                ItemStack stack = container.m_8020_(i);
                if (stack.m_41619_() || !(stack.m_41720_() instanceof IInflictorGem)) continue;
                ((IInflictorGemHolder)capeStack.m_41720_()).attachGem(capeStack, stack, counter);
                ++counter;
            }
            return capeStack;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 3;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return new ItemStack((ItemLike)RegistryManager.ASHEN_CLOAK.get());
    }

    public boolean m_5598_() {
        return true;
    }

    public boolean m_271738_() {
        return false;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public CraftingBookCategory m_245232_() {
        return CraftingBookCategory.EQUIPMENT;
    }

    public static class Serializer
    implements RecipeSerializer<GemSocketRecipe> {
        public GemSocketRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)json.get("ingredient"));
            return new GemSocketRecipe(recipeId, ingredient);
        }

        @Nullable
        public GemSocketRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            return new GemSocketRecipe(recipeId, ingredient);
        }

        public void toNetwork(FriendlyByteBuf buffer, GemSocketRecipe recipe) {
            recipe.ingredient.m_43923_(buffer);
        }
    }
}

