/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.recipe.AlchemyRecipeBase;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class AlchemyRecipeForBabies
extends AlchemyRecipeBase {
    public static final Serializer SERIALIZER = new Serializer();
    public Long cachedSeed = null;
    public ArrayList<Ingredient> code = null;

    public AlchemyRecipeForBabies(ResourceLocation id, Ingredient tablet, ArrayList<Ingredient> aspects, ArrayList<Ingredient> inputs, ItemStack output, ItemStack failure) {
        super(id, tablet, aspects, inputs, output, failure);
    }

    @Override
    public ArrayList<Ingredient> getCode(long seed) {
        if (this.cachedSeed == null || this.cachedSeed != seed) {
            int incr = 0;
            boolean incorrectCode = true;
            while (incorrectCode) {
                this.code = super.getCode(seed + (long)incr);
                incorrectCode = false;
                for (Ingredient ingredient : this.aspects) {
                    if (this.code.contains(ingredient)) continue;
                    incorrectCode = true;
                    break;
                }
                ++incr;
            }
            this.cachedSeed = seed;
        }
        return this.code;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public static class Serializer
    implements RecipeSerializer<AlchemyRecipeForBabies> {
        public AlchemyRecipeForBabies fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient tablet = Ingredient.m_43917_((JsonElement)json.get("tablet"));
            ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
            JsonArray inputJson = GsonHelper.m_13832_((JsonObject)json, (String)"inputs", null);
            if (inputJson != null) {
                for (JsonElement element : inputJson) {
                    inputs.add(Ingredient.m_43917_((JsonElement)element));
                }
            }
            ArrayList<Ingredient> aspects = new ArrayList<Ingredient>();
            JsonArray aspectJson = GsonHelper.m_13832_((JsonObject)json, (String)"aspects", null);
            if (aspectJson != null) {
                for (JsonElement element : aspectJson) {
                    aspects.add(Ingredient.m_43917_((JsonElement)element));
                }
            }
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            ItemStack failure = json.has("failure") ? ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"failure")) : new ItemStack((ItemLike)RegistryManager.ALCHEMICAL_WASTE.get());
            return new AlchemyRecipeForBabies(recipeId, tablet, aspects, inputs, output, failure);
        }

        @Nullable
        public AlchemyRecipeForBabies fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient tablet = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ArrayList aspects = (ArrayList)buffer.m_236838_(i -> new ArrayList(), buf -> Ingredient.m_43940_((FriendlyByteBuf)buf));
            ArrayList inputs = (ArrayList)buffer.m_236838_(i -> new ArrayList(), buf -> Ingredient.m_43940_((FriendlyByteBuf)buf));
            ItemStack output = buffer.m_130267_();
            ItemStack failure = buffer.m_130267_();
            return new AlchemyRecipeForBabies(recipeId, tablet, aspects, inputs, output, failure);
        }

        public void toNetwork(FriendlyByteBuf buffer, AlchemyRecipeForBabies recipe) {
            recipe.tablet.m_43923_(buffer);
            buffer.m_236828_((Collection)recipe.aspects, (buf, input) -> input.m_43923_(buf));
            buffer.m_236828_((Collection)recipe.inputs, (buf, input) -> input.m_43923_(buf));
            buffer.writeItemStack(recipe.output, false);
            buffer.writeItemStack(recipe.failure, false);
        }
    }
}

