/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.EmbersAPI;
import com.rekindled.embers.util.EmbersColors;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class GlowParticleOptions
implements ParticleOptions {
    public static final float MIN_SCALE = 0.01f;
    public static final float MAX_SCALE = 4.0f;
    protected final ResourceLocation colorId;
    protected final Vector3f color;
    protected final Vec3 motion;
    protected final float scale;
    protected final int lifetime;
    @Deprecated
    public static Vector3f EMBER_COLOR = EmbersColors.EMBER;
    public static GlowParticleOptions EMBER = new GlowParticleOptions(EmbersColors.EMBER_ID, 2.0f);
    public static GlowParticleOptions EMBER_NOMOTION = new GlowParticleOptions(EmbersColors.EMBER_ID, new Vec3(0.0, 1.0E-6, 0.0), 2.0f);
    public static final Codec<GlowParticleOptions> CODEC = RecordCodecBuilder.create(p_175793_ -> p_175793_.group((App)ResourceLocation.f_135803_.fieldOf("color_id").forGetter(p_175797_ -> p_175797_.colorId), (App)ExtraCodecs.f_252432_.fieldOf("color").forGetter(p_175797_ -> p_175797_.color), (App)Vec3.f_231074_.fieldOf("motion").forGetter(p_175797_ -> p_175797_.motion), (App)Codec.FLOAT.fieldOf("scale").forGetter(p_175795_ -> Float.valueOf(p_175795_.scale)), (App)Codec.INT.fieldOf("lifetime").forGetter(p_175795_ -> p_175795_.lifetime)).apply((Applicative)p_175793_, GlowParticleOptions::new));
    public static final ParticleOptions.Deserializer<GlowParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<GlowParticleOptions>(){

        public GlowParticleOptions fromCommand(ParticleType<GlowParticleOptions> p_123689_, StringReader p_123690_) throws CommandSyntaxException {
            Vector3f vector3fColor = GlowParticleOptions.readVector3f(p_123690_);
            p_123690_.expect(' ');
            Vec3 vec3Motion = GlowParticleOptions.readVec3(p_123690_);
            p_123690_.expect(' ');
            float f = p_123690_.readFloat();
            int s = p_123690_.readInt();
            return new GlowParticleOptions(vector3fColor, vec3Motion, f, s);
        }

        public GlowParticleOptions fromNetwork(ParticleType<GlowParticleOptions> p_123692_, FriendlyByteBuf p_123693_) {
            return new GlowParticleOptions(p_123693_.m_130281_(), GlowParticleOptions.readVector3f(p_123693_), GlowParticleOptions.readVec3(p_123693_), p_123693_.readFloat(), p_123693_.readInt());
        }
    };

    public GlowParticleOptions(ResourceLocation pColorId, Vector3f pColor, Vec3 pMotion, float pScale, int plifetime) {
        this.colorId = pColorId;
        this.color = pColor;
        this.motion = pMotion;
        this.scale = pScale;
        this.lifetime = plifetime;
    }

    public GlowParticleOptions(Vector3f pColor, Vec3 pMotion, float pScale, int plifetime) {
        this(EmbersColors.CUSTOM_ID, pColor, pMotion, pScale, plifetime);
    }

    public GlowParticleOptions(ResourceLocation pColorId, Vec3 pMotion, float pScale, int plifetime) {
        this(pColorId, EmbersColors.EMBER, pMotion, pScale, plifetime);
    }

    public GlowParticleOptions(Vector3f pColor, Vec3 pMotion, float pScale) {
        this(pColor, pMotion, pScale, -1);
    }

    public GlowParticleOptions(Vector3f pColor, float pScale, int plifetime) {
        this(pColor, Vec3.f_82478_, pScale, plifetime);
    }

    public GlowParticleOptions(Vector3f pColor, float pScale) {
        this(pColor, Vec3.f_82478_, pScale);
    }

    public GlowParticleOptions(ResourceLocation pColorId, Vec3 pMotion, float pScale) {
        this(pColorId, pMotion, pScale, -1);
    }

    public GlowParticleOptions(ResourceLocation pColorId, float pScale, int plifetime) {
        this(pColorId, Vec3.f_82478_, pScale, plifetime);
    }

    public GlowParticleOptions(ResourceLocation pColorId, float pScale) {
        this(pColorId, Vec3.f_82478_, pScale);
    }

    public static Vector3f readVector3f(StringReader pStringInput) throws CommandSyntaxException {
        pStringInput.expect(' ');
        float f = pStringInput.readFloat();
        pStringInput.expect(' ');
        float f1 = pStringInput.readFloat();
        pStringInput.expect(' ');
        float f2 = pStringInput.readFloat();
        return new Vector3f(f, f1, f2);
    }

    public static Vec3 readVec3(StringReader pStringInput) throws CommandSyntaxException {
        pStringInput.expect(' ');
        double f = pStringInput.readDouble();
        pStringInput.expect(' ');
        double f1 = pStringInput.readDouble();
        pStringInput.expect(' ');
        double f2 = pStringInput.readDouble();
        return new Vec3(f, f1, f2);
    }

    public static Vector3f readVector3f(FriendlyByteBuf pBuffer) {
        return new Vector3f(pBuffer.readFloat(), pBuffer.readFloat(), pBuffer.readFloat());
    }

    public static Vec3 readVec3(FriendlyByteBuf pBuffer) {
        return new Vec3(pBuffer.readDouble(), pBuffer.readDouble(), pBuffer.readDouble());
    }

    public void m_7711_(FriendlyByteBuf pBuffer) {
        pBuffer.m_130085_(this.colorId);
        pBuffer.writeFloat(this.color.x());
        pBuffer.writeFloat(this.color.y());
        pBuffer.writeFloat(this.color.z());
        pBuffer.writeDouble(this.motion.m_7096_());
        pBuffer.writeDouble(this.motion.m_7098_());
        pBuffer.writeDouble(this.motion.m_7094_());
        pBuffer.writeFloat(this.scale);
        pBuffer.writeInt(this.lifetime);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f %.2f %.2f %.2f", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), Float.valueOf(this.color.x()), Float.valueOf(this.color.y()), Float.valueOf(this.color.z()), this.motion.m_7096_(), this.motion.m_7098_(), this.motion.m_7094_(), Float.valueOf(this.scale));
    }

    public Vector3f getColor() {
        return EmbersAPI.getColor(this.colorId, this.color);
    }

    public Vec3 getMotion() {
        return this.motion;
    }

    public float getScale() {
        return this.scale;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public ParticleType<?> m_6012_() {
        return (ParticleType)RegistryManager.GLOW_PARTICLE.get();
    }
}

