/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.rekindled.embers.blockentity.StampBaseBlockEntity;
import com.rekindled.embers.render.FluidCuboid;
import com.rekindled.embers.render.FluidRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.joml.Vector3f;

public class StampBaseBlockEntityRenderer
implements BlockEntityRenderer<StampBaseBlockEntity> {
    private final ItemRenderer itemRenderer;
    FluidCuboid cube = new FluidCuboid(new Vector3f(4.0f, 12.0f, 4.0f), new Vector3f(12.0f, 15.0f, 12.0f), FluidCuboid.DEFAULT_FACES);

    public StampBaseBlockEntityRenderer(BlockEntityRendererProvider.Context pContext) {
        this.itemRenderer = pContext.m_234447_();
    }

    public void render(StampBaseBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (blockEntity != null) {
            if (!blockEntity.inventory.getStackInSlot(0).m_41619_()) {
                poseStack.m_85836_();
                ItemStack stack = blockEntity.inventory.getStackInSlot(0);
                int seed = stack.m_41619_() ? 187 : Item.m_41393_((Item)stack.m_41720_()) + stack.m_41773_();
                BakedModel bakedmodel = this.itemRenderer.m_174264_(stack, blockEntity.m_58904_(), null, seed);
                float f2 = bakedmodel.m_7442_().m_269404_((ItemDisplayContext)ItemDisplayContext.GROUND).f_111757_.y();
                poseStack.m_85837_(0.5, (double)(0.25f * f2) + 0.75, 0.5);
                this.itemRenderer.m_115143_(stack, ItemDisplayContext.GROUND, false, poseStack, bufferSource, packedLight, OverlayTexture.f_118083_, bakedmodel);
                poseStack.m_85849_();
            }
            FluidStack fluidStack = blockEntity.getFluidStack();
            int capacity = blockEntity.getCapacity();
            if (!fluidStack.isEmpty() && capacity > 0) {
                float offset = blockEntity.renderOffset;
                if (offset > 1.2f || offset < -1.2f) {
                    offset -= (offset / 12.0f + 0.1f) * partialTick;
                    blockEntity.renderOffset = offset;
                } else {
                    blockEntity.renderOffset = 0.0f;
                }
                FluidRenderer.renderScaledCuboid(poseStack, bufferSource, this.cube, fluidStack, offset, capacity, packedLight, packedOverlay, false);
            } else {
                blockEntity.renderOffset = 0.0f;
            }
        }
    }
}

