/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity;

import com.google.common.collect.Lists;
import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.capabilities.EmbersCapabilities;
import com.rekindled.embers.api.event.DialInformationEvent;
import com.rekindled.embers.api.event.EmberEvent;
import com.rekindled.embers.api.event.MachineRecipeEvent;
import com.rekindled.embers.api.power.IEmberCapability;
import com.rekindled.embers.api.tile.IBin;
import com.rekindled.embers.api.tile.IExtraCapabilityInformation;
import com.rekindled.embers.api.tile.IExtraDialInformation;
import com.rekindled.embers.api.tile.IMechanicallyPowered;
import com.rekindled.embers.api.tile.IUpgradeable;
import com.rekindled.embers.api.upgrades.UpgradeContext;
import com.rekindled.embers.api.upgrades.UpgradeUtil;
import com.rekindled.embers.blockentity.StampBaseBlockEntity;
import com.rekindled.embers.datagen.EmbersSounds;
import com.rekindled.embers.particle.SmokeParticleOptions;
import com.rekindled.embers.particle.SparkParticleOptions;
import com.rekindled.embers.power.DefaultEmberCapability;
import com.rekindled.embers.recipe.IStampingRecipe;
import com.rekindled.embers.recipe.StampingContext;
import com.rekindled.embers.util.EmbersColors;
import com.rekindled.embers.util.Misc;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class StamperBlockEntity
extends BlockEntity
implements IMechanicallyPowered,
IExtraDialInformation,
IExtraCapabilityInformation,
IUpgradeable {
    public static final double EMBER_COST = 80.0;
    public static final int STAMP_TIME = 70;
    public static final int RETRACT_TIME = 10;
    public IEmberCapability capability = new DefaultEmberCapability(){

        @Override
        public void onContentsChanged() {
            super.onContentsChanged();
            StamperBlockEntity.this.m_6596_();
        }
    };
    public boolean prevPowered = false;
    public boolean powered = false;
    public long ticksExisted = 0L;
    Random random = new Random();
    public ItemStackHandler stamp = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            StamperBlockEntity.this.m_6596_();
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    public LazyOptional<IItemHandler> holder = LazyOptional.of(() -> this.stamp);
    protected List<UpgradeContext> upgrades = new ArrayList<UpgradeContext>();
    public IStampingRecipe cachedRecipe = null;

    public StamperBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)RegistryManager.STAMPER_ENTITY.get(), pPos, pBlockState);
        this.capability.setEmberCapacity(8000.0);
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_.m_7918_(0, -1, 0), this.f_58858_.m_7918_(1, 1, 1));
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.capability.deserializeNBT((Tag)nbt);
        this.powered = nbt.m_128471_("powered");
        this.stamp.deserializeNBT(nbt.m_128469_("stamp"));
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        this.capability.writeToNBT(nbt);
        nbt.m_128379_("powered", this.powered);
        nbt.m_128365_("stamp", (Tag)this.stamp.serializeNBT());
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128379_("powered", this.powered);
        nbt.m_128365_("stamp", (Tag)this.stamp.serializeNBT());
        return nbt;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, StamperBlockEntity blockEntity) {
        blockEntity.prevPowered = blockEntity.powered;
        if (level.m_8055_(pos.m_6625_(2)).m_60734_() == RegistryManager.STAMP_BASE.get()) {
            blockEntity.upgrades = UpgradeUtil.getUpgrades(level, pos, Misc.horizontals);
            UpgradeUtil.verifyUpgrades(blockEntity, blockEntity.upgrades);
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, StamperBlockEntity blockEntity) {
        ++blockEntity.ticksExisted;
        blockEntity.prevPowered = blockEntity.powered;
        if (level.m_8055_(pos.m_6625_(2)).m_60734_() == RegistryManager.STAMP_BASE.get()) {
            blockEntity.upgrades = UpgradeUtil.getUpgrades(level, pos, Misc.horizontals);
            UpgradeUtil.verifyUpgrades(blockEntity, blockEntity.upgrades);
            if (UpgradeUtil.doTick(blockEntity, blockEntity.upgrades)) {
                return;
            }
            StampBaseBlockEntity stamp = (StampBaseBlockEntity)level.m_7702_(pos.m_6625_(2));
            FluidTank handler = stamp.getTank();
            StampingContext context = new StampingContext((IItemHandlerModifiable)stamp.inventory, (IFluidHandler)handler, blockEntity.stamp.getStackInSlot(0));
            blockEntity.cachedRecipe = Misc.getRecipe(blockEntity.cachedRecipe, (RecipeType)RegistryManager.STAMPING.get(), context, level);
            if (blockEntity.cachedRecipe != null || blockEntity.powered) {
                boolean cancel = UpgradeUtil.doWork(blockEntity, blockEntity.upgrades);
                int stampTime = UpgradeUtil.getWorkTime(blockEntity, 70, blockEntity.upgrades);
                int retractTime = UpgradeUtil.getWorkTime(blockEntity, 10, blockEntity.upgrades);
                if (!cancel && !blockEntity.powered && blockEntity.ticksExisted >= (long)stampTime) {
                    double emberCost = UpgradeUtil.getTotalEmberConsumption(blockEntity, 80.0, blockEntity.upgrades);
                    if (blockEntity.capability.getEmber() >= emberCost) {
                        ArrayList results = Lists.newArrayList((Object[])new ItemStack[]{blockEntity.cachedRecipe.getOutput(context).m_41777_()});
                        UpgradeUtil.transformOutput((BlockEntity)blockEntity, results, blockEntity.upgrades);
                        BlockEntity outputTile = level.m_7702_(pos.m_6625_(3));
                        if (outputTile instanceof IBin) {
                            for (ItemStack remainder : results) {
                                remainder = ((IBin)outputTile).getInventory().insertItem(0, remainder, true);
                                if (remainder.m_41619_()) continue;
                                return;
                            }
                        }
                        UpgradeUtil.throwEvent(blockEntity, new EmberEvent(blockEntity, EmberEvent.EnumType.CONSUME, emberCost), blockEntity.upgrades);
                        blockEntity.capability.removeAmount(emberCost, true);
                        if (level instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level;
                            serverLevel.m_8767_((ParticleOptions)new SparkParticleOptions(EmbersColors.EMBER_ID, 1.0f), (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() - 1.1f), (double)((float)pos.m_123343_() + 0.5f), 10, 0.25, 0.0, 0.25, 1.0);
                            serverLevel.m_8767_((ParticleOptions)new SmokeParticleOptions(EmbersColors.SMOKE_ID, 3.0f), (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() - 1.1f), (double)((float)pos.m_123343_() + 0.5f), 10, 0.25, 0.0, 0.25, 1.0);
                        }
                        level.m_5594_(null, pos.m_7495_(), (SoundEvent)EmbersSounds.STAMPER_DOWN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                        blockEntity.powered = true;
                        blockEntity.ticksExisted = 0L;
                        UpgradeUtil.throwEvent(blockEntity, new MachineRecipeEvent.Success<IStampingRecipe>(blockEntity, blockEntity.cachedRecipe), blockEntity.upgrades);
                        blockEntity.cachedRecipe.m_5874_((Container)context, level.m_9598_());
                        BlockPos middlePos = pos.m_7495_();
                        for (ItemStack remainder : results) {
                            if (outputTile instanceof IBin) {
                                ((IBin)outputTile).getInventory().insertItem(0, remainder, false);
                                continue;
                            }
                            level.m_7967_((Entity)new ItemEntity(level, (double)middlePos.m_123341_() + 0.5, (double)middlePos.m_123342_() + 0.5, (double)middlePos.m_123343_() + 0.5, remainder));
                        }
                        stamp.m_6596_();
                    }
                    blockEntity.m_6596_();
                } else if (!cancel && blockEntity.powered && blockEntity.ticksExisted >= (long)retractTime) {
                    blockEntity.retract();
                }
            }
        } else if (blockEntity.powered) {
            blockEntity.retract();
        }
    }

    private void retract() {
        this.f_58857_.m_5594_(null, this.f_58858_.m_7495_(), (SoundEvent)EmbersSounds.STAMPER_UP.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        this.powered = false;
        this.ticksExisted = 0L;
        this.m_6596_();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == EmbersCapabilities.EMBER_CAPABILITY) {
            return this.capability.getCapability(cap, side);
        }
        if (!this.f_58859_ && cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.holder.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.capability.invalidate();
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ instanceof ServerLevel) {
            ((ServerLevel)this.f_58857_).m_7726_().m_8450_(this.f_58858_);
        }
    }

    @Override
    public double getMechanicalSpeed(double power) {
        return Misc.getDiminishedPower(power, 20.0, 0.075);
    }

    @Override
    public double getNominalSpeed() {
        return 1.0;
    }

    @Override
    public double getMinimumPower() {
        return 10.0;
    }

    @Override
    public void addDialInformation(Direction facing, List<Component> information, String dialType) {
        UpgradeUtil.throwEvent(this, new DialInformationEvent(this, information, dialType), this.upgrades);
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        return capability == ForgeCapabilities.ITEM_HANDLER;
    }

    @Override
    public void addCapabilityDescription(List<Component> strings, Capability<?> capability, Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.BOTH, "embers.tooltip.goggles.item", (Component)Component.m_237115_((String)"embers.tooltip.goggles.item.stamp")));
        }
    }

    @Override
    public boolean isSideUpgradeSlot(Direction face) {
        return face.m_122434_() != Direction.Axis.Y;
    }
}

