/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity;

import com.rekindled.embers.RegistryManager;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class ItemVacuumBlockEntity
extends BlockEntity {
    public ItemStackHandler inventory = new ItemStackHandler(1){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return false;
        }
    };
    public LazyOptional<IItemHandler> holder = LazyOptional.of(() -> this.inventory);

    public ItemVacuumBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)RegistryManager.ITEM_VACUUM_ENTITY.get(), pPos, pBlockState);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ItemVacuumBlockEntity blockEntity) {
        IItemHandler inventory;
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        BlockEntity tile = level.m_7702_(pos.m_121945_(facing.m_122424_()));
        if (level.m_276867_(pos) && tile != null && (inventory = (IItemHandler)tile.getCapability(ForgeCapabilities.ITEM_HANDLER, facing).orElse(null)) != null) {
            List nearestItems;
            Vec3i vec = facing.m_122436_();
            AABB suckBB = new AABB((double)(pos.m_123341_() - 6 + vec.m_123341_() * 7), (double)(pos.m_123342_() - 6 + vec.m_123342_() * 7), (double)(pos.m_123343_() - 6 + vec.m_123343_() * 7), (double)(pos.m_123341_() + 7 + vec.m_123341_() * 7), (double)(pos.m_123342_() + 7 + vec.m_123342_() * 7), (double)(pos.m_123343_() + 7 + vec.m_123343_() * 7));
            List items = level.m_6443_(ItemEntity.class, suckBB, entity -> ItemVacuumBlockEntity.getInsertedSlot(entity.m_32055_(), inventory) != -1);
            if (items.size() > 0) {
                for (ItemEntity item : items) {
                    Vec3 v = new Vec3(item.m_20185_() - ((double)pos.m_123341_() + 0.5), item.m_20186_() - ((double)pos.m_123342_() + 0.5), item.m_20189_() - ((double)pos.m_123343_() + 0.5));
                    double factor = 1.0 / v.m_82553_();
                    double speed = factor * 0.4 + 0.06;
                    v = v.m_82541_().m_82542_(speed, speed, speed);
                    item.m_20334_(-v.f_82479_ + item.m_20184_().f_82479_ / (factor += 1.0), -v.f_82480_ + item.m_20184_().f_82480_ / factor, -v.f_82481_ + item.m_20184_().f_82481_ / factor);
                }
            }
            if (!level.f_46443_ && (nearestItems = level.m_45976_(ItemEntity.class, new AABB((double)pos.m_123341_() + 0.24 + (double)vec.m_123341_() * 0.25, (double)pos.m_123342_() + 0.24 + (double)vec.m_123342_() * 0.25, (double)pos.m_123343_() + 0.24 + (double)vec.m_123343_() * 0.25, (double)pos.m_123341_() + 0.76 + (double)vec.m_123341_() * 0.25, (double)pos.m_123342_() + 0.76 + (double)vec.m_123342_() * 0.25, (double)pos.m_123343_() + 0.76 + (double)vec.m_123343_() * 0.25))).size() > 0) {
                for (ItemEntity item : nearestItems) {
                    int slot;
                    if (item.m_213877_() || (slot = ItemVacuumBlockEntity.getInsertedSlot(item.m_32055_(), inventory)) == -1) continue;
                    item.m_32045_(inventory.insertItem(slot, item.m_32055_(), false));
                    if (!item.m_32055_().m_41619_()) continue;
                    item.m_146870_();
                }
            }
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        Direction facing = (Direction)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)BlockStateProperties.f_61372_);
        if (!this.f_58859_ && cap == ForgeCapabilities.ITEM_HANDLER && side == facing.m_122424_()) {
            return ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, this.holder);
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.holder.invalidate();
    }

    static int getInsertedSlot(ItemStack stack, IItemHandler inventory) {
        int slot = -1;
        for (int j = 0; j < inventory.getSlots() && slot == -1; ++j) {
            ItemStack added;
            if (!inventory.isItemValid(j, stack) || (added = inventory.insertItem(j, stack, true)).m_41613_() >= stack.m_41613_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)added)) continue;
            slot = j;
        }
        return slot;
    }
}

