/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.filter.FilterAny;
import com.rekindled.embers.api.filter.IFilter;
import com.rekindled.embers.api.tile.IOrderDestination;
import com.rekindled.embers.api.tile.IOrderSource;
import com.rekindled.embers.api.tile.OrderStack;
import com.rekindled.embers.blockentity.ItemPipeBlockEntityBase;
import com.rekindled.embers.particle.VaporParticleOptions;
import com.rekindled.embers.util.EmbersColors;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class ItemExtractorBlockEntity
extends ItemPipeBlockEntityBase
implements IOrderDestination {
    Random random = new Random();
    IItemHandler[] sideHandlers;
    boolean active;
    List<OrderStack> orders = new ArrayList<OrderStack>();
    public static IFilter FILTER_ANY = new FilterAny();

    public ItemExtractorBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)RegistryManager.ITEM_EXTRACTOR_ENTITY.get(), pPos, pBlockState);
    }

    @Override
    protected void initInventory() {
        super.initInventory();
        this.sideHandlers = new IItemHandler[Direction.values().length];
        for (final Direction facing : Direction.values()) {
            this.sideHandlers[facing.m_122411_()] = new IItemHandler(){

                public int getSlots() {
                    return ItemExtractorBlockEntity.this.inventory.getSlots();
                }

                @Nonnull
                public ItemStack getStackInSlot(int slot) {
                    return ItemExtractorBlockEntity.this.inventory.getStackInSlot(slot);
                }

                @Nonnull
                public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                    if (ItemExtractorBlockEntity.this.active) {
                        return stack;
                    }
                    if (!simulate) {
                        ItemExtractorBlockEntity.this.setFrom(facing, true);
                    }
                    return ItemExtractorBlockEntity.this.inventory.insertItem(slot, stack, simulate);
                }

                @Nonnull
                public ItemStack extractItem(int slot, int amount, boolean simulate) {
                    return ItemExtractorBlockEntity.this.inventory.extractItem(slot, amount, simulate);
                }

                public int getSlotLimit(int slot) {
                    return ItemExtractorBlockEntity.this.inventory.getSlotLimit(slot);
                }

                public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                    return true;
                }
            };
        }
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("orders")) {
            ListTag tagOrders = nbt.m_128437_("orders", 10);
            this.orders.clear();
            for (Tag tagOrder : tagOrders) {
                this.orders.add(new OrderStack((CompoundTag)tagOrder));
            }
        }
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        ListTag tagOrders = new ListTag();
        for (OrderStack order : this.orders) {
            tagOrders.add((Object)order.writeToNBT(new CompoundTag()));
        }
        nbt.m_128365_("orders", (Tag)tagOrders);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ItemExtractorBlockEntity blockEntity) {
        IOrderSource destination;
        if (level instanceof ServerLevel && blockEntity.clogged && blockEntity.isAnySideUnclogged()) {
            Random posRand = new Random(pos.m_121878_());
            double angleA = posRand.nextDouble() * Math.PI * 2.0;
            double angleB = posRand.nextDouble() * Math.PI * 2.0;
            float xOffset = (float)(Math.cos(angleA) * Math.cos(angleB));
            float yOffset = (float)(Math.sin(angleA) * Math.cos(angleB));
            float zOffset = (float)Math.sin(angleB);
            float speed = 0.1f;
            float vx = xOffset * speed + posRand.nextFloat() * speed * 0.3f;
            float vy = yOffset * speed + posRand.nextFloat() * speed * 0.3f;
            float vz = zOffset * speed + posRand.nextFloat() * speed * 0.3f;
            ((ServerLevel)level).m_8767_((ParticleOptions)new VaporParticleOptions(EmbersColors.VAPOR_ID, new Vec3((double)vx, (double)vy, (double)vz), 1.0f), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 4, 0.0, 0.0, 0.0, 1.0);
        }
        blockEntity.cleanupOrders();
        blockEntity.active = level.m_276867_(pos);
        OrderStack currentOrder = blockEntity.orders.isEmpty() ? null : blockEntity.orders.get(0);
        IFilter filter = FILTER_ANY;
        if (blockEntity.active) {
            currentOrder = null;
        } else if (currentOrder != null) {
            filter = currentOrder.getFilter();
        }
        IItemHandler invDest = null;
        if (currentOrder != null && (destination = currentOrder.getSource(level)) != null) {
            invDest = destination.getItemHandler();
        }
        for (Direction facing : Direction.values()) {
            BlockEntity tile;
            if (!blockEntity.getConnection((Direction)facing).transfer || (tile = level.m_7702_(pos.m_121945_(facing))) == null || tile instanceof ItemPipeBlockEntityBase) continue;
            IItemHandler handler = (IItemHandler)tile.getCapability(ForgeCapabilities.ITEM_HANDLER, facing.m_122424_()).orElse(null);
            if (handler != null && (blockEntity.active || currentOrder != null && currentOrder.getSize() > 0)) {
                ItemStack extracted;
                int slot = -1;
                for (int j = 0; j < handler.getSlots() && slot == -1; ++j) {
                    ItemStack extracted2 = handler.extractItem(j, 1, true);
                    if (extracted2.m_41619_() || !filter.acceptsItem(extracted2, invDest)) continue;
                    slot = j;
                }
                if (slot != -1 && blockEntity.inventory.insertItem(0, extracted = handler.extractItem(slot, 1, true), true).m_41619_()) {
                    handler.extractItem(slot, 1, false);
                    blockEntity.inventory.insertItem(0, extracted, false);
                    if (currentOrder != null) {
                        currentOrder.deplete(extracted.m_41613_());
                    }
                }
                blockEntity.setFrom(facing, true);
                continue;
            }
            blockEntity.setFrom(facing, false);
        }
        ItemPipeBlockEntityBase.serverTick(level, pos, state, blockEntity);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, this.holder);
            }
            if (this.getConnection((Direction)side).transfer) {
                return ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, LazyOptional.of(() -> this.sideHandlers[side.m_122411_()]));
            }
        }
        return super.getCapability(cap, side);
    }

    @Override
    public int getCapacity() {
        return 4;
    }

    @Override
    public void order(BlockEntity source, IFilter filter, int orderSize) {
        OrderStack order = this.getOrder(source);
        if (order == null) {
            this.orders.add(new OrderStack(source.m_58899_(), filter, orderSize));
        } else if (Objects.equals(order.getFilter(), filter)) {
            order.increment(orderSize);
        } else {
            order.reset(filter, orderSize);
        }
    }

    @Override
    public void resetOrder(BlockEntity source) {
        this.orders.removeIf(order -> order.getPos().equals((Object)source.m_58899_()));
    }

    public OrderStack getOrder(BlockEntity source) {
        for (OrderStack order : this.orders) {
            if (!order.getPos().equals((Object)source.m_58899_())) continue;
            return order;
        }
        return null;
    }

    private void cleanupOrders() {
        this.orders.removeIf(this::isOrderInvalid);
    }

    private boolean isOrderInvalid(OrderStack order) {
        return order.getSize() <= 0 || order.getSource(this.f_58857_) == null;
    }
}

