/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.blockentity.FluidPipeBlockEntityBase;
import com.rekindled.embers.blockentity.PipeBlockEntityBase;
import com.rekindled.embers.particle.VaporParticleOptions;
import com.rekindled.embers.util.EmbersColors;
import com.rekindled.embers.util.Misc;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class FluidTransferBlockEntity
extends FluidPipeBlockEntityBase {
    public static final int PRIORITY_TRANSFER = -10;
    public FluidStack filterFluid = FluidStack.EMPTY;
    Random random = new Random();
    public boolean syncFilter = true;
    IFluidHandler outputSide;
    public LazyOptional<IFluidHandler> outputHolder = LazyOptional.of(() -> this.outputSide);

    public FluidTransferBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)RegistryManager.FLUID_TRANSFER_ENTITY.get(), pPos, pBlockState);
        this.syncConnections = false;
        this.saveConnections = false;
    }

    @Override
    protected void initFluidTank() {
        this.tank = new FluidTank(this.getCapacity()){

            protected void onContentsChanged() {
                FluidTransferBlockEntity.this.m_6596_();
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                if (!FluidTransferBlockEntity.this.filterFluid.isEmpty()) {
                    if (resource != null && (FluidTransferBlockEntity.this.filterFluid.getTag() != null ? resource.isFluidEqual(FluidTransferBlockEntity.this.filterFluid) : resource.getFluid() == FluidTransferBlockEntity.this.filterFluid.getFluid())) {
                        return super.fill(resource, action);
                    }
                    return 0;
                }
                return super.fill(resource, action);
            }
        };
        this.outputSide = Misc.makeRestrictedFluidHandler((IFluidHandler)this.tank, false, true);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("filter")) {
            this.filterFluid = FluidStack.loadFluidStackFromNBT((CompoundTag)nbt.m_128469_("filter"));
        }
    }

    @Override
    protected boolean requiresSync() {
        return this.syncFilter || super.requiresSync();
    }

    @Override
    protected void resetSync() {
        super.resetSync();
        this.syncFilter = false;
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        this.writeFilter(nbt);
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        if (this.syncFilter) {
            this.writeFilter(nbt);
        }
        return nbt;
    }

    private void writeFilter(CompoundTag nbt) {
        nbt.m_128365_("filter", (Tag)this.filterFluid.writeToNBT(new CompoundTag()));
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, FluidTransferBlockEntity blockEntity) {
        if (level instanceof ServerLevel && blockEntity.clogged && blockEntity.isAnySideUnclogged()) {
            Random posRand = new Random(pos.m_121878_());
            double angleA = posRand.nextDouble() * Math.PI * 2.0;
            double angleB = posRand.nextDouble() * Math.PI * 2.0;
            float xOffset = (float)(Math.cos(angleA) * Math.cos(angleB));
            float yOffset = (float)(Math.sin(angleA) * Math.cos(angleB));
            float zOffset = (float)Math.sin(angleB);
            float speed = 0.1f;
            float vx = xOffset * speed + posRand.nextFloat() * speed * 0.3f;
            float vy = yOffset * speed + posRand.nextFloat() * speed * 0.3f;
            float vz = zOffset * speed + posRand.nextFloat() * speed * 0.3f;
            ((ServerLevel)level).m_8767_((ParticleOptions)new VaporParticleOptions(EmbersColors.VAPOR_ID, new Vec3((double)vx, (double)vy, (double)vz), 1.0f), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 4, 0.0, 0.0, 0.0, 1.0);
        }
        FluidPipeBlockEntityBase.serverTick(level, pos, state, blockEntity);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == ForgeCapabilities.FLUID_HANDLER) {
            if (side == null) {
                return ForgeCapabilities.FLUID_HANDLER.orEmpty(cap, this.holder);
            }
            if (this.f_58857_.m_8055_(this.m_58899_()).m_61138_((Property)BlockStateProperties.f_61372_)) {
                Direction facing = (Direction)this.f_58857_.m_8055_(this.m_58899_()).m_61143_((Property)BlockStateProperties.f_61372_);
                if (side.m_122424_() == facing) {
                    return ForgeCapabilities.FLUID_HANDLER.orEmpty(cap, this.outputHolder);
                }
                if (side.m_122434_() == facing.m_122434_()) {
                    return ForgeCapabilities.FLUID_HANDLER.orEmpty(cap, this.holder);
                }
            }
        }
        return LazyOptional.empty();
    }

    @Override
    public int getCapacity() {
        return 240;
    }

    @Override
    public int getPriority(Direction facing) {
        return -10;
    }

    @Override
    public PipeBlockEntityBase.PipeConnection getConnection(Direction facing) {
        BlockState state = this.f_58857_.m_8055_(this.m_58899_());
        return state.m_61138_((Property)BlockStateProperties.f_61372_) && ((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_() == facing.m_122434_() ? PipeBlockEntityBase.PipeConnection.PIPE : PipeBlockEntityBase.PipeConnection.NONE;
    }

    @Override
    protected boolean isFrom(Direction facing) {
        return this.f_58857_.m_8055_(this.m_58899_()).m_61143_((Property)BlockStateProperties.f_61372_) == facing;
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.outputHolder.invalidate();
    }
}

