/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.power.IEmberPacketProducer;
import com.rekindled.embers.api.power.IEmberPacketReceiver;
import com.rekindled.embers.datagen.EmbersSounds;
import com.rekindled.embers.entity.EmberPacketEntity;
import com.rekindled.embers.particle.StarParticleOptions;
import com.rekindled.embers.util.EmbersColors;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class EmberRelayBlockEntity
extends BlockEntity
implements IEmberPacketProducer,
IEmberPacketReceiver {
    public BlockPos target = null;
    public Random random = new Random();
    public boolean polled = false;

    public EmberRelayBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)RegistryManager.EMBER_RELAY_ENTITY.get(), pPos, pBlockState);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("targetX")) {
            this.target = new BlockPos(nbt.m_128451_("targetX"), nbt.m_128451_("targetY"), nbt.m_128451_("targetZ"));
        }
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        if (this.target != null) {
            nbt.m_128405_("targetX", this.target.m_123341_());
            nbt.m_128405_("targetY", this.target.m_123342_());
            nbt.m_128405_("targetZ", this.target.m_123343_());
        }
    }

    @Override
    public boolean hasRoomFor(double ember) {
        BlockEntity blockEntity;
        if (this.polled) {
            return this.target != null;
        }
        this.polled = true;
        if (this.target != null && this.f_58857_.m_46749_(this.target) && (blockEntity = this.f_58857_.m_7702_(this.target)) instanceof IEmberPacketReceiver) {
            IEmberPacketReceiver targetBE = (IEmberPacketReceiver)blockEntity;
            boolean hasRoom = targetBE.hasRoomFor(ember);
            this.polled = false;
            return hasRoom;
        }
        this.polled = false;
        return false;
    }

    @Override
    public boolean onReceive(EmberPacketEntity packet) {
        if (this.target != null && packet.pos != this.m_58899_()) {
            Level level = this.f_58857_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)new StarParticleOptions(EmbersColors.EMBER_ID, 3.5f + 0.5f * this.random.nextFloat()), (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5, 12, (double)(0.0125f * (this.random.nextFloat() - 0.5f)), (double)(0.0125f * (this.random.nextFloat() - 0.5f)), (double)(0.0125f * (this.random.nextFloat() - 0.5f)), 0.0);
            }
            packet.setLifetime(78);
            packet.dest = this.target;
            packet.pos = this.m_58899_();
            packet.m_20256_(packet.m_20184_().m_82490_(1.7));
            this.f_58857_.m_7785_(packet.m_20185_(), packet.m_20186_(), packet.m_20189_(), (SoundEvent)EmbersSounds.EMBER_RELAY.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
        return false;
    }

    @Override
    public void setTargetPosition(BlockPos pos, Direction side) {
        if (pos != this.f_58858_) {
            this.target = pos;
            this.m_6596_();
        }
    }

    @Override
    public Direction getEmittingDirection(Direction side) {
        return side;
    }
}

