/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.capabilities.EmbersCapabilities;
import com.rekindled.embers.api.power.IEmberCapability;
import com.rekindled.embers.api.power.IEmberPacketReceiver;
import com.rekindled.embers.datagen.EmbersSounds;
import com.rekindled.embers.entity.EmberPacketEntity;
import com.rekindled.embers.particle.SmokeParticleOptions;
import com.rekindled.embers.particle.SparkParticleOptions;
import com.rekindled.embers.particle.StarParticleOptions;
import com.rekindled.embers.power.DefaultEmberCapability;
import com.rekindled.embers.util.EmbersColors;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class EmberReceiverBlockEntity
extends BlockEntity
implements IEmberPacketReceiver {
    public IEmberCapability capability = new DefaultEmberCapability(){

        @Override
        public void onContentsChanged() {
            super.onContentsChanged();
            EmberReceiverBlockEntity.this.m_6596_();
        }

        @Override
        public boolean acceptsVolatile() {
            return false;
        }
    };
    public static final int TRANSFER_RATE = 10;
    public long ticksExisted = 0L;
    public Random random = new Random();

    public EmberReceiverBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)RegistryManager.EMBER_RECEIVER_ENTITY.get(), pPos, pBlockState);
        this.capability.setEmberCapacity(2000.0);
    }

    public EmberReceiverBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.capability.deserializeNBT((Tag)nbt);
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        this.capability.writeToNBT(nbt);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, EmberReceiverBlockEntity blockEntity) {
        IEmberCapability cap;
        ++blockEntity.ticksExisted;
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        BlockEntity attachedTile = level.m_7702_(pos.m_5484_(facing, -1));
        if (blockEntity.ticksExisted % 2L == 0L && attachedTile != null && (cap = (IEmberCapability)attachedTile.getCapability(EmbersCapabilities.EMBER_CAPABILITY, facing).orElse(null)) != null && cap.getEmber() < cap.getEmberCapacity() && blockEntity.capability.getEmber() > 0.0) {
            double added = cap.addAmount(Math.min(10.0, blockEntity.capability.getEmber()), true);
            blockEntity.capability.removeAmount(added, true);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == EmbersCapabilities.EMBER_CAPABILITY) {
            return this.capability.getCapability(cap, side);
        }
        return super.getCapability(cap, side);
    }

    @Override
    public boolean hasRoomFor(double ember) {
        return this.capability.getEmber() * 2.0 <= this.capability.getEmberCapacity();
    }

    @Override
    public boolean onReceive(EmberPacketEntity packet) {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.capability.getEmber() + packet.value > this.capability.getEmberCapacity()) {
                serverLevel.m_8767_((ParticleOptions)new SparkParticleOptions(EmbersColors.EMBER_ID, this.random.nextFloat() * 0.75f + 0.45f), (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5, 5, (double)(0.125f * (this.random.nextFloat() - 0.5f)), (double)(0.125f * this.random.nextFloat()), (double)(0.125f * (this.random.nextFloat() - 0.5f)), 1.0);
                serverLevel.m_8767_((ParticleOptions)new SmokeParticleOptions(EmbersColors.SMOKE_ID, 2.0f + this.random.nextFloat() * 2.0f), (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5, 15, (double)(0.0625f * (this.random.nextFloat() - 0.5f)), (double)(0.0625f + 0.0625f * (this.random.nextFloat() - 0.5f)), (double)(0.0625f * (this.random.nextFloat() - 0.5f)), 1.0);
            } else {
                serverLevel.m_8767_((ParticleOptions)new StarParticleOptions(EmbersColors.EMBER_ID, 3.5f + 0.5f * this.random.nextFloat()), (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5, 12, (double)(0.0125f * (this.random.nextFloat() - 0.5f)), (double)(0.0125f * (this.random.nextFloat() - 0.5f)), (double)(0.0125f * (this.random.nextFloat() - 0.5f)), 0.0);
            }
        }
        this.f_58857_.m_7785_(packet.m_20185_(), packet.m_20186_(), packet.m_20189_(), packet.value >= 100.0 ? (SoundEvent)EmbersSounds.EMBER_RECEIVE_BIG.get() : (SoundEvent)EmbersSounds.EMBER_RECEIVE.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
        return true;
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.capability.invalidate();
    }
}

