/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.tile.IExtraCapabilityInformation;
import com.rekindled.embers.recipe.CatalysisCombustionContext;
import com.rekindled.embers.recipe.ICatalysisCombustionRecipe;
import com.rekindled.embers.util.Misc;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class CombustionChamberBlockEntity
extends BlockEntity
implements IExtraCapabilityInformation {
    public static ItemStack machine = new ItemStack((ItemLike)RegistryManager.COMBUSTION_CHAMBER_ITEM.get());
    int progress = 0;
    double multiplier = 0.0;
    public ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            CombustionChamberBlockEntity.this.m_6596_();
        }
    };
    public LazyOptional<IItemHandler> holder = LazyOptional.of(() -> this.inventory);
    public ICatalysisCombustionRecipe cachedRecipe = null;

    public CombustionChamberBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)RegistryManager.COMBUSTION_CHAMBER_ENTITY.get(), pPos, pBlockState);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("inventory")) {
            this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
        }
        if (nbt.m_128441_("progress")) {
            this.progress = nbt.m_128451_("progress");
        }
        this.multiplier = nbt.m_128459_("multiplier");
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
        nbt.m_128405_("progress", this.progress);
        nbt.m_128347_("multiplier", this.multiplier);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128347_("multiplier", this.multiplier);
        return nbt;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, CombustionChamberBlockEntity blockEntity) {
        if (blockEntity.progress > 0) {
            --blockEntity.progress;
            if (blockEntity.progress == 0) {
                blockEntity.multiplier = 0.0;
                ((ServerLevel)level).m_7726_().m_8450_(pos);
            }
            blockEntity.m_6596_();
        }
        if (blockEntity.progress == 0 && !blockEntity.inventory.getStackInSlot(0).m_41619_()) {
            CatalysisCombustionContext wrapper = new CatalysisCombustionContext((IItemHandlerModifiable)blockEntity.inventory, machine);
            blockEntity.cachedRecipe = Misc.getRecipe(blockEntity.cachedRecipe, (RecipeType)RegistryManager.CATALYSIS_COMBUSTION.get(), wrapper, level);
            if (blockEntity.cachedRecipe != null) {
                blockEntity.multiplier = blockEntity.cachedRecipe.getmultiplier(wrapper);
                blockEntity.progress = blockEntity.cachedRecipe.getBurnTIme(wrapper);
                blockEntity.cachedRecipe.process(wrapper);
                ((ServerLevel)level).m_7726_().m_8450_(pos);
            }
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == ForgeCapabilities.ITEM_HANDLER) {
            return ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, this.holder);
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.holder.invalidate();
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ instanceof ServerLevel) {
            ((ServerLevel)this.f_58857_).m_7726_().m_8450_(this.f_58858_);
        }
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        return capability == ForgeCapabilities.ITEM_HANDLER;
    }

    @Override
    public void addCapabilityDescription(List<Component> strings, Capability<?> capability, Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.INPUT, "embers.tooltip.goggles.item", (Component)Component.m_237115_((String)"embers.tooltip.goggles.item.combustion")));
        }
    }
}

