/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity;

import com.google.common.collect.Lists;
import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.capabilities.EmbersCapabilities;
import com.rekindled.embers.api.event.DialInformationEvent;
import com.rekindled.embers.api.event.EmberEvent;
import com.rekindled.embers.api.power.IEmberCapability;
import com.rekindled.embers.api.tile.IBin;
import com.rekindled.embers.api.tile.IExtraCapabilityInformation;
import com.rekindled.embers.api.tile.IExtraDialInformation;
import com.rekindled.embers.api.tile.IUpgradeable;
import com.rekindled.embers.api.upgrades.UpgradeContext;
import com.rekindled.embers.api.upgrades.UpgradeUtil;
import com.rekindled.embers.datagen.EmbersItemTags;
import com.rekindled.embers.datagen.EmbersSounds;
import com.rekindled.embers.particle.SmokeParticleOptions;
import com.rekindled.embers.power.DefaultEmberCapability;
import com.rekindled.embers.util.EmbersColors;
import com.rekindled.embers.util.sound.ISoundController;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class CinderPlinthBlockEntity
extends BlockEntity
implements ISoundController,
IExtraDialInformation,
IExtraCapabilityInformation,
IUpgradeable {
    public static double EMBER_COST = 0.5;
    public static int PROCESS_TIME = 40;
    int progress = 0;
    public IEmberCapability capability = new DefaultEmberCapability(){

        @Override
        public void onContentsChanged() {
            super.onContentsChanged();
            CinderPlinthBlockEntity.this.m_6596_();
        }
    };
    public ItemStackHandler inventory = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return !stack.m_204117_(EmbersItemTags.CINDER_PLINTH_BLACKLIST);
        }

        protected void onContentsChanged(int slot) {
            CinderPlinthBlockEntity.this.m_6596_();
        }
    };
    public LazyOptional<IItemHandler> holder = LazyOptional.of(() -> this.inventory);
    static Random random = new Random();
    protected List<UpgradeContext> upgrades = new ArrayList<UpgradeContext>();
    public static final int SOUND_PROCESS = 1;
    public static final int[] SOUND_IDS = new int[]{1};
    HashSet<Integer> soundsPlaying = new HashSet();

    public CinderPlinthBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)RegistryManager.CINDER_PLINTH_ENTITY.get(), pPos, pBlockState);
        this.capability.setEmberCapacity(4000.0);
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_.m_7918_(0, 0, 0), this.f_58858_.m_7918_(1, 2, 1));
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.capability.deserializeNBT((Tag)nbt);
        if (nbt.m_128441_("progress")) {
            this.progress = nbt.m_128451_("progress");
        }
        this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        this.capability.writeToNBT(nbt);
        nbt.m_128405_("progress", this.progress);
        nbt.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.capability.writeToNBT(nbt);
        nbt.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
        return nbt;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, CinderPlinthBlockEntity blockEntity) {
        blockEntity.handleSound();
        blockEntity.upgrades = UpgradeUtil.getUpgrades(level, pos, Direction.values());
        UpgradeUtil.verifyUpgrades(blockEntity, blockEntity.upgrades);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, CinderPlinthBlockEntity blockEntity) {
        blockEntity.upgrades = UpgradeUtil.getUpgrades(level, pos, Direction.values());
        UpgradeUtil.verifyUpgrades(blockEntity, blockEntity.upgrades);
        if (UpgradeUtil.doTick(blockEntity, blockEntity.upgrades)) {
            return;
        }
        if (blockEntity.shouldWork()) {
            boolean cancel = UpgradeUtil.doWork(blockEntity, blockEntity.upgrades);
            if (!cancel) {
                ++blockEntity.progress;
                ((ServerLevel)level).m_8767_((ParticleOptions)new SmokeParticleOptions(EmbersColors.SMOKE_ID, 3.0f + random.nextFloat() * 0.4f), (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.875f), (double)((float)pos.m_123343_() + 0.5f), 1, 0.0125, 0.025, 0.0125, 1.0);
                double emberCost = UpgradeUtil.getTotalEmberConsumption(blockEntity, EMBER_COST, blockEntity.upgrades);
                UpgradeUtil.throwEvent(blockEntity, new EmberEvent(blockEntity, EmberEvent.EnumType.CONSUME, emberCost), blockEntity.upgrades);
                blockEntity.capability.removeAmount(emberCost, true);
                if (blockEntity.progress > UpgradeUtil.getWorkTime(blockEntity, PROCESS_TIME, blockEntity.upgrades)) {
                    blockEntity.progress = 0;
                    BlockEntity tile = level.m_7702_(pos.m_7495_());
                    ArrayList outputs = Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)RegistryManager.ASH.get(), 1)});
                    UpgradeUtil.transformOutput((BlockEntity)blockEntity, outputs, blockEntity.upgrades);
                    blockEntity.inventory.extractItem(0, 1, false);
                    for (ItemStack remainder : outputs) {
                        if (tile instanceof IBin) {
                            remainder = ((IBin)tile).getInventory().insertItem(0, remainder, false);
                        }
                        if (remainder.m_41619_()) continue;
                        level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, remainder));
                    }
                    ((ServerLevel)level).m_8767_((ParticleOptions)new SmokeParticleOptions(EmbersColors.SMOKE_ID, 3.0f), (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 1.1f), (double)((float)pos.m_123343_() + 0.5f), 9, 0.0125, 0.025, 0.0125, 1.0);
                }
            }
        } else if (blockEntity.progress != 0) {
            blockEntity.progress = 0;
            blockEntity.m_6596_();
        }
    }

    private boolean shouldWork() {
        return !this.inventory.getStackInSlot(0).m_41619_() && this.capability.getEmber() > 0.0;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_) {
            if (cap == EmbersCapabilities.EMBER_CAPABILITY) {
                return this.capability.getCapability(cap, side);
            }
            if (cap == ForgeCapabilities.ITEM_HANDLER) {
                return this.holder.cast();
            }
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.capability.invalidate();
        this.holder.invalidate();
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ instanceof ServerLevel) {
            ((ServerLevel)this.f_58857_).m_7726_().m_8450_(this.f_58858_);
        }
    }

    @Override
    public void playSound(int id) {
        switch (id) {
            case 1: {
                EmbersSounds.playMachineSound(this, 1, (SoundEvent)EmbersSounds.PLINTH_LOOP.get(), SoundSource.BLOCKS, true, 1.0f, 1.0f, (float)this.f_58858_.m_123341_() + 0.5f, (float)this.f_58858_.m_123342_() + 0.5f, (float)this.f_58858_.m_123343_() + 0.5f);
            }
        }
        this.soundsPlaying.add(id);
    }

    @Override
    public void stopSound(int id) {
        this.soundsPlaying.remove(id);
    }

    @Override
    public boolean isSoundPlaying(int id) {
        return this.soundsPlaying.contains(id);
    }

    @Override
    public int[] getSoundIDs() {
        return SOUND_IDS;
    }

    @Override
    public boolean shouldPlaySound(int id) {
        return id == 1 && this.shouldWork();
    }

    @Override
    public void addDialInformation(Direction facing, List<Component> information, String dialType) {
        UpgradeUtil.throwEvent(this, new DialInformationEvent(this, information, dialType), this.upgrades);
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        return capability == ForgeCapabilities.ITEM_HANDLER;
    }

    @Override
    public void addCapabilityDescription(List<Component> strings, Capability<?> capability, Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.INPUT, "embers.tooltip.goggles.item", null));
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.OUTPUT, "embers.tooltip.goggles.item", (Component)Component.m_237115_((String)"embers.tooltip.goggles.item.ash")));
        }
    }

    @Override
    public boolean isSideUpgradeSlot(Direction face) {
        return true;
    }
}

