/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.block;

import com.rekindled.embers.api.block.IPipeConnection;
import com.rekindled.embers.blockentity.PipeBlockEntityBase;
import com.rekindled.embers.datagen.EmbersItemTags;
import com.rekindled.embers.datagen.EmbersSounds;
import com.rekindled.embers.util.Misc;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;

public abstract class PipeBlockBase
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final VoxelShape CENTER_AABB = Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    public static final VoxelShape PIPE_DOWN_AABB = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);
    public static final VoxelShape END_DOWN_AABB = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)4.0, (double)11.0), (VoxelShape)PIPE_DOWN_AABB);
    public static final VoxelShape PIPE_UP_AABB = Block.m_49796_((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    public static final VoxelShape END_UP_AABB = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)12.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), (VoxelShape)PIPE_UP_AABB);
    public static final VoxelShape PIPE_NORTH_AABB = Block.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)6.0);
    public static final VoxelShape END_NORTH_AABB = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)4.0), (VoxelShape)PIPE_NORTH_AABB);
    public static final VoxelShape PIPE_SOUTH_AABB = Block.m_49796_((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)16.0);
    public static final VoxelShape END_SOUTH_AABB = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)5.0, (double)12.0, (double)11.0, (double)11.0, (double)16.0), (VoxelShape)PIPE_SOUTH_AABB);
    public static final VoxelShape PIPE_WEST_AABB = Block.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0);
    public static final VoxelShape END_WEST_AABB = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)5.0, (double)5.0, (double)4.0, (double)11.0, (double)11.0), (VoxelShape)PIPE_WEST_AABB);
    public static final VoxelShape PIPE_EAST_AABB = Block.m_49796_((double)10.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    public static final VoxelShape END_EAST_AABB = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)12.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0), (VoxelShape)PIPE_EAST_AABB);
    public static final VoxelShape[] PIPE_AABBS = new VoxelShape[]{PIPE_DOWN_AABB, PIPE_UP_AABB, PIPE_NORTH_AABB, PIPE_SOUTH_AABB, PIPE_WEST_AABB, PIPE_EAST_AABB};
    public static final VoxelShape[] END_AABBS = new VoxelShape[]{END_DOWN_AABB, END_UP_AABB, END_NORTH_AABB, END_SOUTH_AABB, END_WEST_AABB, END_EAST_AABB};
    public static final VoxelShape[] SHAPES = new VoxelShape[729];

    public abstract TagKey<Block> getConnectionTag();

    public abstract TagKey<Block> getToggleConnectionTag();

    public abstract boolean connectToTile(BlockEntity var1, Direction var2);

    public abstract boolean unclog(BlockEntity var1, Level var2, BlockPos var3);

    public PipeBlockBase(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!Misc.isHoldingHammer(player, hand)) {
            if (player.m_21120_(hand).m_204117_(EmbersItemTags.PIPE_UNCLOGGER) && this.unclog(level.m_7702_(pos), level, pos)) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        BlockEntity BE = level.m_7702_(pos);
        if (BE instanceof PipeBlockEntityBase) {
            PipeBlockEntityBase pipe = (PipeBlockEntityBase)BE;
            double reach = player.getBlockReach();
            Vec3 eyePosition = player.m_146892_();
            Vec3 lookVector = player.m_20154_().m_82542_(reach, reach, reach).m_82549_(eyePosition);
            Vec3[] hitPositions = new Vec3[6];
            BlockHitResult centerHit = this.getCenterShape().m_83220_(eyePosition, lookVector, pos);
            for (int i = 0; i < 6; ++i) {
                BlockHitResult partHit = null;
                if (pipe.connections[i] == PipeBlockEntityBase.PipeConnection.END) {
                    partHit = END_AABBS[i].m_83220_(eyePosition, lookVector, pos);
                } else if (pipe.connections[i] == PipeBlockEntityBase.PipeConnection.PIPE) {
                    partHit = PIPE_AABBS[i].m_83220_(eyePosition, lookVector, pos);
                }
                if (partHit == null) continue;
                hitPositions[i] = partHit.m_82450_();
            }
            int closestHit = -1;
            double closestDistance = reach;
            if (centerHit != null) {
                closestDistance = eyePosition.m_82554_(centerHit.m_82450_());
            }
            for (int i = 0; i < 6; ++i) {
                double dist;
                if (hitPositions[i] == null || !((dist = eyePosition.m_82554_(hitPositions[i])) < closestDistance)) continue;
                closestDistance = dist;
                closestHit = i;
            }
            if (closestHit == -1) {
                BlockEntity blockEntity;
                Direction face = hit.m_82434_();
                if (pipe.getConnection(face) != PipeBlockEntityBase.PipeConnection.DISABLED) {
                    return InteractionResult.PASS;
                }
                BlockPos facingPos = pos.m_121945_(face);
                BlockState facingState = level.m_8055_(facingPos);
                if (facingState.m_204336_(this.getToggleConnectionTag()) && (blockEntity = level.m_7702_(facingPos)) instanceof PipeBlockEntityBase) {
                    PipeBlockEntityBase facingPipe = (PipeBlockEntityBase)blockEntity;
                    pipe.setConnection(face, PipeBlockEntityBase.PipeConnection.PIPE);
                    facingPipe.setConnection(face.m_122424_(), PipeBlockEntityBase.PipeConnection.PIPE);
                    level.m_46717_(pos, (Block)this);
                    level.m_46717_(facingPos, (Block)this);
                    level.m_7785_((double)pos.m_123341_() + 0.5 + (double)face.m_122429_() * 0.5, (double)pos.m_123342_() + 0.5 + (double)face.m_122430_() * 0.5, (double)pos.m_123343_() + 0.5 + (double)face.m_122431_() * 0.5, (SoundEvent)EmbersSounds.PIPE_CONNECT.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
                    return InteractionResult.SUCCESS;
                }
                BlockEntity blockEntity2 = level.m_7702_(facingPos);
                if (this.connectToTile(blockEntity2, face)) {
                    if (facingState.m_60734_() instanceof IPipeConnection) {
                        pipe.setConnection(face, ((IPipeConnection)facingState.m_60734_()).getPipeConnection(facingState, face.m_122424_()));
                    } else {
                        pipe.setConnection(face, PipeBlockEntityBase.PipeConnection.END);
                    }
                    level.m_46717_(pos, (Block)this);
                    facingState.m_60728_(face.m_122424_(), state, (LevelAccessor)level, facingPos, pos);
                    level.m_7785_((double)pos.m_123341_() + 0.5 + (double)face.m_122429_() * 0.4, (double)pos.m_123342_() + 0.5 + (double)face.m_122430_() * 0.4, (double)pos.m_123343_() + 0.5 + (double)face.m_122431_() * 0.4, (SoundEvent)EmbersSounds.PIPE_CONNECT.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
                    return InteractionResult.SUCCESS;
                }
            } else {
                BlockEntity blockEntity;
                Direction direction = Direction.m_122376_((int)closestHit);
                if (!pipe.getConnection((Direction)direction).transfer) {
                    return InteractionResult.PASS;
                }
                BlockPos facingPos = pos.m_121945_(direction);
                BlockState facingState = level.m_8055_(facingPos);
                if (pipe.getConnection(direction) == PipeBlockEntityBase.PipeConnection.PIPE && facingState.m_204336_(this.getToggleConnectionTag()) && (blockEntity = level.m_7702_(facingPos)) instanceof PipeBlockEntityBase) {
                    PipeBlockEntityBase facingPipe = (PipeBlockEntityBase)blockEntity;
                    pipe.setConnection(direction, PipeBlockEntityBase.PipeConnection.DISABLED);
                    facingPipe.setConnection(direction.m_122424_(), PipeBlockEntityBase.PipeConnection.DISABLED);
                    level.m_46717_(pos, (Block)this);
                    level.m_46717_(facingPos, (Block)this);
                    level.m_7785_((double)pos.m_123341_() + 0.5 + (double)direction.m_122429_() * 0.5, (double)pos.m_123342_() + 0.5 + (double)direction.m_122430_() * 0.5, (double)pos.m_123343_() + 0.5 + (double)direction.m_122431_() * 0.5, (SoundEvent)EmbersSounds.PIPE_DISCONNECT.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
                    return InteractionResult.SUCCESS;
                }
                if (pipe.getConnection((Direction)direction).transfer && !facingState.m_204336_(this.getConnectionTag()) && !this.connected(direction, facingState)) {
                    pipe.setConnection(direction, PipeBlockEntityBase.PipeConnection.DISABLED);
                    level.m_46717_(pos, (Block)this);
                    facingState.m_60728_(direction.m_122424_(), state, (LevelAccessor)level, facingPos, pos);
                    level.m_7785_((double)pos.m_123341_() + 0.5 + (double)direction.m_122429_() * 0.4, (double)pos.m_123342_() + 0.5 + (double)direction.m_122430_() * 0.4, (double)pos.m_123343_() + 0.5 + (double)direction.m_122431_() * 0.4, (SoundEvent)EmbersSounds.PIPE_DISCONNECT.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    public static int getShapeIndex(PipeBlockEntityBase.PipeConnection down, PipeBlockEntityBase.PipeConnection up, PipeBlockEntityBase.PipeConnection north, PipeBlockEntityBase.PipeConnection south, PipeBlockEntityBase.PipeConnection west, PipeBlockEntityBase.PipeConnection east) {
        return ((((down.visualIndex * 3 + up.visualIndex) * 3 + north.visualIndex) * 3 + south.visualIndex) * 3 + west.visualIndex) * 3 + east.visualIndex;
    }

    public VoxelShape getCenterShape() {
        return CENTER_AABB;
    }

    public static void makeShapes(VoxelShape center, VoxelShape[] shapes) {
        for (PipeBlockEntityBase.PipeConnection down : PipeBlockEntityBase.PipeConnection.visual()) {
            for (PipeBlockEntityBase.PipeConnection up : PipeBlockEntityBase.PipeConnection.visual()) {
                for (PipeBlockEntityBase.PipeConnection north : PipeBlockEntityBase.PipeConnection.visual()) {
                    for (PipeBlockEntityBase.PipeConnection south : PipeBlockEntityBase.PipeConnection.visual()) {
                        for (PipeBlockEntityBase.PipeConnection west : PipeBlockEntityBase.PipeConnection.visual()) {
                            for (PipeBlockEntityBase.PipeConnection east : PipeBlockEntityBase.PipeConnection.visual()) {
                                VoxelShape shape = center;
                                if (down == PipeBlockEntityBase.PipeConnection.PIPE) {
                                    shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)PIPE_DOWN_AABB, (BooleanOp)BooleanOp.f_82695_);
                                } else if (down == PipeBlockEntityBase.PipeConnection.END) {
                                    shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)END_DOWN_AABB, (BooleanOp)BooleanOp.f_82695_);
                                }
                                if (up == PipeBlockEntityBase.PipeConnection.PIPE) {
                                    shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)PIPE_UP_AABB, (BooleanOp)BooleanOp.f_82695_);
                                } else if (up == PipeBlockEntityBase.PipeConnection.END) {
                                    shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)END_UP_AABB, (BooleanOp)BooleanOp.f_82695_);
                                }
                                if (north == PipeBlockEntityBase.PipeConnection.PIPE) {
                                    shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)PIPE_NORTH_AABB, (BooleanOp)BooleanOp.f_82695_);
                                } else if (north == PipeBlockEntityBase.PipeConnection.END) {
                                    shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)END_NORTH_AABB, (BooleanOp)BooleanOp.f_82695_);
                                }
                                if (south == PipeBlockEntityBase.PipeConnection.PIPE) {
                                    shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)PIPE_SOUTH_AABB, (BooleanOp)BooleanOp.f_82695_);
                                } else if (south == PipeBlockEntityBase.PipeConnection.END) {
                                    shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)END_SOUTH_AABB, (BooleanOp)BooleanOp.f_82695_);
                                }
                                if (west == PipeBlockEntityBase.PipeConnection.PIPE) {
                                    shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)PIPE_WEST_AABB, (BooleanOp)BooleanOp.f_82695_);
                                } else if (west == PipeBlockEntityBase.PipeConnection.END) {
                                    shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)END_WEST_AABB, (BooleanOp)BooleanOp.f_82695_);
                                }
                                if (east == PipeBlockEntityBase.PipeConnection.PIPE) {
                                    shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)PIPE_EAST_AABB, (BooleanOp)BooleanOp.f_82695_);
                                } else if (east == PipeBlockEntityBase.PipeConnection.END) {
                                    shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)END_EAST_AABB, (BooleanOp)BooleanOp.f_82695_);
                                }
                                shapes[PipeBlockBase.getShapeIndex((PipeBlockEntityBase.PipeConnection)down, (PipeBlockEntityBase.PipeConnection)up, (PipeBlockEntityBase.PipeConnection)north, (PipeBlockEntityBase.PipeConnection)south, (PipeBlockEntityBase.PipeConnection)west, (PipeBlockEntityBase.PipeConnection)east)] = shape.m_83296_();
                            }
                        }
                    }
                }
            }
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        BlockEntity BE = level.m_7702_(pos);
        if (BE instanceof PipeBlockEntityBase) {
            PipeBlockEntityBase pipe = (PipeBlockEntityBase)BE;
            return SHAPES[PipeBlockBase.getShapeIndex(pipe.connections[0], pipe.connections[1], pipe.connections[2], pipe.connections[3], pipe.connections[4], pipe.connections[5])];
        }
        return CENTER_AABB;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        BlockEntity BE;
        if (((Boolean)pState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        if ((BE = pLevel.m_7702_(pCurrentPos)) instanceof PipeBlockEntityBase) {
            PipeBlockEntityBase pipe = (PipeBlockEntityBase)BE;
            BlockEntity facingBE = pLevel.m_7702_(pFacingPos);
            if (!(facingBE instanceof PipeBlockEntityBase) || ((PipeBlockEntityBase)facingBE).getConnection(pFacing.m_122424_()) != PipeBlockEntityBase.PipeConnection.DISABLED) {
                boolean enabled;
                boolean bl = enabled = pipe.getConnection(pFacing) != PipeBlockEntityBase.PipeConnection.DISABLED;
                if (pFacingState.m_204336_(this.getConnectionTag()) && enabled) {
                    if (facingBE instanceof PipeBlockEntityBase && ((PipeBlockEntityBase)facingBE).getConnection(pFacing.m_122424_()) == PipeBlockEntityBase.PipeConnection.DISABLED) {
                        pipe.setConnection(pFacing, PipeBlockEntityBase.PipeConnection.DISABLED);
                    } else {
                        pipe.setConnection(pFacing, PipeBlockEntityBase.PipeConnection.PIPE);
                    }
                } else {
                    BlockEntity blockEntity = pLevel.m_7702_(pFacingPos);
                    if (this.connected(pFacing, pFacingState)) {
                        pipe.setConnection(pFacing, PipeBlockEntityBase.PipeConnection.LEVER);
                    } else if (this.connectToTile(blockEntity, pFacing) && enabled) {
                        if (pFacingState.m_60734_() instanceof IPipeConnection) {
                            pipe.setConnection(pFacing, ((IPipeConnection)pFacingState.m_60734_()).getPipeConnection(pFacingState, pFacing.m_122424_()));
                        } else {
                            pipe.setConnection(pFacing, PipeBlockEntityBase.PipeConnection.END);
                        }
                    } else if (enabled) {
                        pipe.setConnection(pFacing, PipeBlockEntityBase.PipeConnection.NONE);
                    }
                }
            }
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public static boolean facingConnected(Direction facing, BlockState state, DirectionProperty property) {
        return !state.m_61138_((Property)property) || state.m_61143_((Property)property) == facing;
    }

    public abstract boolean connected(Direction var1, BlockState var2);

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pState.m_60713_(pNewState.m_60734_())) {
            IItemHandler handler;
            BlockEntity blockEntity = pLevel.m_7702_(pPos);
            if (blockEntity != null && (handler = (IItemHandler)blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, null).orElse(null)) != null) {
                Misc.spawnInventoryInWorld(pLevel, (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5, handler);
                pLevel.m_46717_(pPos, (Block)this);
            }
            super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    static {
        PipeBlockBase.makeShapes(CENTER_AABB, SHAPES);
    }
}

