/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.augment;

import com.rekindled.embers.api.augment.AugmentUtil;
import com.rekindled.embers.api.event.EmberProjectileEvent;
import com.rekindled.embers.api.projectile.EffectArea;
import com.rekindled.embers.api.projectile.EffectDamage;
import com.rekindled.embers.api.projectile.EffectMulti;
import com.rekindled.embers.api.projectile.IProjectileEffect;
import com.rekindled.embers.api.projectile.IProjectilePreset;
import com.rekindled.embers.api.projectile.ProjectileFireball;
import com.rekindled.embers.api.projectile.ProjectileRay;
import com.rekindled.embers.augment.AugmentBase;
import com.rekindled.embers.util.Misc;
import java.util.ListIterator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class DiffractionBarrelAugment
extends AugmentBase {
    public DiffractionBarrelAugment(ResourceLocation id) {
        super(id, 2.0);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onProjectileFire(EmberProjectileEvent event) {
        int level;
        ListIterator<IProjectilePreset> projectiles = event.getProjectiles().listIterator();
        ItemStack weapon = event.getStack();
        if (!weapon.m_41619_() && AugmentUtil.hasHeat(weapon) && (level = AugmentUtil.getAugmentLevel(weapon, this)) > 0) {
            while (projectiles.hasNext()) {
                IProjectilePreset projectile = projectiles.next();
                Vec3 velocity = projectile.getVelocity();
                double speed = velocity.m_82553_();
                int bullets = 3 + level;
                IProjectileEffect effect = projectile.getEffect();
                if (projectile instanceof ProjectileRay) {
                    double newspeed = 1.0;
                    this.adjustEffect(effect, 0.3333333333333333);
                    projectiles.remove();
                    for (int i = 0; i < bullets; ++i) {
                        double spread = 0.1 * (double)level;
                        Vec3 newVelocity = velocity.m_82520_((Misc.random.nextDouble() - 0.5) * speed * 2.0 * spread, (Misc.random.nextDouble() - 0.5) * speed * 2.0 * spread, (Misc.random.nextDouble() - 0.5) * speed * 2.0 * spread).m_82490_(newspeed / speed);
                        ProjectileFireball newProjectile = new ProjectileFireball(projectile.getShooter(), projectile.getPos(), newVelocity, 2.4, 80, effect);
                        newProjectile.setColor(projectile.getColor());
                        newProjectile.setColor(projectile.getColorId());
                        projectiles.add(newProjectile);
                    }
                    continue;
                }
                if (!(projectile instanceof ProjectileFireball)) continue;
                ProjectileFireball fireball = (ProjectileFireball)projectile;
                this.adjustEffect(effect, 0.3333333333333333);
                projectiles.remove();
                for (int i = 0; i < bullets; ++i) {
                    double spread = 0.1 * (double)level;
                    Vec3 newVelocity = velocity.m_82520_((Misc.random.nextDouble() - 0.5) * speed * 2.0 * spread, (Misc.random.nextDouble() - 0.5) * speed * 2.0 * spread, (Misc.random.nextDouble() - 0.5) * speed * 2.0 * spread);
                    ProjectileFireball newProjectile = new ProjectileFireball(projectile.getShooter(), projectile.getPos(), newVelocity, fireball.getSize() / 3.0, fireball.getLifetime() / 2, effect);
                    newProjectile.setColor(projectile.getColor());
                    newProjectile.setColor(projectile.getColorId());
                    projectiles.add(newProjectile);
                }
            }
        }
    }

    private void adjustEffect(IProjectileEffect effect, double multiplier) {
        if (effect instanceof EffectArea) {
            EffectArea areaEffect = (EffectArea)effect;
            this.adjustEffect(areaEffect.getEffect(), multiplier);
        } else if (effect instanceof EffectMulti) {
            for (IProjectileEffect subEffect : ((EffectMulti)effect).getEffects()) {
                this.adjustEffect(subEffect, multiplier);
            }
        } else if (effect instanceof EffectDamage) {
            EffectDamage damageEffect = (EffectDamage)effect;
            damageEffect.setDamage((float)((double)damageEffect.getDamage() * multiplier));
            damageEffect.setInvinciblityMultiplier(0.0);
        }
    }
}

