/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.apiimpl;

import com.google.common.collect.Lists;
import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.augment.IAugment;
import com.rekindled.embers.api.augment.IAugmentUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class AugmentUtilImpl
implements IAugmentUtil {
    @Override
    public Collection<IAugment> getAllAugments() {
        return RegistryManager.augmentRegistry.values();
    }

    @Override
    public IAugment getAugment(ResourceLocation name) {
        return RegistryManager.augmentRegistry.get(name);
    }

    @Override
    public List<IAugment> getAugments(ItemStack stack) {
        ListTag tagAugments;
        if (this.hasHeat(stack) && (tagAugments = stack.m_41784_().m_128469_("embers:heat_tag").m_128437_("augments", 10)).size() > 0) {
            ArrayList<IAugment> results = new ArrayList<IAugment>();
            for (int i = 0; i < tagAugments.size(); ++i) {
                CompoundTag tagAugment = tagAugments.m_128728_(i);
                IAugment augment = this.getAugment(new ResourceLocation(tagAugment.m_128461_("name")));
                if (augment == null) continue;
                results.add(augment);
            }
            return results;
        }
        return Lists.newArrayList();
    }

    @Override
    public int getTotalAugmentLevel(ItemStack stack) {
        int total = 0;
        if (this.hasHeat(stack)) {
            ListTag list = stack.m_41784_().m_128469_("embers:heat_tag").m_128437_("augments", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag compound = list.m_128728_(i);
                IAugment augment = this.getAugment(new ResourceLocation(compound.m_128461_("name")));
                if (!augment.countTowardsTotalLevel()) continue;
                total += compound.m_128451_("level");
            }
        }
        return total;
    }

    @Override
    public boolean hasAugment(ItemStack stack, IAugment augment) {
        if (this.hasHeat(stack)) {
            ListTag list = stack.m_41784_().m_128469_("embers:heat_tag").m_128437_("augments", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag compound = list.m_128728_(i);
                if (!compound.m_128441_("name") || compound.m_128461_("name").compareTo(augment.getName().toString()) != 0) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void addAugment(ItemStack stack, ItemStack augmentStack, IAugment augment) {
        AugmentUtilImpl.checkForTag(stack);
        ListTag list = stack.m_41784_().m_128469_("embers:heat_tag").m_128437_("augments", 10);
        int level = this.getAugmentLevel(stack, augment);
        if (level == 0) {
            CompoundTag augmentCompound = new CompoundTag();
            augmentCompound.m_128359_("name", augment.getName().toString());
            ListTag items = new ListTag();
            augmentCompound.m_128365_("items", (Tag)items);
            items.add((Object)augmentStack.m_41739_(new CompoundTag()));
            augmentCompound.m_128405_("level", 1);
            list.add((Object)augmentCompound);
        } else {
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag augmentCompound = list.m_128728_(i);
                if (!augmentCompound.m_128441_("name") || augmentCompound.m_128461_("name").compareTo(augment.getName().toString()) != 0) continue;
                ListTag items = augmentCompound.m_128437_("items", 10);
                items.add((Object)augmentStack.m_41739_(new CompoundTag()));
                augmentCompound.m_128405_("level", level + 1);
            }
        }
        augment.onApply(stack);
    }

    @Override
    public List<ItemStack> removeAllAugments(ItemStack stack) {
        CompoundTag tagCompound;
        ListTag tagAugments;
        if (this.hasHeat(stack) && (tagAugments = (tagCompound = stack.m_41784_()).m_128469_("embers:heat_tag").m_128437_("augments", 10)).size() > 0) {
            ArrayList<ItemStack> results = new ArrayList<ItemStack>();
            ListTag remainingAugments = new ListTag();
            ArrayList<IAugment> removedAugments = new ArrayList<IAugment>();
            for (int i = 0; i < tagAugments.size(); ++i) {
                CompoundTag tagAugment = tagAugments.m_128728_(i);
                IAugment augment = this.getAugment(new ResourceLocation(tagAugment.m_128461_("name")));
                if (augment == null) continue;
                if (augment.canRemove()) {
                    for (int j = 0; j < tagAugment.m_128451_("level"); ++j) {
                        removedAugments.add(augment);
                    }
                    if (!tagAugment.m_128441_("items")) continue;
                    ListTag items = tagAugment.m_128437_("items", 10);
                    for (int j = 0; j < items.size(); ++j) {
                        results.add(ItemStack.m_41712_((CompoundTag)items.m_128728_(j)));
                    }
                    continue;
                }
                remainingAugments.add((Object)tagAugment);
            }
            tagCompound.m_128469_("embers:heat_tag").m_128365_("augments", (Tag)remainingAugments);
            for (IAugment augment : removedAugments) {
                augment.onRemove(stack);
            }
            return results;
        }
        return Lists.newArrayList();
    }

    @Override
    public void addAugmentLevel(ItemStack stack, IAugment augment, int levels) {
        this.setAugmentLevel(stack, augment, this.getAugmentLevel(stack, augment) + levels);
    }

    @Override
    public void setAugmentLevel(ItemStack stack, IAugment augment, int level) {
        AugmentUtilImpl.checkForTag(stack);
        ListTag list = stack.m_41784_().m_128469_("embers:heat_tag").m_128437_("augments", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag compound = list.m_128728_(i);
            if (!compound.m_128441_("name") || compound.m_128461_("name").compareTo(augment.getName().toString()) != 0) continue;
            compound.m_128405_("level", level);
        }
    }

    @Override
    public int getAugmentLevel(ItemStack stack, IAugment augment) {
        if (this.hasHeat(stack)) {
            ListTag list = stack.m_41784_().m_128469_("embers:heat_tag").m_128437_("augments", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag compound = list.m_128728_(i);
                if (!compound.m_128441_("name") || compound.m_128461_("name").compareTo(augment.getName().toString()) != 0) continue;
                return compound.m_128451_("level");
            }
        }
        return 0;
    }

    @Override
    public boolean hasHeat(ItemStack stack) {
        return !stack.m_41619_() && stack.m_41782_() && stack.m_41783_().m_128441_("embers:heat_tag");
    }

    @Override
    public void addHeat(ItemStack stack, float heat) {
        AugmentUtilImpl.checkForTag(stack);
        stack.m_41783_().m_128469_("embers:heat_tag").m_128350_("heat", Math.min(this.getMaxHeat(stack), this.getHeat(stack) + heat));
    }

    @Override
    public void setHeat(ItemStack stack, float heat) {
        AugmentUtilImpl.checkForTag(stack);
        stack.m_41783_().m_128469_("embers:heat_tag").m_128350_("heat", heat);
    }

    @Override
    public float getHeat(ItemStack stack) {
        if (this.hasHeat(stack)) {
            return stack.m_41783_().m_128469_("embers:heat_tag").m_128457_("heat");
        }
        return 0.0f;
    }

    @Override
    public float getMaxHeat(ItemStack stack) {
        if (this.hasHeat(stack)) {
            return 500.0f + 250.0f * stack.m_41783_().m_128469_("embers:heat_tag").m_128457_("heat_level");
        }
        return 0.0f;
    }

    @Override
    public int getLevel(ItemStack stack) {
        if (this.hasHeat(stack)) {
            return stack.m_41783_().m_128469_("embers:heat_tag").m_128451_("heat_level");
        }
        return 0;
    }

    @Override
    public void setLevel(ItemStack stack, int level) {
        AugmentUtilImpl.checkForTag(stack);
        stack.m_41783_().m_128469_("embers:heat_tag").m_128405_("heat_level", level);
    }

    @Override
    public int getArmorAugmentLevel(LivingEntity entity, IAugment augment) {
        int l;
        int maxLevel = 0;
        if (this.hasHeat(entity.m_6844_(EquipmentSlot.HEAD)) && (l = this.getAugmentLevel(entity.m_6844_(EquipmentSlot.HEAD), augment)) > maxLevel) {
            maxLevel = l;
        }
        if (this.hasHeat(entity.m_6844_(EquipmentSlot.CHEST)) && (l = this.getAugmentLevel(entity.m_6844_(EquipmentSlot.CHEST), augment)) > maxLevel) {
            maxLevel = l;
        }
        if (this.hasHeat(entity.m_6844_(EquipmentSlot.LEGS)) && (l = this.getAugmentLevel(entity.m_6844_(EquipmentSlot.LEGS), augment)) > maxLevel) {
            maxLevel = l;
        }
        if (this.hasHeat(entity.m_6844_(EquipmentSlot.FEET)) && (l = this.getAugmentLevel(entity.m_6844_(EquipmentSlot.FEET), augment)) > maxLevel) {
            maxLevel = l;
        }
        return maxLevel;
    }

    @Override
    public IAugment registerAugment(IAugment augment) {
        RegistryManager.augmentRegistry.put(augment.getName(), augment);
        return augment;
    }

    public static void checkForTag(ItemStack stack) {
        if (!stack.m_41784_().m_128441_("embers:heat_tag")) {
            stack.m_41783_().m_128365_("embers:heat_tag", (Tag)new CompoundTag());
            stack.m_41783_().m_128469_("embers:heat_tag").m_128405_("heat_level", 0);
            stack.m_41783_().m_128469_("embers:heat_tag").m_128350_("heat", 0.0f);
            stack.m_41783_().m_128469_("embers:heat_tag").m_128365_("augments", (Tag)new ListTag());
        }
    }
}

