/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.config;

import com.jaquadro.minecraft.storagedrawers.config.CompTierRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public final class CommonConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final General GENERAL = new General(BUILDER);
    public static final Upgrades UPGRADES = new Upgrades(BUILDER);
    public static final Conversion CONVERSION = new Conversion(BUILDER);
    public static final Integration INTEGRATION = new Integration(BUILDER);
    public static final ForgeConfigSpec spec = BUILDER.build();
    private static boolean loaded = false;
    private static final List<Runnable> loadActions = new ArrayList<Runnable>();

    public static void setLoaded() {
        if (!loaded) {
            loadActions.forEach(Runnable::run);
        }
        loaded = true;
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public static void onLoad(Runnable action) {
        if (loaded) {
            action.run();
        } else {
            loadActions.add(action);
        }
    }

    public static class General {
        public final ForgeConfigSpec.ConfigValue<Integer> baseStackStorage;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableUI;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableSidedInput;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableSidedOutput;
        public final ForgeConfigSpec.ConfigValue<Boolean> debugTrace;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableExtraCompactingRules;
        public final ForgeConfigSpec.ConfigValue<Integer> controllerRange;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableAnalogRedstone;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableDetachedDrawers;
        public final ForgeConfigSpec.ConfigValue<Boolean> forceDetachedDrawersMaxCapacityCheck;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> compRules;
        public final ForgeConfigSpec.ConfigValue<Boolean> heavyDrawers;
        public final ForgeConfigSpec.ConfigValue<Boolean> enablePersonalKey;

        public General(ForgeConfigSpec.Builder builder) {
            builder.push("General");
            ArrayList<String> test = new ArrayList<String>();
            test.add("minecraft:clay, minecraft:clay_ball, 4");
            this.baseStackStorage = builder.comment(new String[]{"The number of item stacks held in a basic unit of storage.", "1x1 drawers hold 8 units, 1x2 drawers hold 4 units, 2x2 drawers hold 2 units.", "Half-depth drawers hold half those amounts."}).define("baseStackStorage", (Object)4);
            this.controllerRange = builder.comment(new String[]{"Controller range defines how far away a drawer can be connected", "on X, Y, or Z planes.  The default value of 50 gives the controller a very", "large range, but not beyond the chunk load distance."}).defineInRange("controllerRange", 50, 1, 75);
            this.enableAnalogRedstone = builder.comment(new String[]{"Whether redstone upgrades should emit an analog redstone signal, requiring", "the use of a comparator to read it.  This will default to true starting with MC 1.21."}).define("enableAnalogRedstone", false);
            this.enableUI = builder.define("enableUI", true);
            this.enableSidedInput = builder.define("enableSidedInput", true);
            this.enableSidedOutput = builder.define("enableSidedOutput", true);
            this.enableExtraCompactingRules = builder.define("enableExtraCompactingRules", true);
            this.enableDetachedDrawers = builder.comment("Allows drawers to be pulled from their block and inserted into another block.").define("enableDetachedDrawers", true);
            this.forceDetachedDrawersMaxCapacityCheck = builder.comment(new String[]{"Drawers track the capacity upgrades from the block they were taken from.", "Drawers can only be placed back into a block with the same or lower max capacity.", "Drawers can still only be inserted into a block with enough capacity for the items held."}).define("forceDetachedDrawersMaxCapacityCheck", false);
            this.debugTrace = builder.define("debugTrace", false);
            this.compRules = builder.comment(new String[]{"List of rules in format \"domain:item1, domain:item2, n\".", "Creates a compacting drawer rule to convert 1 of item1 into n of item2."}).defineList("compactingRules", test, obj -> CompTierRegistry.validateRuleSyntax((String)obj));
            this.heavyDrawers = builder.comment("If enabled, carrying filled drawers in your inventory gives slowness debuff, unless a Portability Upgrade is used.").define("heavyDrawers", false);
            this.enablePersonalKey = builder.comment("If enabled, players can lock drawer interactions to just themselves.").define("enablePersonalKey", true);
            builder.pop();
        }

        public int getBaseStackStorage() {
            if (!CommonConfig.isLoaded()) {
                return 1;
            }
            return (Integer)this.baseStackStorage.get();
        }
    }

    public static class Upgrades {
        public final ForgeConfigSpec.ConfigValue<Integer> level1Mult;
        public final ForgeConfigSpec.ConfigValue<Integer> level2Mult;
        public final ForgeConfigSpec.ConfigValue<Integer> level3Mult;
        public final ForgeConfigSpec.ConfigValue<Integer> level4Mult;
        public final ForgeConfigSpec.ConfigValue<Integer> level5Mult;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableStorageUpgrade;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableFillLevelUpgrade;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableRedstoneUpgrade;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableIlluminationUpgrade;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableVoidUpgrade;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableBalanceUpgrade;
        public final ForgeConfigSpec.ConfigValue<Boolean> enablePortabilityUpgrade;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableRemoteUpgrade;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableRemoteGroupUpgrade;

        public Upgrades(ForgeConfigSpec.Builder builder) {
            builder.push("StorageUpgrades");
            builder.comment(new String[]{"Storage upgrades multiply storage capacity by the given amount.", "When multiple storage upgrades are used together, their multipliers are added before being applied.", "Storage upgrades start at the level 2 multiplier.  The resistance upgrade uses level 1."});
            this.level1Mult = builder.define("level1Mult", (Object)2);
            this.level2Mult = builder.define("level2Mult", (Object)4);
            this.level3Mult = builder.define("level3Mult", (Object)8);
            this.level4Mult = builder.define("level4Mult", (Object)16);
            this.level5Mult = builder.define("level5Mult", (Object)32);
            this.enableStorageUpgrade = builder.comment("Storage upgrades increase capacity of drawers.").define("enableStorageUpgrade", true);
            this.enableFillLevelUpgrade = builder.comment("Fill level upgrades add fill bars to the faces of drawers.").define("enableFillLevelUpgrade", true);
            this.enableRedstoneUpgrade = builder.comment("Adds redstone output to drawers based on fill levels.").define("enableRedstoneUpgrade", true);
            this.enableIlluminationUpgrade = builder.comment("Renders drawer labels brighter than the surrounding environment would allow.").define("enableIlluminationUpgrade", true);
            this.enableVoidUpgrade = builder.comment("Causes drawers to accept but void compatible items when they are filled to capacity.").define("enableVoidUpgrade", true);
            this.enableBalanceUpgrade = builder.comment(new String[]{"Balance upgrades allow same-item slots to balance out their amounts when items are", "added or removed from a lot.  Works across networks when acting through a controller."}).define("enableBalanceUpgrade", true);
            this.enablePortabilityUpgrade = builder.comment("Allows drawers with contents to be freely carried when heavy drawers is enabled.").define("enablePortabilityUpgrade", true);
            this.enableRemoteUpgrade = builder.comment("Allows a single drawer to connect to a controller remotely.").define("enableRemoteUpgrade", true);
            this.enableRemoteGroupUpgrade = builder.comment("Allows a drawer and all drawers connected to it to connect to a controller remotely.").define("enableRemoteGroupUpgrade", true);
            builder.pop();
        }

        public int getLevelMult(int level) {
            if (!CommonConfig.isLoaded()) {
                return 1;
            }
            return switch (level) {
                case 1 -> (Integer)this.level1Mult.get();
                case 2 -> (Integer)this.level2Mult.get();
                case 3 -> (Integer)this.level3Mult.get();
                case 4 -> (Integer)this.level4Mult.get();
                case 5 -> (Integer)this.level5Mult.get();
                default -> 1;
            };
        }
    }

    public static class Conversion {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> oreTypes;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> oreMaterials;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> tagWhitelist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> tagBlacklist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> itemEquivGroups;

        public Conversion(ForgeConfigSpec.Builder builder) {
            builder.push("Conversion");
            this.oreTypes = builder.comment(new String[]{"", "Each type will be combined with each material to create a set of whitelist entries.", "This is mainly a convenience for common ore-based materials."}).defineList("oreTypeWhitelist", Arrays.asList("forge:storage_blocks", "forge:ingots", "forge:nuggets"), x -> true);
            this.oreMaterials = builder.comment(new String[]{"", "Each type will be combined with each material to create a set of whitelist entries.", "This is mainly a convenience for common ore-based materials."}).defineList("oreMaterialWhitelist", Arrays.asList("aluminum", "constantan", "steel", "uranium", "invar", "tin", "lead", "silver", "platinum", "nickel", "osmium", "bronze", "electrum"), x -> true);
            this.tagWhitelist = builder.comment(new String[]{"", "Each whitelist entry should be a fully namespaced tag, e.g. c:ingots/copper"}).defineList("tagWhitelist", new ArrayList(), x -> true);
            this.tagBlacklist = builder.comment(new String[]{"", "Each blacklist entry should be a fully namespaced tag, e.g. c:ingots/copper.", "All items not on the whitelist are blacklisted implicitly.  This can be used to exclude", "specific entries created from the ore whitelist set."}).defineList("tagBlacklist", new ArrayList(), x -> true);
            this.itemEquivGroups = builder.comment(new String[]{"", "Each entry is a semicolon-separated list of fully-namespaced items. All items within the", "same entry are considered equivalent and convertible/interchangeable.", "Example: [\"thermal:nickel_ore;immersiveengineering:ore_nickel\"]"}).defineList("itemEquivalenceGroups", new ArrayList(), x -> true);
            builder.pop();
        }
    }

    public static class Integration {
        public final ForgeConfigSpec.ConfigValue<Boolean> enableCoFHIntegration;
        public final ForgeConfigSpec.ConfigValue<Boolean> wailaStackRemainder;
        public final ForgeConfigSpec.BooleanValue wailaRespectQuantifyKey;

        public Integration(ForgeConfigSpec.Builder builder) {
            builder.push("Integration");
            this.enableCoFHIntegration = builder.comment("Add CoFH Core specific features if the mod is loaded").define("enableCoFHIntegration", true);
            this.wailaStackRemainder = builder.comment("When true, shows quantity as NxS + R (by stack size) rather than count").define("wailaStackRemainder", true);
            this.wailaRespectQuantifyKey = builder.comment("When true, does not show current quantities unless quantify key was used").define("wailaRespectQuantifyKey", false);
            builder.pop();
        }
    }
}

