/*
 * Decompiled with CFR 0.152.
 */
package com.ilexiconn.llibrary.client.util;

import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientUtils {
    private static long lastUpdate = System.currentTimeMillis();

    public static void updateLast() {
        lastUpdate = System.currentTimeMillis();
    }

    public static float updateValue(float current, float target) {
        return ClientUtils.updateValue(current, target, 0.5f);
    }

    public static float updateValue(float current, float target, float factor) {
        float times = (float)(System.currentTimeMillis() - lastUpdate) / 16.666666f;
        float off = target - current;
        off = off > 0.01f || off < -0.01f ? off * (float)Math.pow(factor, times) : 0.0f;
        return target - off;
    }

    public static float interpolate(float prev, float current, float partialTicks) {
        return prev + partialTicks * (current - prev);
    }

    public static float interpolateRotation(float prev, float current, float partialTicks) {
        float shortest = ((current - prev) % 360.0f + 540.0f) % 360.0f - 180.0f;
        return prev + shortest * partialTicks;
    }
}

