/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.lantern;

import com.bobmowzie.mowziesmobs.client.particle.ParticleCloud;
import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.particle.ParticleOrb;
import com.bobmowzie.mowziesmobs.client.particle.ParticleVanillaCloudExtended;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleBase;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleData;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationDieAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationTakeDamage;
import com.bobmowzie.mowziesmobs.server.ai.animation.SimpleAnimationAI;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import com.bobmowzie.mowziesmobs.server.entity.MowzieLLibraryEntity;
import com.bobmowzie.mowziesmobs.server.loot.LootTableHandler;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.ilexiconn.llibrary.server.animation.Animation;
import com.ilexiconn.llibrary.server.animation.AnimationHandler;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityLantern
extends MowzieLLibraryEntity {
    public static final Animation DIE_ANIMATION = Animation.create(25);
    public static final Animation HURT_ANIMATION = Animation.create(10);
    public static final Animation PUFF_ANIMATION = Animation.create(28);
    private static final Animation[] ANIMATIONS = new Animation[]{DIE_ANIMATION, HURT_ANIMATION, PUFF_ANIMATION};
    public Vec3 dir = null;
    private int groundDist = 1;
    @OnlyIn(value=Dist.CLIENT)
    private Vec3[] pos;

    public EntityLantern(EntityType<? extends EntityLantern> type, Level world) {
        super(type, world);
        if (world.f_46443_) {
            this.pos = new Vec3[1];
        }
        this.f_21342_ = new MoveHelperController(this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, new SimpleAnimationAI<EntityLantern>(this, PUFF_ANIMATION, false));
        this.f_21345_.m_25352_(3, new AnimationTakeDamage<EntityLantern>(this));
        this.f_21345_.m_25352_(1, new AnimationDieAI<EntityLantern>(this));
        this.f_21345_.m_25352_(5, (Goal)new RandomFlyGoal(this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MowzieEntity.createAttributes().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22280_, 0.3).m_22268_(Attributes.f_22279_, 0.2);
    }

    public float m_213856_() {
        return 1.572888E7f;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.getAnimation() == PUFF_ANIMATION && this.getAnimationTick() == 7) {
            if (this.groundDist == 0) {
                this.groundDist = 1;
            }
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.2 + 0.2 / (double)this.groundDist, 0.0));
            if (this.m_9236_().f_46443_) {
                int i;
                for (i = 0; i < 5; ++i) {
                    ParticleVanillaCloudExtended.spawnVanillaCloud(this.m_9236_(), this.m_20185_(), this.m_20186_() + 0.3, this.m_20189_(), -this.m_20184_().m_7096_() * 0.2 + 0.1 * ((double)this.f_19796_.m_188501_() - 0.5), -this.m_20184_().m_7098_() * 0.2 + 0.1 * ((double)this.f_19796_.m_188501_() - 0.5), -this.m_20184_().m_7094_() * 0.2 + 0.1 * ((double)this.f_19796_.m_188501_() - 0.5), 0.8 + this.f_19796_.m_188500_() * 1.0, 0.63671875, 0.96484375, 0.2890625, 0.95, 30.0);
                }
                for (i = 0; i < 8; ++i) {
                    AdvancedParticleBase.spawnParticle(this.m_9236_(), (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.PIXEL.get()), this.m_20185_(), this.m_20186_() + 0.3, this.m_20189_(), -this.m_20184_().m_7096_() * 0.2 + 0.2 * ((double)this.f_19796_.m_188501_() - 0.5), -this.m_20184_().m_7098_() * 0.2 + 0.1 * ((double)this.f_19796_.m_188501_() - 0.5), -this.m_20184_().m_7094_() * 0.2 + 0.2 * ((double)this.f_19796_.m_188501_() - 0.5), true, 0.0, 0.0, 0.0, 0.0, 4.0, 0.63671875, 0.96484375, 0.2890625, 1.0, 0.9, 17.0f + this.f_19796_.m_188501_() * 10.0f, true, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new ParticleComponent.KeyTrack(new float[]{4.0f, 0.0f}, new float[]{0.8f, 1.0f}), false)});
                }
            } else if (this.getMoveHelperController().isMovingTo()) {
                Vec3 lvt_1_1_ = new Vec3(this.m_21566_().m_25000_() - this.m_20185_(), this.m_21566_().m_25001_() - this.m_20186_(), this.m_21566_().m_25002_() - this.m_20189_());
                double lvt_2_1_ = lvt_1_1_.m_82553_();
                lvt_1_1_ = lvt_1_1_.m_82541_();
                if (this.getMoveHelperController().canReach(lvt_1_1_, Mth.m_14165_((double)lvt_2_1_))) {
                    this.m_20256_(this.m_20184_().m_82549_(lvt_1_1_.m_82490_(0.2)));
                }
            }
            this.m_5496_((SoundEvent)MMSounds.ENTITY_LANTERN_PUFF.get(), 0.6f, 1.0f + this.f_19796_.m_188501_() * 0.2f);
        }
        if (!this.m_9236_().f_46443_ && this.getAnimation() == NO_ANIMATION && (this.groundDist < 5 || this.f_19796_.m_188503_(13) == 0 && this.groundDist < 16)) {
            AnimationHandler.INSTANCE.sendAnimationMessage(this, PUFF_ANIMATION);
        }
        if (this.groundDist >= 2) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.0055, 0.0));
        }
        if (this.f_19797_ % 5 == 0) {
            int i;
            BlockPos checkPos = this.m_20183_();
            for (i = 0; i < 16 && this.m_9236_().m_8055_(checkPos).m_60734_() == Blocks.f_50016_; ++i) {
                checkPos = checkPos.m_7495_();
            }
            this.groundDist = i;
        }
        if (this.m_9236_().f_46443_ && ((Boolean)ConfigHandler.CLIENT.glowEffect.get()).booleanValue()) {
            this.pos[0] = this.m_20182_().m_82520_(0.0, (double)this.m_20206_() * 0.8, 0.0);
            if (this.f_19797_ % 70 == 0) {
                AdvancedParticleBase.spawnParticle(this.m_9236_(), (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.GLOW.get()), this.pos[0].f_82479_, this.pos[0].f_82480_, this.pos[0].f_82481_, 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 20.0, 0.8, 0.95, 0.35, 1.0, 1.0, 70.0, true, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, new ParticleComponent.KeyTrack(new float[]{0.0f, 0.8f, 0.0f}, new float[]{0.0f, 0.5f, 1.0f}), false), new ParticleComponent.PinLocation(this.pos)});
            }
        }
    }

    @Override
    protected void m_6153_() {
        super.m_6153_();
        if (this.getAnimationTick() == 1 && this.m_9236_().f_46443_) {
            for (int i = 0; i < 8; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123753_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.2 * ((double)this.f_19796_.m_188501_() - 0.5), 0.2 * ((double)this.f_19796_.m_188501_() - 0.5), 0.2 * ((double)this.f_19796_.m_188501_() - 0.5));
                this.m_9236_().m_7106_((ParticleOptions)new ParticleCloud.CloudData((ParticleType<ParticleCloud.CloudData>)((ParticleType)ParticleHandler.CLOUD.get()), 0.63671875f, 0.96484375f, 0.2890625f, 10.0f + this.f_19796_.m_188501_() * 20.0f, 30, ParticleCloud.EnumCloudBehavior.GROW, 0.9f), this.m_20185_(), this.m_20186_() + 0.3, this.m_20189_(), 0.25 * ((double)this.f_19796_.m_188501_() - 0.5), 0.25 * ((double)this.f_19796_.m_188501_() - 0.5), 0.25 * ((double)this.f_19796_.m_188501_() - 0.5));
                this.m_9236_().m_7106_((ParticleOptions)new ParticleOrb.OrbData(0.63671875f, 0.96484375f, 0.2890625f, 1.5f, 25), this.m_20185_(), this.m_20186_() + 0.3, this.m_20189_(), (double)(0.2f * (this.f_19796_.m_188501_() - 0.5f)), (double)(0.2f * (this.f_19796_.m_188501_() - 0.5f)), (double)(0.2f * (this.f_19796_.m_188501_() - 0.5f)));
            }
        }
        if (this.getAnimationTick() == 2) {
            this.m_5496_((SoundEvent)MMSounds.ENTITY_LANTERN_POP.get(), 1.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
        }
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void m_7023_(Vec3 movement) {
        if (this.m_20069_()) {
            this.m_19920_(0.02f, movement);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_((double)0.8f));
        } else if (this.m_20077_()) {
            this.m_19920_(0.02f, movement);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.5));
        } else {
            BlockPos ground = BlockPos.m_274561_((double)this.m_20185_(), (double)(this.m_20191_().f_82289_ - 1.0), (double)this.m_20189_());
            float f = 0.91f;
            if (this.m_20096_()) {
                f = this.m_9236_().m_8055_(ground).getFriction((LevelReader)this.m_9236_(), ground, (Entity)this) * 0.91f;
            }
            float f1 = 0.16277137f / (f * f * f);
            f = 0.91f;
            if (this.m_20096_()) {
                f = this.m_9236_().m_8055_(ground).getFriction((LevelReader)this.m_9236_(), ground, (Entity)this) * 0.91f;
            }
            this.m_19920_(this.m_20096_() ? 0.1f * f1 : 0.02f, movement);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_((double)f));
        }
        this.m_267651_(true);
    }

    @Override
    protected ConfigHandler.SpawnConfig getSpawnConfig() {
        return ConfigHandler.COMMON.MOBS.LANTERN.spawnConfig;
    }

    public boolean m_6147_() {
        return false;
    }

    @Override
    public Animation getDeathAnimation() {
        return DIE_ANIMATION;
    }

    @Override
    public Animation getHurtAnimation() {
        return HURT_ANIMATION;
    }

    @Override
    public Animation[] getAnimations() {
        return ANIMATIONS;
    }

    protected ResourceLocation m_7582_() {
        return LootTableHandler.LANTERN;
    }

    @Override
    protected ConfigHandler.CombatConfig getCombatConfig() {
        return ConfigHandler.COMMON.MOBS.LANTERN.combatConfig;
    }

    public MoveHelperController getMoveHelperController() {
        if (this.m_21566_() instanceof MoveHelperController) {
            return (MoveHelperController)super.m_21566_();
        }
        return null;
    }

    static class MoveHelperController
    extends MoveControl {
        private final EntityLantern parentEntity;
        protected int courseChangeCooldown;

        public MoveHelperController(EntityLantern p_i45838_1_) {
            super((Mob)p_i45838_1_);
            this.parentEntity = p_i45838_1_;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && this.courseChangeCooldown-- <= 0) {
                this.courseChangeCooldown += this.parentEntity.m_217043_().m_188503_(5) + 2;
                Vec3 lvt_1_1_ = new Vec3(this.f_24975_ - this.parentEntity.m_20185_(), this.f_24976_ - this.parentEntity.m_20186_(), this.f_24977_ - this.parentEntity.m_20189_());
                double lvt_2_1_ = lvt_1_1_.m_82553_();
                if (!this.canReach(lvt_1_1_ = lvt_1_1_.m_82541_(), Mth.m_14165_((double)lvt_2_1_))) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                }
            }
        }

        public boolean canReach(Vec3 p_220673_1_, int p_220673_2_) {
            AABB lvt_3_1_ = this.parentEntity.m_20191_();
            for (int lvt_4_1_ = 1; lvt_4_1_ < p_220673_2_; ++lvt_4_1_) {
                lvt_3_1_ = lvt_3_1_.m_82383_(p_220673_1_);
                if (this.parentEntity.m_9236_().m_45756_((Entity)this.parentEntity, lvt_3_1_)) continue;
                return false;
            }
            return true;
        }

        public boolean isMovingTo() {
            return this.f_24981_ == MoveControl.Operation.MOVE_TO;
        }
    }

    static class RandomFlyGoal
    extends Goal {
        private final EntityLantern parentEntity;

        public RandomFlyGoal(EntityLantern p_i45836_1_) {
            this.parentEntity = p_i45836_1_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            double lvt_6_1_;
            double lvt_4_1_;
            MoveControl lvt_1_1_ = this.parentEntity.m_21566_();
            if (!lvt_1_1_.m_24995_()) {
                return true;
            }
            double lvt_2_1_ = lvt_1_1_.m_25000_() - this.parentEntity.m_20185_();
            double lvt_8_1_ = lvt_2_1_ * lvt_2_1_ + (lvt_4_1_ = lvt_1_1_.m_25001_() - this.parentEntity.m_20186_()) * lvt_4_1_ + (lvt_6_1_ = lvt_1_1_.m_25002_() - this.parentEntity.m_20189_()) * lvt_6_1_;
            return lvt_8_1_ < 1.0 || lvt_8_1_ > 3600.0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            RandomSource lvt_1_1_ = this.parentEntity.m_217043_();
            double lvt_2_1_ = this.parentEntity.m_20185_() + (double)((lvt_1_1_.m_188501_() * 2.0f - 1.0f) * 16.0f);
            double lvt_4_1_ = this.parentEntity.m_20186_() + (double)((lvt_1_1_.m_188501_() * 2.0f - 1.0f) * 16.0f);
            double lvt_6_1_ = this.parentEntity.m_20189_() + (double)((lvt_1_1_.m_188501_() * 2.0f - 1.0f) * 16.0f);
            this.parentEntity.m_21566_().m_6849_(lvt_2_1_, lvt_4_1_, lvt_6_1_, 1.0);
        }
    }
}

