/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.capability;

import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieGeoModel;
import com.bobmowzie.mowziesmobs.client.render.entity.player.GeckoPlayer;
import com.bobmowzie.mowziesmobs.server.ability.Ability;
import com.bobmowzie.mowziesmobs.server.ability.AbilityHandler;
import com.bobmowzie.mowziesmobs.server.ability.AbilityType;
import com.bobmowzie.mowziesmobs.server.capability.CapabilityHandler;
import com.bobmowzie.mowziesmobs.server.entity.MowzieGeckoEntity;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.PlayState;

public class AbilityCapability {
    public static ResourceLocation ID = new ResourceLocation("mowziesmobs", "ability_cap");

    public static class AbilityProvider
    implements ICapabilityProvider,
    ICapabilitySerializable<CompoundTag> {
        private final LazyOptional<IAbilityCapability> instance = LazyOptional.of(AbilityCapabilityImp::new);

        public CompoundTag serializeNBT() {
            return (CompoundTag)((IAbilityCapability)this.instance.orElseThrow(NullPointerException::new)).serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            ((IAbilityCapability)this.instance.orElseThrow(NullPointerException::new)).deserializeNBT((Tag)nbt);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
            return CapabilityHandler.ABILITY_CAPABILITY.orEmpty(cap, this.instance.cast());
        }
    }

    public static class AbilityCapabilityImp
    implements IAbilityCapability {
        SortedMap<AbilityType<?, ?>, Ability> abilityInstances = new TreeMap();
        Ability activeAbility = null;
        Map<String, Tag> nbtMap = new HashMap<String, Tag>();

        @Override
        public void instanceAbilities(LivingEntity entity) {
            this.setActiveAbility(null);
            for (AbilityType<?, ?> abilityType : this.getAbilityTypesOnEntity(entity)) {
                Object ability = abilityType.makeInstance(entity);
                this.abilityInstances.put(abilityType, (Ability)ability);
                if (!this.nbtMap.containsKey(abilityType.getName())) continue;
                ((Ability)ability).readNBT(this.nbtMap.get(abilityType.getName()));
            }
        }

        @Override
        public void activateAbility(LivingEntity entity, AbilityType<?, ?> abilityType) {
            Ability ability = (Ability)this.abilityInstances.get(abilityType);
            if (ability != null) {
                boolean tryResult = ability.tryAbility();
                if (tryResult) {
                    ability.start();
                }
            } else {
                System.out.println("Ability " + abilityType.toString() + " does not exist on mob " + entity.getClass().getSimpleName());
            }
        }

        @Override
        public void tick(LivingEntity entity) {
            for (Ability ability : this.abilityInstances.values()) {
                ability.tick();
            }
        }

        @Override
        public AbilityType<?, ?>[] getAbilityTypesOnEntity(LivingEntity entity) {
            if (entity instanceof Player) {
                return AbilityHandler.PLAYER_ABILITIES;
            }
            if (entity instanceof MowzieGeckoEntity) {
                return ((MowzieGeckoEntity)entity).getAbilities();
            }
            return new AbilityType[0];
        }

        @Override
        public Map<AbilityType<?, ?>, Ability> getAbilityMap() {
            return this.abilityInstances;
        }

        @Override
        public Ability getAbilityFromType(AbilityType<?, ?> abilityType) {
            return (Ability)this.abilityInstances.get(abilityType);
        }

        @Override
        public Ability getActiveAbility() {
            return this.activeAbility;
        }

        @Override
        public void setActiveAbility(Ability activeAbility) {
            if (this.getActiveAbility() != null && this.getActiveAbility().isUsing()) {
                this.getActiveAbility().interrupt();
            }
            this.activeAbility = activeAbility;
        }

        @Override
        public Collection<Ability> getAbilities() {
            return this.abilityInstances.values();
        }

        @Override
        public boolean attackingPrevented() {
            return this.getActiveAbility() != null && this.getActiveAbility().preventsAttacking();
        }

        @Override
        public boolean blockBreakingBuildingPrevented() {
            return this.getActiveAbility() != null && this.getActiveAbility().preventsBlockBreakingBuilding();
        }

        @Override
        public boolean interactingPrevented() {
            return this.getActiveAbility() != null && this.getActiveAbility().preventsInteracting();
        }

        @Override
        public boolean itemUsePrevented(ItemStack itemStack) {
            return this.getActiveAbility() != null && this.getActiveAbility().preventsItemUse(itemStack);
        }

        @Override
        public <E extends GeoEntity> PlayState animationPredicate(AnimationState<E> e, GeckoPlayer.Perspective perspective) {
            return this.getActiveAbility().animationPredicate(e, perspective);
        }

        @Override
        public void codeAnimations(MowzieGeoModel<? extends GeoEntity> model, float partialTick) {
            this.getActiveAbility().codeAnimations(model, partialTick);
        }

        public CompoundTag serializeNBT() {
            CompoundTag compound = new CompoundTag();
            for (Map.Entry<AbilityType<?, ?>, Ability> abilityEntry : this.getAbilityMap().entrySet()) {
                CompoundTag nbt = abilityEntry.getValue().writeNBT();
                if (nbt.m_128456_()) continue;
                compound.m_128365_(abilityEntry.getKey().getName(), (Tag)nbt);
            }
            return compound;
        }

        public void deserializeNBT(CompoundTag nbt) {
            CompoundTag compound = nbt;
            Set keys = compound.m_128431_();
            for (String abilityName : keys) {
                this.nbtMap.put(abilityName, compound.m_128423_(abilityName));
            }
        }
    }

    public static interface IAbilityCapability
    extends INBTSerializable<CompoundTag> {
        public void activateAbility(LivingEntity var1, AbilityType<?, ?> var2);

        public void instanceAbilities(LivingEntity var1);

        public void tick(LivingEntity var1);

        public AbilityType<?, ?>[] getAbilityTypesOnEntity(LivingEntity var1);

        public Map<AbilityType<?, ?>, Ability> getAbilityMap();

        public Ability getAbilityFromType(AbilityType<?, ?> var1);

        public Collection<Ability> getAbilities();

        public Ability getActiveAbility();

        public void setActiveAbility(Ability var1);

        public boolean attackingPrevented();

        public boolean blockBreakingBuildingPrevented();

        public boolean interactingPrevented();

        public boolean itemUsePrevented(ItemStack var1);

        public <E extends GeoEntity> PlayState animationPredicate(AnimationState<E> var1, GeckoPlayer.Perspective var2);

        public void codeAnimations(MowzieGeoModel<? extends GeoEntity> var1, float var2);
    }
}

