/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;

public class LodestoneEntityBlock<T extends LodestoneBlockEntity>
extends Block
implements EntityBlock {
    protected Supplier<BlockEntityType<T>> blockEntityType = null;
    protected BlockEntityTicker<T> ticker = null;

    public LodestoneEntityBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public LodestoneEntityBlock<T> setBlockEntity(Supplier<BlockEntityType<T>> type) {
        this.blockEntityType = type;
        this.ticker = (l, p, s, t) -> t.tick();
        return this;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return this.hasTileEntity(state) ? this.blockEntityType.get().m_155264_(pos, state) : null;
    }

    public boolean hasTileEntity(BlockState state) {
        return this.blockEntityType != null;
    }

    public <Y extends BlockEntity> BlockEntityTicker<Y> m_142354_(Level level, BlockState state, BlockEntityType<Y> type) {
        return this.ticker;
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        BlockEntity blockEntity;
        if (this.hasTileEntity(pState) && (blockEntity = pLevel.m_7702_(pPos)) instanceof LodestoneBlockEntity) {
            LodestoneBlockEntity simpleBlockEntity = (LodestoneBlockEntity)blockEntity;
            simpleBlockEntity.onPlace(pPlacer, pStack);
        }
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        LodestoneBlockEntity simpleBlockEntity;
        ItemStack stack;
        BlockEntity blockEntity;
        if (this.hasTileEntity(state) && (blockEntity = world.m_7702_(pos)) instanceof LodestoneBlockEntity && !(stack = (simpleBlockEntity = (LodestoneBlockEntity)blockEntity).onClone(state, target, world, pos, player)).m_41619_()) {
            return stack;
        }
        return super.getCloneItemStack(state, target, world, pos, player);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        this.onBlockBroken(state, (BlockGetter)level, pos, player);
        super.m_5707_(level, pos, state, player);
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        this.onBlockBroken(state, (BlockGetter)level, pos, null);
        super.onBlockExploded(state, level, pos, explosion);
    }

    public void onBlockBroken(BlockState state, BlockGetter level, BlockPos pos, @Nullable Player player) {
        BlockEntity blockEntity;
        if (this.hasTileEntity(state) && (blockEntity = level.m_7702_(pos)) instanceof LodestoneBlockEntity) {
            LodestoneBlockEntity simpleBlockEntity = (LodestoneBlockEntity)blockEntity;
            simpleBlockEntity.onBreak(player);
        }
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        BlockEntity blockEntity;
        if (this.hasTileEntity(pState) && (blockEntity = pLevel.m_7702_(pPos)) instanceof LodestoneBlockEntity) {
            LodestoneBlockEntity simpleBlockEntity = (LodestoneBlockEntity)blockEntity;
            simpleBlockEntity.onEntityInside(pState, pLevel, pPos, pEntity);
        }
        super.m_7892_(pState, pLevel, pPos, pEntity);
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (this.hasTileEntity(pState) && (blockEntity = pLevel.m_7702_(pPos)) instanceof LodestoneBlockEntity) {
            LodestoneBlockEntity simpleBlockEntity = (LodestoneBlockEntity)blockEntity;
            simpleBlockEntity.onNeighborUpdate(pState, pPos, pFromPos);
        }
        super.m_6861_(pState, pLevel, pPos, pBlock, pFromPos, pIsMoving);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        BlockEntity blockEntity;
        if (this.hasTileEntity(state) && (blockEntity = level.m_7702_(pos)) instanceof LodestoneBlockEntity) {
            LodestoneBlockEntity simpleBlockEntity = (LodestoneBlockEntity)blockEntity;
            return simpleBlockEntity.onUse(player, hand);
        }
        return super.m_6227_(state, level, pos, player, hand, ray);
    }
}

