/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.api.rpc;

import com.hypherionmc.simplerpc.api.rpc.ButtonWrapper;
import com.hypherionmc.simplerpc.api.utils.APIUtils;
import com.hypherionmc.simplerpc.api.variables.PlaceholderEngine;
import com.hypherionmc.simplerpc.rpcsdk.enums.ActivityType;
import com.hypherionmc.simplerpc.rpcsdk.models.DiscordRichPresence;
import java.time.OffsetDateTime;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;

public final class RichPresenceBuilder {
    public static OffsetDateTime offsetDateTime = OffsetDateTime.now();
    public static OffsetDateTime rpcTime;
    private List<ButtonWrapper> buttons;
    private final DiscordRichPresence.DiscordRichPresenceBuilder presence;
    private String state = "";
    private String details = "";
    private String largeImage = "";
    private String largeImageText = "";
    private String smallImage = "";
    private String smallImageText = "";
    private ActivityType type = ActivityType.PLAYING;

    public RichPresenceBuilder() {
        this.presence = DiscordRichPresence.builder();
    }

    public RichPresenceBuilder setState(String state) {
        this.state = state;
        return this;
    }

    public RichPresenceBuilder setDetails(String details) {
        this.details = details;
        return this;
    }

    public RichPresenceBuilder setLargeImage(String largeImage) {
        this.largeImage = largeImage;
        return this;
    }

    public RichPresenceBuilder setLargeImageText(String largeImageText) {
        this.largeImageText = largeImageText;
        return this;
    }

    public RichPresenceBuilder setSmallImage(String smallImage) {
        this.smallImage = smallImage;
        return this;
    }

    public RichPresenceBuilder setSmallImageText(String smallImageText) {
        this.smallImageText = smallImageText;
        return this;
    }

    public RichPresenceBuilder setTimeStamp(OffsetDateTime offsetDateTime) {
        rpcTime = offsetDateTime;
        return this;
    }

    public RichPresenceBuilder setButtons(List<ButtonWrapper> buttons) {
        this.buttons = buttons;
        return this;
    }

    public RichPresenceBuilder setType(ActivityType type) {
        this.type = type;
        return this;
    }

    @ApiStatus.Internal
    public DiscordRichPresence getPresence() {
        if (!this.state.isEmpty()) {
            this.presence.state(APIUtils.parseAndLimit(this.state, 128));
        }
        if (!this.details.isEmpty()) {
            this.presence.details(APIUtils.parseAndLimit(this.details, 128));
        }
        if (!this.largeImage.isEmpty()) {
            this.presence.largeImageKey(PlaceholderEngine.INSTANCE.resolvePlaceholders(this.largeImage));
            if (!this.largeImageText.isEmpty()) {
                this.presence.largeImageText(APIUtils.parseAndLimit(this.largeImageText, 128));
            }
        }
        if (!this.smallImage.isEmpty()) {
            this.presence.smallImageKey(PlaceholderEngine.INSTANCE.resolvePlaceholders(this.smallImage));
            if (!this.smallImageText.isEmpty()) {
                this.presence.smallImageText(APIUtils.parseAndLimit(this.smallImageText, 128));
            }
        }
        if (this.buttons != null && !this.buttons.isEmpty()) {
            int length = Math.min(this.buttons.size(), 2);
            this.presence.buttons(this.buttons.subList(0, length).stream().map(ButtonWrapper::rpcButton).toList());
        }
        this.presence.startTimestamp(offsetDateTime.toEpochSecond());
        this.presence.activityType(this.type);
        return this.presence.build();
    }

    @Generated
    public List<ButtonWrapper> getButtons() {
        return this.buttons;
    }

    @Generated
    public String getState() {
        return this.state;
    }

    @Generated
    public String getDetails() {
        return this.details;
    }

    @Generated
    public String getLargeImage() {
        return this.largeImage;
    }

    @Generated
    public String getLargeImageText() {
        return this.largeImageText;
    }

    @Generated
    public String getSmallImage() {
        return this.smallImage;
    }

    @Generated
    public String getSmallImageText() {
        return this.smallImageText;
    }

    @Generated
    public ActivityType getType() {
        return this.type;
    }
}

