/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.worldgen;

import com.mojang.serialization.Codec;
import java.util.Set;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.Nullable;

public class ProcessFarmProcessor
extends StructureProcessor {
    private static final ProcessFarmProcessor INSTANCE = new ProcessFarmProcessor();
    public static final Codec<ProcessFarmProcessor> CODEC = Codec.unit((Object)((Object)INSTANCE));
    @Nullable
    private final BlockState copperLantern;
    private final Set<Block> validBlocks;
    private BlockPos lastPos = BlockPos.f_121853_;
    private boolean lastPlaced = false;

    public ProcessFarmProcessor() {
        this.copperLantern = BuiltInRegistries.f_256975_.m_6612_(new ResourceLocation("suppsquared:copper_lantern")).map(c -> (BlockState)((BlockState)c.m_49966_().m_61124_((Property)LanternBlock.f_153459_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false))).orElse(null);
        this.validBlocks = Set.of(Blocks.f_50705_, Blocks.f_50086_, Blocks.f_50398_, Blocks.f_50301_, Blocks.f_50010_, Blocks.f_49999_);
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader level, BlockPos arg2, BlockPos pos, StructureTemplate.StructureBlockInfo blockInfo, StructureTemplate.StructureBlockInfo relativeBlockInfo, StructurePlaceSettings settings) {
        BlockPos blockPos = relativeBlockInfo.f_74675_();
        BlockState replace = null;
        replace = this.maybeReplaceLantern(relativeBlockInfo, settings, blockPos);
        if (replace == null) {
            replace = this.maybePlaceCobweb(relativeBlockInfo, settings);
        }
        if (replace == null) {
            replace = this.maybePlaceMoss(relativeBlockInfo, settings);
        }
        return replace != null ? new StructureTemplate.StructureBlockInfo(blockPos, replace, relativeBlockInfo.f_74677_()) : relativeBlockInfo;
    }

    private BlockState maybePlaceMoss(StructureTemplate.StructureBlockInfo relativeBlockInfo, StructurePlaceSettings settings) {
        RandomSource randomSource;
        BlockState replace = null;
        if (relativeBlockInfo.f_74676_().m_60713_(Blocks.f_50652_) && (double)(randomSource = settings.m_230326_(relativeBlockInfo.f_74675_())).m_188501_() < 0.25) {
            replace = Blocks.f_50079_.m_49966_();
        }
        return replace;
    }

    private BlockState maybeReplaceLantern(StructureTemplate.StructureBlockInfo relativeBlockInfo, StructurePlaceSettings settings, BlockPos blockPos) {
        BlockState replace = null;
        if (relativeBlockInfo.f_74676_().m_60713_(Blocks.f_50681_)) {
            RandomSource randomSource = settings.m_230326_(relativeBlockInfo.f_74675_());
            if (blockPos.m_123314_((Vec3i)this.lastPos, 10.0)) {
                if (this.lastPlaced) {
                    this.lastPlaced = false;
                    replace = Blocks.f_50016_.m_49966_();
                } else if (this.copperLantern != null) {
                    replace = this.copperLantern.m_60717_(settings.m_74404_());
                }
            } else if (randomSource.m_188499_()) {
                this.lastPlaced = true;
                if (this.copperLantern != null) {
                    replace = this.copperLantern.m_60717_(settings.m_74404_());
                }
            } else {
                this.lastPlaced = false;
                replace = Blocks.f_50016_.m_49966_();
            }
            this.lastPos = blockPos;
        }
        return replace;
    }

    private BlockState maybePlaceCobweb(StructureTemplate.StructureBlockInfo relativeBlockInfo, StructurePlaceSettings settings) {
        RandomSource randomSource;
        BlockState replace = null;
        if (this.validBlocks.contains(relativeBlockInfo.f_74676_().m_60734_()) && (double)(randomSource = settings.m_230326_(relativeBlockInfo.f_74675_())).m_188501_() < 0.07) {
            replace = Blocks.f_50033_.m_49966_();
        }
        return replace;
    }

    protected StructureProcessorType<?> m_6953_() {
        return ModRegistry.FARM_PROCESSOR.get();
    }
}

