/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.mehvahdjukaar.hauntedharvest.CustomCarvingsManager;
import net.mehvahdjukaar.hauntedharvest.blocks.AbstractCornBlock;
import net.mehvahdjukaar.hauntedharvest.configs.CommonConfigs;
import net.mehvahdjukaar.hauntedharvest.integration.CompatHandler;
import net.mehvahdjukaar.hauntedharvest.integration.FDCompat;
import net.mehvahdjukaar.hauntedharvest.integration.SuppCompat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public class FarmFieldFeature
extends Feature<Config> {
    public FarmFieldFeature(Codec<Config> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<Config> context) {
        Config config = (Config)context.m_159778_();
        RandomSource random = context.m_225041_();
        BlockPos blockPos = context.m_159777_();
        WorldGenLevel level = context.m_159774_();
        CropType crop = config.crop();
        if (!crop.isEnabled()) {
            return false;
        }
        boolean scarecrow = config.scarecrow();
        if (scarecrow) {
            this.placeScarecrow(blockPos, level, random);
        }
        int i = 0;
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        int j = config.xzSpread() + 1;
        int k = config.ySpread() + 1;
        block5: for (int l = 0; l < config.tries(); ++l) {
            p.m_122154_((Vec3i)blockPos, random.m_188503_(j) - random.m_188503_(j), random.m_188503_(k) - random.m_188503_(k), random.m_188503_(j) - random.m_188503_(j));
            if (!level.m_8055_(p.m_7495_()).m_204336_(BlockTags.f_144274_)) continue;
            switch (crop.ordinal()) {
                default: {
                    if (!this.placePumpkin(p, level, random)) continue block5;
                    break;
                }
                case 1: {
                    if (!this.placeCorn(p, level, random)) continue block5;
                    break;
                }
                case 2: {
                    if (!SuppCompat.placeFlax(p, level, random)) continue block5;
                    break;
                }
                case 3: {
                    if (!this.placeTomatoes(p, level, random)) continue block5;
                }
            }
            level.m_7731_(p.m_7495_(), Blocks.f_50093_.m_49966_(), 2);
            ++i;
        }
        return i > 0;
    }

    private boolean placeTomatoes(BlockPos.MutableBlockPos p, WorldGenLevel level, RandomSource random) {
        if (level.m_8055_((BlockPos)p).m_60795_()) {
            level.m_7731_((BlockPos)p, FDCompat.getTomato(random), 2);
            return true;
        }
        return false;
    }

    private void placeScarecrow(BlockPos blockPos, WorldGenLevel level, RandomSource random) {
        level.m_7731_(blockPos, Blocks.f_50479_.m_49966_(), 2);
        BlockPos above = blockPos.m_7494_();
        Direction dir = Direction.Plane.HORIZONTAL.m_235690_(random);
        level.m_7731_(above, Blocks.f_50335_.m_49966_(), 3);
        BlockPos left = above.m_121945_(dir);
        level.m_7731_(left, Block.m_49931_((BlockState)Blocks.f_50479_.m_49966_(), (LevelAccessor)level, (BlockPos)left), 2);
        BlockPos right = above.m_121945_(dir.m_122424_());
        level.m_7731_(right, Block.m_49931_((BlockState)Blocks.f_50479_.m_49966_(), (LevelAccessor)level, (BlockPos)right), 2);
        CustomCarvingsManager.placeRandomPumpkin(above.m_7494_(), (LevelAccessor)level, dir.m_122427_(), true, 0.2f, 0.15f, 2);
    }

    private boolean placeCorn(BlockPos.MutableBlockPos pos, WorldGenLevel level, RandomSource random) {
        int age = random.m_188503_(7);
        return AbstractCornBlock.spawn((BlockPos)pos, (LevelAccessor)level, age);
    }

    private boolean placePumpkin(BlockPos.MutableBlockPos pos, WorldGenLevel level, RandomSource random) {
        Direction dir = Direction.Plane.HORIZONTAL.m_235690_(random);
        BlockPos pumpkinPos = pos.m_121945_(dir);
        if (level.m_8055_((BlockPos)pos).m_60795_()) {
            if (random.m_188499_()) {
                if (level.m_8055_(pumpkinPos).m_60795_() && level.m_8055_(pumpkinPos.m_7495_()).m_204336_(BlockTags.f_144274_)) {
                    level.m_7731_(pumpkinPos, Blocks.f_50133_.m_49966_(), 2);
                    level.m_7731_((BlockPos)pos, (BlockState)Blocks.f_50187_.m_49966_().m_61124_((Property)AttachedStemBlock.f_48830_, (Comparable)dir), 2);
                    return true;
                }
            } else {
                level.m_7731_((BlockPos)pos, (BlockState)Blocks.f_50189_.m_49966_().m_61124_((Property)StemBlock.f_57013_, (Comparable)Integer.valueOf(random.m_188503_(8))), 2);
                return true;
            }
        }
        return false;
    }

    public record Config(int tries, int xzSpread, int ySpread, CropType crop, boolean scarecrow) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.f_144629_.fieldOf("tries").orElse((Object)64).forGetter(Config::tries), (App)ExtraCodecs.f_144628_.fieldOf("xz_spread").orElse((Object)7).forGetter(Config::xzSpread), (App)ExtraCodecs.f_144628_.fieldOf("y_spread").orElse((Object)3).forGetter(Config::ySpread), (App)StringRepresentable.m_216439_(CropType::values).fieldOf("crop").forGetter(Config::crop), (App)Codec.BOOL.optionalFieldOf("has_scarecrow", (Object)false).forGetter(Config::scarecrow)).apply((Applicative)instance, Config::new));
    }

    public static enum CropType implements StringRepresentable
    {
        PUMPKIN,
        CORN,
        FLAX,
        TOMATOES;


        public boolean isEnabled() {
            return switch (this.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 1 -> CommonConfigs.CORN_ENABLED.get();
                case 2 -> {
                    if (CompatHandler.SUPP_INSTALLED && SuppCompat.isFlaxOn()) {
                        yield true;
                    }
                    yield false;
                }
                case 0 -> true;
                case 3 -> CompatHandler.FD_INSTALLED;
            };
        }

        public String m_7912_() {
            return this.toString().toLowerCase(Locale.ROOT);
        }
    }
}

