/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.mixins;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.mehvahdjukaar.hauntedharvest.ai.HalloweenVillagerAI;
import net.mehvahdjukaar.hauntedharvest.ai.IHalloweenVillager;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Villager.class})
public abstract class VillagerMixin
extends AbstractVillager
implements IHalloweenVillager {
    @Unique
    private final Map<UUID, Integer> hauntedharvest$adultCandyCooldown = new ConcurrentHashMap<UUID, Integer>();
    @Unique
    private int hauntedharvest$conversionTime = -1;

    protected VillagerMixin(EntityType<? extends AbstractVillager> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    public abstract Brain<Villager> m_6274_();

    @Inject(method={"customServerAiStep"}, at={@At(value="RETURN")})
    protected void customServerAiStep(CallbackInfo ci) {
        for (Map.Entry<UUID, Integer> e : this.hauntedharvest$adultCandyCooldown.entrySet()) {
            UUID id = e.getKey();
            Integer i = e.getValue();
            if (i <= 0) {
                this.hauntedharvest$adultCandyCooldown.remove(id);
                continue;
            }
            this.hauntedharvest$adultCandyCooldown.put(id, i - 1);
        }
    }

    @Override
    public boolean hauntedharvest$isEntityOnCooldown(Entity e) {
        return this.hauntedharvest$adultCandyCooldown.containsKey(e.m_20148_());
    }

    @Override
    public void hauntedharvest$setEntityOnCooldown(Entity e) {
        this.hauntedharvest$setEntityOnCooldown(e, 50);
    }

    @Override
    public void hauntedharvest$setEntityOnCooldown(Entity e, int cooldownSec) {
        this.hauntedharvest$adultCandyCooldown.put(e.m_20148_(), 20 * (cooldownSec + e.m_9236_().f_46441_.m_188503_(20)));
    }

    @Inject(method={"wantsToPickUp"}, at={@At(value="HEAD")}, cancellable=true)
    protected void wantsToPickUp(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        if (HalloweenVillagerAI.isTrickOrTreater((LivingEntity)this) && HalloweenVillagerAI.isCandyOrApple(stack)) {
            cir.setReturnValue((Object)true);
        }
    }

    public void m_21053_(ItemEntity itemEntity) {
        super.m_21053_(itemEntity);
        if (HalloweenVillagerAI.isTrickOrTreater((LivingEntity)this) && HalloweenVillagerAI.isCandyOrApple(itemEntity.m_32055_())) {
            this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            if (!this.m_9236_().f_46443_) {
                this.m_9236_().m_7605_((Entity)this, (byte)14);
            }
        }
    }

    @Override
    public void hauntedharvest$startConverting() {
        if (!this.hauntedharvest$isConverting()) {
            this.hauntedharvest$conversionTime = 1200;
            this.m_9236_().m_7605_((Entity)this, (byte)16);
            this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 1200, 2));
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    public void addAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        GlobalPos globalpos;
        tag.m_128405_("ConversionTime", this.hauntedharvest$conversionTime);
        if (this.m_6274_().m_21874_(ModRegistry.PUMPKIN_POS.get()) && (globalpos = (GlobalPos)this.m_6274_().m_21952_(ModRegistry.PUMPKIN_POS.get()).get()).m_122640_() == this.m_9236_().m_46472_()) {
            tag.m_128365_("Pumpkin", (Tag)NbtUtils.m_129224_((BlockPos)globalpos.m_122646_()));
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    public void readAdditionalSaveData(CompoundTag compoundNBT, CallbackInfo ci) {
        this.hauntedharvest$conversionTime = compoundNBT.m_128451_("ConversionTime");
        if (compoundNBT.m_128441_("Pumpkin")) {
            try {
                this.m_6274_().m_21879_(ModRegistry.PUMPKIN_POS.get(), (Object)GlobalPos.m_122643_((ResourceKey)this.m_9236_().m_46472_(), (BlockPos)NbtUtils.m_129239_((CompoundTag)compoundNBT.m_128469_("Pumpkin"))));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean hauntedharvest$isConverting() {
        return this.hauntedharvest$conversionTime > 0;
    }

    @Unique
    private void doWitchConversion() {
        float yBodyRot = this.f_20883_;
        float yHeadRot = this.f_20885_;
        float yBodyRotO = this.f_20884_;
        float yHeadRotO = this.f_20886_;
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            double d0;
            ItemStack itemstack = this.m_6844_(equipmentSlot);
            if (!itemstack.m_41619_() && (d0 = (double)this.m_21519_(equipmentSlot)) > 1.0) {
                this.m_19983_(itemstack);
            }
            this.m_8061_(equipmentSlot, ItemStack.f_41583_);
        }
        Witch witch = (Witch)this.m_21406_(EntityType.f_20495_, true);
        if (witch != null) {
            witch.f_20883_ = yBodyRot;
            witch.f_20885_ = yHeadRot;
            witch.f_20886_ = yHeadRotO;
            witch.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 0));
            ForgeHelper.onLivingConvert((LivingEntity)this, (LivingEntity)witch);
        }
        if (!this.m_20067_()) {
            this.m_9236_().m_5898_(null, 1027, this.m_20183_(), 0);
        }
    }

    @Inject(method={"handleEntityEvent"}, at={@At(value="HEAD")}, cancellable=true)
    public void handleEntityEvent(byte pId, CallbackInfo ci) {
        if (pId == 16) {
            this.hauntedharvest$conversionTime = 1200;
            if (!this.m_20067_()) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20188_(), this.m_20189_(), SoundEvents.f_12644_, this.m_5720_(), 1.0f + this.f_19796_.m_188501_(), this.f_19796_.m_188501_() * 0.7f + 0.3f, false);
            }
            ci.cancel();
        } else if (pId == 26) {
            if (this.m_20089_() == Pose.SLEEPING) {
                this.m_35287_((ParticleOptions)ParticleTypes.f_123792_);
            }
            ci.cancel();
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void tick(CallbackInfo ci) {
        if (!this.m_9236_().f_46443_ && this.m_6084_() && !this.m_21525_() && this.hauntedharvest$isConverting()) {
            --this.hauntedharvest$conversionTime;
            if (this.hauntedharvest$conversionTime == 0) {
                this.doWitchConversion();
            }
        }
    }

    @Inject(method={"mobInteract"}, at={@At(value="HEAD")}, cancellable=true)
    public void interact(Player pPlayer, InteractionHand pHand, CallbackInfoReturnable<InteractionResult> cir) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (itemstack.m_150930_(Items.f_42455_) && this.hauntedharvest$isConverting()) {
            this.hauntedharvest$conversionTime = -1;
            Level level = this.m_9236_();
            itemstack.m_41671_(level, (LivingEntity)this);
            this.m_5584_(level, itemstack);
            pPlayer.m_21008_(pHand, new ItemStack((ItemLike)Items.f_42446_));
            cir.cancel();
            cir.setReturnValue((Object)InteractionResult.m_19078_((boolean)level.f_46443_));
        }
    }
}

