/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import net.mehvahdjukaar.hauntedharvest.HauntedHarvest;
import net.mehvahdjukaar.hauntedharvest.blocks.ModCarvedPumpkinBlockTile;
import net.mehvahdjukaar.hauntedharvest.blocks.PumpkinType;
import net.mehvahdjukaar.hauntedharvest.client.PumpkinTextureGenerator;
import net.mehvahdjukaar.moonlight.api.client.texture_renderer.FrameBufferBackedDynamicTexture;
import net.mehvahdjukaar.moonlight.api.client.texture_renderer.RenderedTexturesManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import org.jetbrains.annotations.Nullable;
import oshi.annotation.concurrent.Immutable;

public class CarvingManager
implements PreparableReloadListener {
    public static final CarvingManager INSTANCE = new CarvingManager();
    private static final LoadingCache<Key, Carving> TEXTURE_CACHE = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).removalListener(i -> {
        Carving value = (Carving)i.getValue();
        if (value != null) {
            RenderSystem.recordRenderCall(value::close);
        }
    }).build((CacheLoader)new CacheLoader<Key, Carving>(){

        public Carving load(Key key) {
            return null;
        }
    });
    private static Carving currentCarvingBlur = null;
    private static FrameBufferBackedDynamicTexture pumpkinBlur = null;

    public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier preparationBarrier, ResourceManager resourceManager, ProfilerFiller profilerFiller, ProfilerFiller profilerFiller2, Executor executor, Executor executor2) {
        Objects.requireNonNull(preparationBarrier);
        return ((CompletableFuture)CompletableFuture.completedFuture(null).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)preparationBarrier).m_6769_(arg_0))).thenAcceptAsync(preparation -> CarvingManager.onTextureReload(), executor2);
    }

    public static Carving getInstance(Key key) {
        Carving textureInstance = (Carving)TEXTURE_CACHE.getIfPresent((Object)key);
        if (textureInstance == null) {
            textureInstance = new Carving(ModCarvedPumpkinBlockTile.unpackPixels(key.values), key.type);
            TEXTURE_CACHE.put((Object)key, (Object)textureInstance);
        }
        return textureInstance;
    }

    @Nullable
    public static ResourceLocation getCachedBlurTexture(Carving carving) {
        if (pumpkinBlur == null) {
            RenderedTexturesManager.requestTexture((ResourceLocation)HauntedHarvest.res("pumpkinblur"), (int)512, t -> {
                PumpkinTextureGenerator.drawBlur(t, carving);
                pumpkinBlur = t;
            }, (boolean)false);
            return null;
        }
        if (carving != currentCarvingBlur) {
            PumpkinTextureGenerator.drawBlur(pumpkinBlur, carving);
        }
        currentCarvingBlur = carving;
        return pumpkinBlur.getTextureLocation();
    }

    public static void onTextureReload() {
        if (pumpkinBlur != null) {
            pumpkinBlur.close();
            pumpkinBlur = null;
        }
    }

    public static class Carving
    implements AutoCloseable {
        public static final int WIDTH = 16;
        private final Map<Direction, List<BakedQuad>> quadsCache = new EnumMap<Direction, List<BakedQuad>>(Direction.class);
        private final boolean[][] pixels;
        private final PumpkinType type;
        @Nullable
        private DynamicTexture texture;
        @Nullable
        private RenderType renderType;
        @Nullable
        private ResourceLocation textureLocation;

        private Carving(boolean[][] pixels, PumpkinType type) {
            this.pixels = pixels;
            this.type = type;
        }

        public boolean[][] getPixels() {
            return this.pixels;
        }

        public PumpkinType getType() {
            return this.type;
        }

        private void initializeTexture() {
            this.texture = new DynamicTexture(16, 16, false);
            PumpkinTextureGenerator.drawCarving(this.texture, this);
            this.textureLocation = Minecraft.m_91087_().m_91097_().m_118490_("carving/", this.texture);
            this.renderType = RenderType.m_110446_((ResourceLocation)this.textureLocation);
        }

        public List<BakedQuad> getOrCreateModel(Direction dir, BiFunction<Carving, Direction, List<BakedQuad>> modelFactory) {
            return this.quadsCache.computeIfAbsent(dir, d -> (List)modelFactory.apply(this, (Direction)d));
        }

        public ResourceLocation getTextureLocation() {
            if (this.textureLocation == null) {
                this.initializeTexture();
            }
            return this.textureLocation;
        }

        @Nullable
        public ResourceLocation getPumpkinBlur() {
            return CarvingManager.getCachedBlurTexture(this);
        }

        public RenderType getRenderType() {
            if (this.renderType == null) {
                this.initializeTexture();
            }
            return this.renderType;
        }

        @Override
        public void close() {
            if (this.texture != null) {
                this.texture.close();
            }
            if (this.textureLocation != null) {
                Minecraft.m_91087_().m_91097_().m_118513_(this.textureLocation);
            }
        }
    }

    @Immutable
    public static class Key
    implements TooltipComponent {
        private final long[] values;
        private final PumpkinType type;

        Key(long[] packed, PumpkinType type) {
            this.values = packed;
            this.type = type;
        }

        public static Key of(long[] packPixels, PumpkinType glowing) {
            return new Key(packPixels, glowing);
        }

        public static Key of(long[] packPixels) {
            return new Key(packPixels, PumpkinType.NORMAL);
        }

        public boolean equals(Object another) {
            if (another == this) {
                return true;
            }
            if (another == null) {
                return false;
            }
            if (another.getClass() != this.getClass()) {
                return false;
            }
            Key key = (Key)another;
            return Arrays.equals(this.values, key.values) && this.type == key.type;
        }

        public int hashCode() {
            return Arrays.hashCode(this.values);
        }
    }
}

