/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.blocks;

import java.util.UUID;
import net.mehvahdjukaar.hauntedharvest.blocks.ModCarvedPumpkinBlock;
import net.mehvahdjukaar.hauntedharvest.blocks.PumpkinType;
import net.mehvahdjukaar.hauntedharvest.client.CarvingManager;
import net.mehvahdjukaar.hauntedharvest.client.gui.CarvingGui;
import net.mehvahdjukaar.hauntedharvest.configs.CommonConfigs;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.block.IOwnerProtected;
import net.mehvahdjukaar.moonlight.api.client.IScreenProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.IExtraModelDataProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class ModCarvedPumpkinBlockTile
extends BlockEntity
implements IOwnerProtected,
IScreenProvider,
IExtraModelDataProvider {
    public static final ModelDataKey<CarvingManager.Key> CARVING = new ModelDataKey(CarvingManager.Key.class);
    private UUID owner = null;
    private boolean waxed = false;
    private boolean[][] pixels = new boolean[16][16];
    private CarvingManager.Key textureKey = null;

    public ModCarvedPumpkinBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.MOD_CARVED_PUMPKIN_TILE.get(), pos, state);
        this.clear();
    }

    public PumpkinType getPumpkinType() {
        BlockState state = this.m_58900_();
        return ((ModCarvedPumpkinBlock)state.m_60734_()).getType(state);
    }

    public ExtraModelData getExtraModelData() {
        return ExtraModelData.builder().with(CARVING, (Object)this.getTextureKey()).build();
    }

    public CarvingManager.Key getTextureKey() {
        if (this.textureKey == null) {
            this.refreshTextureKey();
        }
        return this.textureKey;
    }

    public void refreshTextureKey() {
        this.textureKey = CarvingManager.Key.of(ModCarvedPumpkinBlockTile.packPixels(this.pixels), this.getPumpkinType());
    }

    public void afterDataPacket(ExtraModelData oldData) {
        this.refreshTextureKey();
        super.afterDataPacket(oldData);
    }

    public void m_6596_() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        super.m_6596_();
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.loadOwner(compound);
        this.waxed = compound.m_128441_("Waxed") && compound.m_128471_("Waxed");
        this.acceptPixels(compound.m_128467_("Pixels"));
    }

    public void acceptPixels(long[] p) {
        this.pixels = new boolean[16][16];
        if (p.length != 0) {
            this.pixels = ModCarvedPumpkinBlockTile.unpackPixels(p);
        }
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.savePixels(compound);
        this.saveOwner(compound);
    }

    public CompoundTag savePixels(CompoundTag compound) {
        if (this.waxed) {
            compound.m_128379_("Waxed", true);
        }
        compound.m_128388_("Pixels", ModCarvedPumpkinBlockTile.packPixels(this.pixels));
        return compound;
    }

    public static long[] packPixels(boolean[][] pixels) {
        long[] packed = new long[4];
        long n = 0L;
        int ind = 0;
        for (int a = 0; a < pixels.length; ++a) {
            int s = 0;
            for (int i = 0; i < pixels.length; ++i) {
                s |= (ModCarvedPumpkinBlockTile.toShort(pixels[a][i]) & 1) << i;
            }
            n |= (long)s << a % 4 * 16;
            if ((a + 1) % 4 != 0) continue;
            packed[ind] = n;
            n = 0L;
            ++ind;
        }
        return packed;
    }

    private static short toShort(boolean b) {
        return (short)(b ? 1 : 0);
    }

    private static boolean toBoolean(short b) {
        return b == 1;
    }

    public static boolean[][] unpackPixels(long[] packed) {
        boolean[][] bytes = new boolean[16][16];
        int k = 0;
        for (long l : packed) {
            for (int j = 0; j < 4; ++j) {
                for (int i = 0; i < 16; ++i) {
                    bytes[k][i] = ModCarvedPumpkinBlockTile.toBoolean((short)(l >> i + j * 16 & 1L));
                }
                ++k;
            }
        }
        return bytes;
    }

    public void clear() {
        for (int x = 0; x < this.pixels.length; ++x) {
            for (int y = 0; y < this.pixels[x].length; ++y) {
                this.pixels[x][y] = false;
            }
        }
    }

    public boolean isEmpty() {
        boolean[][] blArray = this.pixels;
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            boolean[] pixel;
            for (boolean b : pixel = blArray[i]) {
                if (!b) continue;
                return false;
            }
        }
        return true;
    }

    public void setPixel(int x, int y, boolean b) {
        this.pixels[x][y] = b;
    }

    public boolean getPixel(int xx, int yy) {
        return this.pixels[xx][yy];
    }

    public void setPixels(boolean[][] pixels) {
        this.pixels = pixels;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public Direction getDirection() {
        return (Direction)this.m_58900_().m_61143_((Property)ModCarvedPumpkinBlock.f_51367_);
    }

    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public void openScreen(Level level, BlockPos pos, Player player) {
        CarvingGui.open(this, player.m_6350_().m_122424_());
    }

    public void setWaxed(boolean b) {
        this.waxed = b;
    }

    public boolean isWaxed() {
        return this.waxed;
    }

    public ModCarvedPumpkinBlock.CarveMode getCarveMode() {
        if (this.getPumpkinType().isJackOLantern()) {
            return CommonConfigs.JACK_O_LANTERN_CARVE_MODE.get();
        }
        return CommonConfigs.PUMPKIN_CARVE_MODE.get();
    }

    public ItemStack getItemWithNBT() {
        CompoundTag tag;
        ItemStack itemstack = new ItemStack((ItemLike)this.m_58900_().m_60734_());
        if (!this.isEmpty() && !(tag = this.savePixels(new CompoundTag())).m_128456_()) {
            itemstack.m_41700_("BlockEntityTag", (Tag)tag);
        }
        return itemstack;
    }
}

