/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.blocks;

import java.util.function.Predicate;
import net.mehvahdjukaar.hauntedharvest.HHPlatformStuff;
import net.mehvahdjukaar.hauntedharvest.blocks.ModCarvedPumpkinBlockTile;
import net.mehvahdjukaar.hauntedharvest.blocks.PumpkinType;
import net.mehvahdjukaar.hauntedharvest.reg.ModTags;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public class ModCarvedPumpkinBlock
extends CarvedPumpkinBlock
implements EntityBlock {
    private final PumpkinType type;
    private static final Predicate<BlockState> PUMPKINS_PREDICATE = blockState -> blockState != null && blockState.m_60734_() instanceof ModCarvedPumpkinBlock;
    private static final BlockPattern SNOW_GOLEM_FULL = BlockPatternBuilder.m_61243_().m_61247_(new String[]{"^", "#", "#"}).m_61244_('^', BlockInWorld.m_61169_(PUMPKINS_PREDICATE)).m_61244_('#', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)Blocks.f_50127_))).m_61249_();

    public ModCarvedPumpkinBlock(BlockBehaviour.Properties properties, PumpkinType type) {
        super(properties);
        this.type = type;
    }

    public PumpkinType getType(BlockState state) {
        return this.type;
    }

    public static Vector2i getHitSubPixel(BlockHitResult hit) {
        Vec3 pos = hit.m_82450_();
        Vec3 v = pos.m_82524_((float)((double)hit.m_82434_().m_122435_() * Math.PI / 180.0));
        double fx = v.f_82479_ % 1.0 * 16.0;
        if (fx < 0.0) {
            fx += 16.0;
        }
        int x = Mth.m_14045_((int)((int)fx), (int)-15, (int)15);
        int y = 15 - (int)Mth.m_14008_((double)Math.abs(v.f_82480_ % 1.0 * 16.0), (double)0.0, (double)15.0);
        if (pos.f_82480_ < 0.0) {
            y = 15 - y;
        }
        return new Vector2i(x, y);
    }

    public static boolean isCarverItem(ItemStack stack) {
        return stack.m_204117_(ModTags.CARVERS) || stack.m_41720_() instanceof SwordItem;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ModCarvedPumpkinBlockTile te;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ModCarvedPumpkinBlockTile && (te = (ModCarvedPumpkinBlockTile)blockEntity).isAccessibleBy(player) && !te.isWaxed()) {
            ItemStack stack = player.m_21120_(handIn);
            Item i = stack.m_41720_();
            if (i instanceof HoneycombItem) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, stack);
                }
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                level.m_5898_(player, 3003, pos, 0);
                te.setWaxed(true);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            CarveMode mode = te.getCarveMode();
            if (mode != CarveMode.NONE) {
                if (hit.m_82434_() == state.m_61143_((Property)f_51367_) && mode.canManualDraw() && ModCarvedPumpkinBlock.isCarverItem(stack)) {
                    int y;
                    int x;
                    Vector2i v = ModCarvedPumpkinBlock.getHitSubPixel(hit);
                    te.setPixel(x, y, !te.getPixel(x = v.x(), y = v.y()));
                    te.m_6596_();
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
                if (!level.f_46443_ && mode.canOpenGui()) {
                    te.sendOpenGuiPacket(level, pos, player);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new ModCarvedPumpkinBlockTile(pPos, pState);
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ModCarvedPumpkinBlockTile) {
            ModCarvedPumpkinBlockTile te = (ModCarvedPumpkinBlockTile)blockEntity;
            return te.getItemWithNBT();
        }
        return super.m_7397_(level, pos, state);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.m_60713_(state.m_60734_())) {
            this.trySpawnGolemWithCustomPumpkin(level, pos);
        }
    }

    protected void trySpawnGolemWithCustomPumpkin(Level level, BlockPos pos) {
        block8: {
            BlockPattern.BlockPatternMatch blockPatternMatch;
            block7: {
                blockPatternMatch = SNOW_GOLEM_FULL.m_61184_((LevelReader)level, pos);
                if (blockPatternMatch == null) break block7;
                SnowGolem snowGolem = (SnowGolem)EntityType.f_20528_.m_20615_(level);
                BlockEntity blockEntity = level.m_7702_(pos);
                if (blockEntity instanceof ModCarvedPumpkinBlockTile) {
                    ModCarvedPumpkinBlockTile tile = (ModCarvedPumpkinBlockTile)blockEntity;
                    HHPlatformStuff.addPumpkinData(tile, snowGolem);
                }
                for (int i = 0; i < SNOW_GOLEM_FULL.m_61202_(); ++i) {
                    BlockInWorld blockInWorld = blockPatternMatch.m_61229_(0, i, 0);
                    level.m_7731_(blockInWorld.m_61176_(), Blocks.f_50016_.m_49966_(), 2);
                    level.m_46796_(2001, blockInWorld.m_61176_(), Block.m_49956_((BlockState)blockInWorld.m_61168_()));
                }
                BlockPos blockPos = blockPatternMatch.m_61229_(0, 2, 0).m_61176_();
                ModCarvedPumpkinBlock.spawnToLocation(level, blockPos, (AbstractGolem)snowGolem);
                for (int j = 0; j < SNOW_GOLEM_FULL.m_61202_(); ++j) {
                    BlockInWorld blockInWorld2 = blockPatternMatch.m_61229_(0, j, 0);
                    level.m_6289_(blockInWorld2.m_61176_(), Blocks.f_50016_);
                }
                break block8;
            }
            blockPatternMatch = this.m_51397_().m_61184_((LevelReader)level, pos);
            if (blockPatternMatch == null) break block8;
            for (int i = 0; i < this.m_51397_().m_61203_(); ++i) {
                for (int k = 0; k < this.m_51397_().m_61202_(); ++k) {
                    BlockInWorld blockInWorld3 = blockPatternMatch.m_61229_(i, k, 0);
                    level.m_7731_(blockInWorld3.m_61176_(), Blocks.f_50016_.m_49966_(), 2);
                    level.m_46796_(2001, blockInWorld3.m_61176_(), Block.m_49956_((BlockState)blockInWorld3.m_61168_()));
                }
            }
            BlockPos blockPos2 = blockPatternMatch.m_61229_(1, 2, 0).m_61176_();
            IronGolem ironGolem = (IronGolem)EntityType.f_20460_.m_20615_(level);
            ironGolem.m_28887_(true);
            ModCarvedPumpkinBlock.spawnToLocation(level, blockPos2, (AbstractGolem)ironGolem);
            for (int j = 0; j < this.m_51397_().m_61203_(); ++j) {
                for (int l = 0; l < this.m_51397_().m_61202_(); ++l) {
                    BlockInWorld blockInWorld4 = blockPatternMatch.m_61229_(j, l, 0);
                    level.m_6289_(blockInWorld4.m_61176_(), Blocks.f_50016_);
                }
            }
        }
    }

    private static void spawnToLocation(Level level, BlockPos blockPos2, AbstractGolem ironGolem) {
        ironGolem.m_7678_((double)blockPos2.m_123341_() + 0.5, (double)blockPos2.m_123342_() + 0.05, (double)blockPos2.m_123343_() + 0.5, 0.0f, 0.0f);
        level.m_7967_((Entity)ironGolem);
        for (ServerPlayer serverPlayer : level.m_45976_(ServerPlayer.class, ironGolem.m_20191_().m_82400_(5.0))) {
            CriteriaTriggers.f_10580_.m_68256_(serverPlayer, (Entity)ironGolem);
        }
    }

    public static enum CarveMode {
        NONE,
        BOTH,
        GUI,
        MANUAL;


        public boolean canOpenGui() {
            return this != MANUAL && this != NONE;
        }

        public boolean canManualDraw() {
            return this != GUI && this != NONE;
        }
    }
}

