/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.blocks;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.mehvahdjukaar.hauntedharvest.blocks.CandyBagTile;
import net.mehvahdjukaar.hauntedharvest.blocks.PaperBagBlock;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.mehvahdjukaar.hauntedharvest.reg.ModTags;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CandyBagBlock
extends Block
implements EntityBlock {
    public static final EnumProperty<Content> CONTENT = EnumProperty.m_61587_((String)"content", Content.class);
    public static final IntegerProperty FILL_LEVEL = IntegerProperty.m_61631_((String)"fill_level", (int)1, (int)6);
    private static final int POPCORN_COOK_TIME = 200;

    public CandyBagBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(CONTENT, (Comparable)((Object)Content.POPCORN))).m_61124_((Property)FILL_LEVEL, (Comparable)Integer.valueOf(1)));
    }

    public static boolean tryFilling(Player player, Level level, BlockPos pos, ItemStack stack) {
        Content content = Content.get(stack);
        if (content != null) {
            BlockEntity blockEntity;
            ItemStack remove = player.m_7500_() ? stack.m_41777_() : stack.m_41620_(1);
            remove.m_41764_(1);
            BlockState state = (BlockState)ModRegistry.CANDY_BAG.get().m_49966_().m_61124_(CONTENT, (Comparable)((Object)content));
            level.m_46597_(pos, state);
            CandyBagBlock.playSound(level, pos);
            CandyBagBlock.schedulePopTickIfPossible(state, level, pos);
            if (content == Content.OTHER_CANDY && (blockEntity = level.m_7702_(pos)) instanceof CandyBagTile) {
                CandyBagTile tile = (CandyBagTile)blockEntity;
                tile.setDisplayedItem(remove);
            }
            return true;
        }
        return false;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        CandyBagBlock.schedulePopTickIfPossible(state, level, pos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return PaperBagBlock.SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{CONTENT, FILL_LEVEL});
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        Item i;
        List list = super.m_49635_(state, builder);
        Object object = builder.m_287159_(LootContextParams.f_81462_);
        if (object instanceof CandyBagTile) {
            CandyBagTile tile = (CandyBagTile)((Object)object);
            list.add(tile.getDisplayedItem().m_41777_());
        }
        if ((i = this.getContent(state)) != null) {
            list.add(new ItemStack((ItemLike)i, ((Integer)state.m_61143_((Property)FILL_LEVEL)).intValue()));
        }
        return list;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack item;
        int fill = (Integer)state.m_61143_((Property)FILL_LEVEL);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CandyBagTile) {
            CandyBagTile tile = (CandyBagTile)blockEntity;
            item = tile.getDisplayedItem();
            if (item.m_41619_()) {
                item = null;
            }
        } else {
            item = new ItemStack((ItemLike)this.getContent(state), fill);
        }
        if (item == null) {
            return InteractionResult.PASS;
        }
        int delta = 0;
        ItemStack held = player.m_21120_(hand);
        if (player.m_6144_() && held.m_41619_()) {
            ItemStack extracted = item.m_41777_().m_41620_(1);
            if (!extracted.m_41619_()) {
                Utils.swapItem((Player)player, (InteractionHand)hand, (ItemStack)extracted);
                delta = -1;
            }
        } else if (fill != 6 && Content.get(held) == state.m_61143_(CONTENT)) {
            if (!player.m_7500_()) {
                held.m_41774_(1);
            }
            CandyBagBlock.playSound(level, pos);
            ++delta;
        } else if (item.m_41614_() && player.m_36391_(false) && !player.m_7500_()) {
            player.m_5584_(level, item.m_41777_());
            delta = -1;
            if (level.f_46443_) {
                ItemParticleOption particleOptions = new ItemParticleOption(ParticleTypes.f_123752_, item);
                double dy = 0.005 + (double)fill / 16.0;
                double power = 0.2;
                for (int i = 0; i < 12; ++i) {
                    level.m_7106_((ParticleOptions)particleOptions, (double)((float)pos.m_123341_() + 0.125f + level.f_46441_.m_188501_() * 12.0f / 16.0f), (double)pos.m_123342_() + dy, (double)((float)pos.m_123343_() + 0.125f + level.f_46441_.m_188501_() * 12.0f / 16.0f), ((double)level.f_46441_.m_188501_() - 0.5) * power, (double)level.f_46441_.m_188501_() * power * 0.7, ((double)level.f_46441_.m_188501_() - 0.5) * power);
                }
            }
        }
        if (delta != 0) {
            int newFill = fill + delta;
            if (newFill == 0) {
                level.m_46597_(pos, ModRegistry.PAPER_BAG.get().m_49966_());
            } else {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)FILL_LEVEL, (Comparable)Integer.valueOf(newFill)));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    private static void playSound(Level level, BlockPos pos) {
        level.m_5594_(null, pos, SoundEvents.f_11839_, SoundSource.PLAYERS, 1.0f, 1.2f);
    }

    @Nullable
    public Item getContent(BlockState state) {
        Optional i;
        Content c = (Content)((Object)state.m_61143_(CONTENT));
        if (c.drop != null && (i = BuiltInRegistries.f_257033_.m_6612_(new ResourceLocation(c.drop))).isPresent()) {
            return (Item)i.get();
        }
        return null;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block neighbor, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, level, pos, neighbor, fromPos, isMoving);
        if (state.m_61143_(CONTENT) == Content.KERNELS && CandyBagBlock.canCook(level.m_8055_(fromPos))) {
            level.m_186460_(pos, (Block)this, 200);
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        boolean canPop;
        if (state.m_61143_(CONTENT) == Content.KERNELS && (canPop = Arrays.stream(Direction.values()).anyMatch(d -> CandyBagBlock.canCook(level.m_8055_(pos.m_121945_(d)))))) {
            this.popCorn(state, level, pos);
            level.m_186460_(pos, (Block)this, 3);
        }
    }

    private static void schedulePopTickIfPossible(BlockState state, Level level, BlockPos pos) {
        boolean canPop = Arrays.stream(Direction.values()).anyMatch(d -> CandyBagBlock.canCook(level.m_8055_(pos.m_121945_(d))));
        if (canPop) {
            level.m_186460_(pos, state.m_60734_(), 200);
        }
    }

    private void popCorn(BlockState state, ServerLevel level, BlockPos pos) {
        int fill = (Integer)state.m_61143_((Property)FILL_LEVEL);
        ItemStack item = new ItemStack((ItemLike)ModRegistry.POP_CORN.get());
        level.m_7696_(pos, (Block)this, 1, 0);
        if (fill == 1) {
            level.m_46597_(pos, ModRegistry.PAPER_BAG.get().m_49966_());
        } else {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)FILL_LEVEL, (Comparable)Integer.valueOf(fill - 1)));
        }
        ItemEntity itemEntity = new ItemEntity((Level)level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.6, (double)pos.m_123343_() + 0.5, item);
        itemEntity.m_20334_(level.f_46441_.m_188500_() * 0.02, 0.08 + level.f_46441_.m_188500_() * 0.2, level.f_46441_.m_188500_() * 0.02);
        level.m_7967_((Entity)itemEntity);
        level.m_5594_(null, pos, SoundEvents.f_11928_, SoundSource.BLOCKS, 0.2f, 2.0f);
    }

    public boolean m_8133_(BlockState state, Level level, BlockPos pos, int id, int param) {
        if (id == 1) {
            if (level.f_46443_) {
                int fill = (Integer)state.m_61143_((Property)FILL_LEVEL);
                ItemStack item = new ItemStack((ItemLike)ModRegistry.POP_CORN.get());
                ItemParticleOption particleOptions = new ItemParticleOption(ParticleTypes.f_123752_, item);
                double dy = 0.005 + (double)fill / 16.0;
                double power = 0.3;
                for (int i = 0; i < 7; ++i) {
                    level.m_7106_((ParticleOptions)particleOptions, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + dy, (double)pos.m_123343_() + 0.5, ((double)level.f_46441_.m_188501_() - 0.5) * power, (double)level.f_46441_.m_188501_() * power + 0.2, ((double)level.f_46441_.m_188501_() - 0.5) * power);
                }
            }
            return true;
        }
        return super.m_8133_(state, level, pos, id, param);
    }

    private static boolean canCook(BlockState neighbor) {
        return neighbor.m_204336_(BlockTags.f_13087_) && (Boolean)neighbor.m_61143_((Property)CampfireBlock.f_51227_) != false || neighbor.m_60734_() instanceof FireBlock;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return state.m_61143_(CONTENT) == Content.OTHER_CANDY ? new CandyBagTile(pos, state) : null;
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return ModRegistry.PAPER_BAG.get().m_5456_().m_7968_();
    }

    public static enum Content implements StringRepresentable
    {
        CANDY("supplementaries:candy"),
        CANDY_CANE("snowyspirit:candy_cane"),
        CANDY_CORN("hauntedharvest:candy_corn"),
        POPCORN("hauntedharvest:popcorn"),
        KERNELS("hauntedharvest:kernels"),
        OTHER_CANDY(null);

        private final String drop;

        private Content(String drop) {
            this.drop = drop;
        }

        @Nullable
        public static Content get(ItemStack item) {
            if (item.m_41619_()) {
                return null;
            }
            String name = Utils.getID((Item)item.m_41720_()).toString();
            for (Content c : Content.values()) {
                if (c.drop == null || !c.drop.equals(name)) continue;
                return c;
            }
            if (item.m_204117_(ModTags.MODDED_CANDIES)) {
                return OTHER_CANDY;
            }
            return null;
        }

        public String m_7912_() {
            return this.toString().toLowerCase(Locale.ROOT);
        }
    }
}

