/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.ai;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.mehvahdjukaar.hauntedharvest.ai.IHarmlessProjectile;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ThrowEggs
extends Behavior<Villager> {
    private int cooldownBetweenAttacks;
    private int eggs;
    private final int maxRange;
    private int duration = 400;

    public ThrowEggs(int range) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT));
        this.maxRange = range;
    }

    protected boolean checkExtraStartConditions(ServerLevel pLevel, Villager pOwner) {
        LivingEntity livingentity = this.getAttackTarget((LivingEntity)pOwner);
        if (livingentity == null || !livingentity.m_6084_()) {
            ThrowEggs.clearAnger(pOwner);
            return false;
        }
        return BehaviorUtils.m_22667_((LivingEntity)pOwner, (LivingEntity)livingentity) && livingentity.m_20275_(pOwner.m_20185_(), pOwner.m_20186_(), pOwner.m_20189_()) < (double)(this.maxRange * this.maxRange);
    }

    protected boolean canStillUse(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        return this.eggs == 0 || this.checkExtraStartConditions(pLevel, pEntity);
    }

    protected void start(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        LivingEntity livingentity = this.getAttackTarget((LivingEntity)pEntity);
        BehaviorUtils.m_22595_((LivingEntity)pEntity, (LivingEntity)livingentity);
        ThrowEggs.displayAsHeldItem(pEntity, new ItemStack((ItemLike)Items.f_42521_));
        if (this.eggs == 0) {
            this.duration = 400;
            this.eggs = pLevel.f_46441_.m_188503_(2) + 1;
            this.cooldownBetweenAttacks = 35 + pLevel.f_46441_.m_188503_(30);
        }
    }

    protected void tick(ServerLevel pLevel, Villager pOwner, long pGameTime) {
        LivingEntity target = this.getAttackTarget((LivingEntity)pOwner);
        if (target == null) {
            return;
        }
        BehaviorUtils.m_22595_((LivingEntity)pOwner, (LivingEntity)target);
        if (this.cooldownBetweenAttacks-- == 0) {
            this.cooldownBetweenAttacks = 20 + pLevel.f_46441_.m_188503_(30);
            --this.eggs;
            ThrownEgg egg = new ThrownEgg((Level)pLevel, (LivingEntity)pOwner);
            if (egg instanceof IHarmlessProjectile) {
                IHarmlessProjectile e = (IHarmlessProjectile)egg;
                e.hauntedharvest$setHarmless(true);
            }
            double d0 = target.m_20186_() - 0.5;
            double d1 = target.m_20185_() - pOwner.m_20185_();
            double d2 = d0 - egg.m_20186_();
            double d3 = target.m_20189_() - pOwner.m_20189_();
            double distFactor = Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f;
            egg.m_6686_(d1, (d2 + distFactor) * 0.5, d3, 1.1f, 8.0f);
            pLevel.m_6263_(null, pOwner.m_20185_(), pOwner.m_20186_(), pOwner.m_20189_(), SoundEvents.f_11877_, SoundSource.NEUTRAL, 0.5f, 0.4f / (pLevel.m_213780_().m_188501_() * 0.4f + 0.8f));
            pLevel.m_7967_((Entity)egg);
            if (this.eggs <= 0) {
                ThrowEggs.clearAnger(pOwner);
            }
        }
        if (this.duration-- <= 0) {
            ThrowEggs.clearAnger(pOwner);
        }
    }

    public static void clearAnger(Villager pOwner) {
        pOwner.m_6274_().m_21936_(MemoryModuleType.f_26372_);
        ThrowEggs.displayAsHeldItem(pOwner, ItemStack.f_41583_);
    }

    private static void displayAsHeldItem(Villager self, ItemStack p_182372_) {
        self.m_8061_(EquipmentSlot.MAINHAND, p_182372_);
        self.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
    }

    protected void stop(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        super.m_6732_(pLevel, (LivingEntity)pEntity, pGameTime);
    }

    @Nullable
    private LivingEntity getAttackTarget(LivingEntity pMob) {
        return pMob.m_6274_().m_21952_(MemoryModuleType.f_26372_).orElse(null);
    }
}

